/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.protectedterms;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedTermsParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedTermsParser.class);
    private final List<String> terms = new ArrayList<String>();
    private String description = Localization.lang("The text after the last line starting with # will be used", new Object[0]);
    private String location;

    public void readTermsFromResource(String resourceFileName, String descriptionString) {
        try {
            Path path = Path.of(Objects.requireNonNull(ProtectedTermsLoader.class.getResource(Objects.requireNonNull(resourceFileName))).toURI());
            this.readTermsList(path);
            this.description = descriptionString;
            this.location = resourceFileName;
        }
        catch (URISyntaxException e1) {
            LOGGER.error("");
        }
    }

    public void readTermsFromFile(Path path) {
        this.location = path.toAbsolutePath().toString();
        this.readTermsList(path);
    }

    private void readTermsList(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("Could not read terms from file {}", (Object)path);
            return;
        }
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            this.terms.addAll(lines.map(this::setDescription).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        catch (IOException e) {
            LOGGER.warn("Could not read terms from file {}", (Object)path, (Object)e);
        }
    }

    private String setDescription(String line) {
        if (line.startsWith("#")) {
            this.description = line.substring(1).trim();
            return null;
        }
        return line;
    }

    public ProtectedTermsList getProtectTermsList(boolean enabled, boolean internal) {
        ProtectedTermsList termList = new ProtectedTermsList(this.description, this.terms, this.location, internal);
        termList.setEnabled(enabled);
        return termList;
    }
}

