/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.Comparator;
import java.util.List;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.bibtex.comparator.FieldComparatorStack;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.OOProcessAuthorYearMarkers;
import org.jabref.logic.openoffice.style.OOProcessCitationKeyMarkers;
import org.jabref.logic.openoffice.style.OOProcessNumericMarkers;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.openoffice.style.CitationGroups;

public class OOProcess {
    static final Comparator<BibEntry> AUTHOR_YEAR_TITLE_COMPARATOR = OOProcess.makeAuthorYearTitleComparator();
    static final Comparator<BibEntry> YEAR_AUTHOR_TITLE_COMPARATOR = OOProcess.makeYearAuthorTitleComparator();

    private OOProcess() {
    }

    private static Comparator<BibEntry> makeAuthorYearTitleComparator() {
        List<FieldComparator> ayt = List.of(new FieldComparator(StandardField.AUTHOR), new FieldComparator(StandardField.YEAR), new FieldComparator(StandardField.TITLE));
        return new FieldComparatorStack<BibEntry>(ayt);
    }

    private static Comparator<BibEntry> makeYearAuthorTitleComparator() {
        List<FieldComparator> yat = List.of(new FieldComparator(StandardField.YEAR), new FieldComparator(StandardField.AUTHOR), new FieldComparator(StandardField.TITLE));
        return new FieldComparatorStack<BibEntry>(yat);
    }

    public static Comparator<BibEntry> comparatorForMulticite(OOBibStyle style) {
        if (style.getMultiCiteChronological()) {
            return YEAR_AUTHOR_TITLE_COMPARATOR;
        }
        return AUTHOR_YEAR_TITLE_COMPARATOR;
    }

    public static void produceCitationMarkers(CitationGroups citationGroups, List<BibDatabase> databases, OOBibStyle style) {
        if (!citationGroups.hasGlobalOrder()) {
            throw new IllegalStateException("produceCitationMarkers: globalOrder is misssing in citationGroups");
        }
        citationGroups.lookupCitations(databases);
        citationGroups.imposeLocalOrder(OOProcess.comparatorForMulticite(style));
        if (style.isCitationKeyCiteMarkers()) {
            OOProcessCitationKeyMarkers.produceCitationMarkers(citationGroups, style);
        } else if (style.isNumberEntries()) {
            OOProcessNumericMarkers.produceCitationMarkers(citationGroups, style);
        } else {
            OOProcessAuthorYearMarkers.produceCitationMarkers(citationGroups, style);
        }
    }
}

