/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.backend;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.model.openoffice.style.CitationType;

class Codec52 {
    private static final String BIB_CITATION = "JR_cite";
    private static final Pattern CITE_PATTERN = Pattern.compile("JR_cite(\\d*)_([123])_(.*)");

    private Codec52() {
    }

    private static CitationType citationTypeFromInt(int code) {
        return switch (code) {
            case 1 -> CitationType.AUTHORYEAR_PAR;
            case 2 -> CitationType.AUTHORYEAR_INTEXT;
            case 3 -> CitationType.INVISIBLE_CIT;
            default -> throw new IllegalArgumentException("Invalid CitationType code");
        };
    }

    private static int citationTypeToInt(CitationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CitationType.AUTHORYEAR_PAR -> 1;
            case CitationType.AUTHORYEAR_INTEXT -> 2;
            case CitationType.INVISIBLE_CIT -> 3;
        };
    }

    public static String getUniqueMarkName(Set<String> usedNames, List<String> citationKeys, CitationType citationType) {
        String citationKeysPart = String.join((CharSequence)",", citationKeys);
        int index = 0;
        int citTypeCode = Codec52.citationTypeToInt(citationType);
        String name = "JR_cite_" + citTypeCode + "_" + citationKeysPart;
        while (usedNames.contains(name)) {
            name = BIB_CITATION + index + "_" + citTypeCode + "_" + citationKeysPart;
            ++index;
        }
        return name;
    }

    public static Optional<ParsedMarkName> parseMarkName(String refMarkName) {
        Matcher citeMatcher = CITE_PATTERN.matcher(refMarkName);
        if (!citeMatcher.find()) {
            return Optional.empty();
        }
        List<String> keys = Arrays.asList(citeMatcher.group(3).split(","));
        String index = citeMatcher.group(1);
        int citTypeCode = Integer.parseInt(citeMatcher.group(2));
        CitationType citationType = Codec52.citationTypeFromInt(citTypeCode);
        return Optional.of(new ParsedMarkName(index, citationType, keys));
    }

    public static boolean isJabRefReferenceMarkName(String name) {
        return CITE_PATTERN.matcher(name).find();
    }

    public static List<String> filterIsJabRefReferenceMarkName(List<String> names) {
        return names.stream().filter(Codec52::isJabRefReferenceMarkName).collect(Collectors.toList());
    }

    public static class ParsedMarkName {
        public final String index;
        public final CitationType citationType;
        public final List<String> citationKeys;

        ParsedMarkName(String index, CitationType citationType, List<String> citationKeys) {
            Objects.requireNonNull(index);
            Objects.requireNonNull(citationKeys);
            this.index = index;
            this.citationType = citationType;
            this.citationKeys = citationKeys;
        }
    }
}

