/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.action;

import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextDocument;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jabref.logic.openoffice.frontend.OOFrontend;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.openoffice.style.CitedKey;
import org.jabref.model.openoffice.style.CitedKeys;
import org.jabref.model.openoffice.uno.NoDocumentException;

public class ExportCited {
    private ExportCited() {
    }

    public static GenerateDatabaseResult generateDatabase(XTextDocument doc, List<BibDatabase> databases) throws NoDocumentException, WrappedTargetException {
        OOFrontend frontend = new OOFrontend(doc);
        CitedKeys citationKeys = frontend.citationGroups.getCitedKeysUnordered();
        citationKeys.lookupInDatabases(databases);
        ArrayList<String> unresolvedKeys = new ArrayList<String>();
        BibDatabase resultDatabase = new BibDatabase();
        ArrayList<BibEntry> entriesToInsert = new ArrayList<BibEntry>();
        HashSet seen = new HashSet();
        for (CitedKey citation : citationKeys.values()) {
            if (citation.getLookupResult().isEmpty()) {
                unresolvedKeys.add(citation.citationKey);
                continue;
            }
            BibEntry entry = citation.getLookupResult().get().entry;
            BibDatabase loopDatabase = citation.getLookupResult().get().database;
            BibEntry clonedEntry = (BibEntry)entry.clone();
            entriesToInsert.add(clonedEntry);
            clonedEntry.getField(StandardField.CROSSREF).ifPresent(crossReference -> {
                boolean isNew;
                boolean bl = isNew = !seen.contains(crossReference);
                if (isNew) {
                    loopDatabase.getEntryByCitationKey((String)crossReference).ifPresent(entriesToInsert::add);
                    seen.add(crossReference);
                }
            });
        }
        resultDatabase.insertEntries(entriesToInsert);
        return new GenerateDatabaseResult(unresolvedKeys, resultDatabase);
    }

    public static class GenerateDatabaseResult {
        public final List<String> unresolvedKeys;
        public final BibDatabase newDatabase;

        GenerateDatabaseResult(List<String> unresolvedKeys, BibDatabase newDatabase) {
            this.unresolvedKeys = unresolvedKeys;
            this.newDatabase = newDatabase;
        }
    }
}

