/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeFileSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenOfficeFileSearch.class);

    public static List<Path> detectInstallations() {
        if (OS.WINDOWS) {
            List<Path> programDirs = OpenOfficeFileSearch.findWindowsOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice.exe", dir).isPresent()).toList();
        }
        if (OS.OS_X) {
            List<Path> programDirs = OpenOfficeFileSearch.findOSXOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice", dir).isPresent()).toList();
        }
        if (OS.LINUX) {
            List<Path> programDirs = OpenOfficeFileSearch.findLinuxOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice", dir).isPresent()).toList();
        }
        return List.of();
    }

    private static List<Path> findOpenOfficeDirectories(List<Path> programDirectories) {
        BiPredicate<Path, BasicFileAttributes> filePredicate = (path, attr) -> attr.isDirectory() && (path.toString().toLowerCase(Locale.ROOT).contains("openoffice") || path.toString().toLowerCase(Locale.ROOT).contains("libreoffice"));
        return programDirectories.stream().flatMap(dirs -> {
            try {
                return Files.find(dirs, 1, filePredicate, new FileVisitOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Problem searching for openoffice/libreoffice install directory", (Throwable)e);
                return Stream.empty();
            }
        }).toList();
    }

    private static List<Path> findWindowsOpenOfficeDirs() {
        ArrayList<Path> sourceList = new ArrayList<Path>();
        String progFiles = System.getenv("ProgramFiles");
        if (progFiles != null) {
            sourceList.add(Path.of(progFiles, new String[0]));
        }
        if ((progFiles = System.getenv("ProgramFiles(x86)")) != null) {
            sourceList.add(Path.of(progFiles, new String[0]));
        }
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList).stream().map(dir -> dir.resolve("program")).toList();
    }

    private static List<Path> findOSXOpenOfficeDirs() {
        List<Path> sourceList = Collections.singletonList(Path.of("/Applications", new String[0]));
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList);
    }

    private static List<Path> findLinuxOpenOfficeDirs() {
        List<Path> sourceList = Arrays.asList(Path.of("/usr/lib", new String[0]), Path.of("/usr/lib64", new String[0]), Path.of("/opt", new String[0]));
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList);
    }
}

