/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;

public class ProgressInputStream
extends FilterInputStream {
    private final long maxNumBytes;
    private final LongProperty totalNumBytesRead = new SimpleLongProperty(0L);
    private final LongProperty progress = new SimpleLongProperty(0L);

    public ProgressInputStream(InputStream in, long maxNumBytes) {
        super(in);
        this.maxNumBytes = maxNumBytes <= 0L ? 1L : maxNumBytes;
        this.progress.bind((ObservableValue)this.totalNumBytesRead.divide(this.maxNumBytes));
    }

    public long getTotalNumBytesRead() {
        return this.totalNumBytesRead.get();
    }

    public LongProperty totalNumBytesReadProperty() {
        return this.totalNumBytesRead;
    }

    public long getProgress() {
        return this.progress.get();
    }

    public LongProperty progressProperty() {
        return this.progress;
    }

    public long getMaxNumBytes() {
        return this.maxNumBytes;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.updateProgress(1L);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.updateProgress(super.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.updateProgress(super.skip(n));
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private long updateProgress(long numBytesRead) {
        if (numBytesRead > 0L) {
            this.totalNumBytesRead.set(this.totalNumBytesRead.get() + numBytesRead);
        }
        return numBytesRead;
    }
}

