/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import org.jabref.logic.formatter.bibtexfields.RemoveEnclosingBracesFormatter;
import org.jabref.model.entry.Author;

public class MsBibAuthor {
    private static final RemoveEnclosingBracesFormatter REMOVE_BRACES_FORMATTER = new RemoveEnclosingBracesFormatter();
    private String firstName;
    private String middleName;
    private final Author author;
    private boolean isCorporate;

    public MsBibAuthor(Author author) {
        this.author = author;
        StringBuilder sb = new StringBuilder();
        author.getGivenName().ifPresent(firstNames -> {
            String[] names = firstNames.split(" ");
            for (int i = 1; i < names.length; ++i) {
                sb.append(names[i]);
                sb.append(" ");
            }
            this.middleName = sb.toString().trim();
            this.firstName = names[0];
        });
    }

    public MsBibAuthor(Author author, boolean isCorporate) {
        this(author);
        this.isCorporate = isCorporate;
    }

    public String getFirstName() {
        if (!"".equals(this.firstName)) {
            return this.firstName;
        }
        return this.author.getGivenName().orElse(null);
    }

    public String getMiddleName() {
        if ("".equals(this.middleName)) {
            return null;
        }
        return this.middleName;
    }

    public String getLastName() {
        return REMOVE_BRACES_FORMATTER.format(this.author.getNamePrefixAndFamilyName());
    }

    public String getFirstLast() {
        return this.author.getGivenFamily(false);
    }

    public String getLastFirst() {
        return this.author.getFamilyGiven(false);
    }

    public boolean isCorporate() {
        return this.isCorporate;
    }
}

