/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabref.logic.msbib.BibTeXConverter;
import org.jabref.logic.msbib.MSBibConverter;
import org.jabref.logic.msbib.MSBibEntry;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MSBibDatabase {
    public static final String NAMESPACE = "http://schemas.openxmlformats.org/officeDocument/2006/bibliography";
    public static final String PREFIX = "b:";
    private static final Logger LOGGER = LoggerFactory.getLogger(MSBibDatabase.class);
    private final DocumentBuilderFactory factory;
    private Set<MSBibEntry> entriesForExport = new HashSet<MSBibEntry>();

    public MSBibDatabase() {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public MSBibDatabase(BibDatabase database, List<BibEntry> entries) {
        this();
        if (entries == null) {
            List<BibEntry> resolvedEntries = database.resolveForStrings((Collection<BibEntry>)database.getEntries(), false);
            this.setEntriesForExport(resolvedEntries);
        } else {
            List<BibEntry> resolvedEntries = database.resolveForStrings(entries, false);
            this.setEntriesForExport(resolvedEntries);
        }
    }

    public List<BibEntry> importEntriesFromXml(BufferedReader reader) {
        Document inputDocument;
        this.entriesForExport = new HashSet<MSBibEntry>();
        try {
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            inputDocument = documentBuilder.parse(new InputSource(reader));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.warn("Could not parse document", (Throwable)e);
            return Collections.emptyList();
        }
        NodeList rootList = inputDocument.getElementsByTagNameNS("*", "Sources");
        if (rootList.getLength() == 0) {
            rootList = inputDocument.getElementsByTagNameNS("*", "Sources");
        }
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        if (rootList.getLength() == 0) {
            return bibitems;
        }
        NodeList sourceList = ((Element)rootList.item(0)).getElementsByTagNameNS("*", "Source");
        for (int i = 0; i < sourceList.getLength(); ++i) {
            MSBibEntry entry = new MSBibEntry((Element)sourceList.item(i));
            this.entriesForExport.add(entry);
            bibitems.add(BibTeXConverter.convert(entry));
        }
        return bibitems;
    }

    private void setEntriesForExport(List<BibEntry> entriesToAdd) {
        this.entriesForExport = new HashSet<MSBibEntry>();
        for (BibEntry entry : entriesToAdd) {
            MSBibEntry newMods = MSBibConverter.convert(entry);
            this.entriesForExport.add(newMods);
        }
    }

    public Document getDomForExport() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element rootNode = document.createElementNS(NAMESPACE, "b:Sources");
            rootNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
            rootNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + PREFIX.substring(0, PREFIX.length() - 1), NAMESPACE);
            rootNode.setAttribute("SelectedStyle", "");
            for (MSBibEntry entry : this.entriesForExport) {
                Element node = entry.getEntryDom(document);
                rootNode.appendChild(node);
            }
            document.appendChild(rootNode);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn("Could not build XML document", (Throwable)e);
        }
        return document;
    }
}

