/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jabref.logic.layout.ParamLayoutFormatter;
import org.jabref.logic.util.strings.HTMLUnicodeConversionMaps;
import org.jabref.model.strings.StringUtil;

public class HTMLChars
implements ParamLayoutFormatter {
    private static final Map<String, String> HTML_CHARS = HTMLUnicodeConversionMaps.LATEX_HTML_CONVERSION_MAP;
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("&(?!(?:[a-z0-9]+|#[0-9]{1,6}|#x[0-9a-fA-F]{1,6});)");
    private boolean keepCurlyBraces = false;

    @Override
    public void setArgument(String arg) {
        if ("keepCurlyBraces".equalsIgnoreCase(arg)) {
            this.keepCurlyBraces = true;
        }
    }

    @Override
    public String format(String inField) {
        String field = this.normalizedField(inField);
        StringBuilder sb = new StringBuilder();
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String result;
            String part;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = HTML_CHARS.get(command);
                    sb.append(Objects.requireNonNullElse(result2, command));
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!this.keepCurlyBraces && !incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && "\"`^~'=.|".contains(currentCommand.toString())) {
                    String commandBody;
                    if (i >= field.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        part = StringUtil.getPart(field, i, false);
                        i += this.keepCurlyBraces ? part.length() + 1 : part.length();
                        commandBody = part;
                    } else {
                        commandBody = field.substring(i, i + 1);
                    }
                    result = HTML_CHARS.get(command + commandBody);
                    sb.append(Objects.requireNonNullElse(result, commandBody));
                    incommand = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = HTML_CHARS.get(command);
                sb.append(Objects.requireNonNullElse(result2, command));
                continue;
            }
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                command = currentCommand.toString();
                String tag = this.getHTMLTag(command);
                if (!tag.isEmpty()) {
                    part = StringUtil.getPart(field, i, true);
                    if (this.keepCurlyBraces && (c == '{' || c == '}')) {
                        ++i;
                    }
                    i += part.length();
                    sb.append('<').append(tag).append('>').append(part).append("</").append(tag).append('>');
                } else if (c == '{') {
                    String argument = StringUtil.getPart(field, i, true);
                    i += this.keepCurlyBraces ? argument.length() + 1 : argument.length();
                    String result3 = HTML_CHARS.get(command + argument);
                    if (result3 == null) {
                        if (argument.isEmpty()) {
                            sb.append(command);
                        } else {
                            sb.append(argument);
                        }
                    } else {
                        sb.append(result3);
                    }
                } else if (c == '}') {
                    result = HTML_CHARS.get(command);
                    sb.append(Objects.requireNonNullElse(result, command));
                    if (this.keepCurlyBraces) {
                        sb.append(c);
                    }
                } else {
                    result = HTML_CHARS.get(command);
                    sb.append(Objects.requireNonNullElse(result, command));
                    sb.append(' ');
                }
            } else {
                sb.append(c);
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString().replace("~", "&nbsp;");
    }

    private String normalizedField(String inField) {
        return HTML_ENTITY_PATTERN.matcher(inField).replaceAll("&amp;").replaceAll("\\\\&", "&amp;").replaceAll("[\\n]{2,}", "<p>").replace("\n", "<br>").replace("\\$", "&dollar;").replaceAll("\\$([^$]*)\\$", this.keepCurlyBraces ? "\\\\{$1\\\\}" : "$1}");
    }

    private String getHTMLTag(String latexCommand) {
        String result = "";
        switch (latexCommand) {
            case "textit": 
            case "it": {
                result = "i";
                break;
            }
            case "emph": 
            case "em": {
                result = "em";
                break;
            }
            case "textbf": 
            case "bf": {
                result = "b";
                break;
            }
            case "underline": {
                result = "u";
                break;
            }
            case "sout": {
                result = "s";
                break;
            }
            case "texttt": {
                result = "tt";
                break;
            }
            case "textsuperscript": {
                result = "sup";
                break;
            }
            case "textsubscript": {
                result = "sub";
                break;
            }
        }
        return result;
    }
}

