/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class UTF8Checker
implements EntryChecker {
    private final Charset charset;

    public UTF8Checker(Charset charset) {
        this.charset = charset;
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<Field, String> field : entry.getFieldMap().entrySet()) {
            boolean utfOnly = UTF8Checker.UTF8EncodingChecker(field.getValue().getBytes(this.charset));
            if (utfOnly) continue;
            results.add(new IntegrityMessage(Localization.lang("Non-UTF-8 encoded field found", new Object[0]), entry, field.getKey()));
        }
        return results;
    }

    public static boolean UTF8EncodingChecker(byte[] data) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            decoder.decode(ByteBuffer.wrap(data));
        }
        catch (CharacterCodingException ex) {
            return false;
        }
        return true;
    }
}

