/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javafx.util.Pair;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorGroup;
import uk.ac.ed.ph.snuggletex.definitions.Globals;

public class LatexIntegrityChecker
implements EntryChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnuggleSession.class);
    private static final SnuggleEngine ENGINE = new SnuggleEngine();
    private static final SnuggleSession SESSION;
    private static final ResourceBundle ERROR_MESSAGES;
    private static final Set<ErrorCode> EXCLUDED_ERRORS;

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        return entry.getFieldMap().entrySet().stream().filter(field -> FieldFactory.isLatexField((Field)field.getKey())).flatMap(LatexIntegrityChecker::getUnescapedAmpersandsWithCount).filter(pair -> !((InputError)pair.getValue()).getErrorCode().getErrorGroup().equals((Object)CoreErrorGroup.TDE)).filter(pair -> !EXCLUDED_ERRORS.contains(((InputError)pair.getValue()).getErrorCode())).map(pair -> new IntegrityMessage(LatexIntegrityChecker.errorMessageFormatHelper(((InputError)pair.getValue()).getErrorCode(), ((InputError)pair.getValue()).getArguments()), entry, (Field)pair.getKey())).toList();
    }

    private static Stream<Pair<Field, InputError>> getUnescapedAmpersandsWithCount(Map.Entry<Field, String> entry) {
        SESSION.reset();
        SnuggleInput input = new SnuggleInput(entry.getValue());
        try {
            SESSION.parseInput(input);
        }
        catch (IOException e) {
            LOGGER.error("Error at parsing", (Throwable)e);
            return Stream.empty();
        }
        if (SESSION.getErrors().isEmpty()) {
            return Stream.empty();
        }
        InputError error = (InputError)SESSION.getErrors().getFirst();
        return Stream.of(new Pair((Object)entry.getKey(), (Object)error));
    }

    public static String errorMessageFormatHelper(ErrorCode snuggleTexErrorCode, Object ... arguments) {
        String snuggletexMessagePattern = ERROR_MESSAGES.getString(snuggleTexErrorCode.getName());
        String snuggletexErrorMessage = MessageFormat.format(snuggletexMessagePattern, arguments);
        return Localization.lang("LaTeX Warning: %0", snuggletexErrorMessage);
    }

    static {
        ERROR_MESSAGES = ((SnugglePackage)ENGINE.getPackages().getFirst()).getErrorMessageBundle();
        EXCLUDED_ERRORS = new HashSet<ErrorCode>();
        SnugglePackage snugglePackage = (SnugglePackage)ENGINE.getPackages().getFirst();
        snugglePackage.addComplexCommand("textgreater", false, 0, Globals.TEXT_MODE_ONLY, null, null, null);
        snugglePackage.addComplexCommand("textless", false, 0, Globals.TEXT_MODE_ONLY, null, null, null);
        snugglePackage.addComplexCommand("textbackslash", false, 0, Globals.TEXT_MODE_ONLY, null, null, null);
        snugglePackage.addComplexCommand("textbar", false, 0, Globals.TEXT_MODE_ONLY, null, null, null);
        SESSION = ENGINE.createSession();
        SESSION.getConfiguration().setFailingFast(true);
        EXCLUDED_ERRORS.add((ErrorCode)CoreErrorCode.TTEG04);
    }
}

