/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.formatter.casechanger.TitleCaseFormatter;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsiImporter
extends Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsiImporter.class);
    private static final Pattern SUB_SUP_PATTERN = Pattern.compile("/(sub|sup)\\s+(.*?)\\s*/");
    private static final Pattern ISI_PATTERN = Pattern.compile("FN ISI Export Format|VR 1.|PY \\d{4}");
    private static final String EOL = "EOLEOL";
    private static final Pattern EOL_PATTERN = Pattern.compile("EOLEOL");

    @Override
    public String getName() {
        return "ISI";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.ISI;
    }

    @Override
    public String getId() {
        return "isi";
    }

    @Override
    public String getDescription() {
        return "Importer for the ISI Web of Science, INSPEC and Medline format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!ISI_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    public static void processSubSup(Map<Field, String> map) {
        Field[] subsup;
        for (Field aSubsup : subsup = new Field[]{StandardField.TITLE, StandardField.ABSTRACT, StandardField.COMMENT, new UnknownField("notes")}) {
            if (!map.containsKey(aSubsup)) continue;
            Matcher m = SUB_SUP_PATTERN.matcher(map.get(aSubsup));
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                Object group2 = m.group(2);
                if (((String)(group2 = ((String)group2).replaceAll("\\$", "\\\\\\\\\\\\\\$"))).length() > 1) {
                    group2 = "{" + (String)group2 + "}";
                }
                if ("sub".equals(m.group(1))) {
                    m.appendReplacement(sb, "\\$_" + (String)group2 + "\\$");
                    continue;
                }
                m.appendReplacement(sb, "\\$^" + (String)group2 + "\\$");
            }
            m.appendTail(sb);
            map.put(aSubsup, sb.toString());
        }
    }

    private static void processCapitalization(Map<Field, String> map) {
        Field[] subsup;
        for (Field aSubsup : subsup = new Field[]{StandardField.TITLE, StandardField.JOURNAL, StandardField.PUBLISHER}) {
            String s;
            if (!map.containsKey(aSubsup) || !(s = map.get(aSubsup)).toUpperCase(Locale.ROOT).equals(s)) continue;
            s = new TitleCaseFormatter().format(s);
            map.put(aSubsup, s);
        }
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        Objects.requireNonNull(reader);
        ArrayList<BibEntry> bibEntries = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 3) continue;
            if ("PT ".equals(str.substring(0, 3))) {
                sb.append("::").append(str);
                continue;
            }
            String beg = str.substring(0, 3).trim();
            if (beg.length() == 2) {
                sb.append(" ## ");
                sb.append(str);
                continue;
            }
            sb.append(EOL);
            sb.append(str.trim());
        }
        String[] entries = sb.toString().split("::");
        HashMap<Field, String> hm = new HashMap<Field, String>();
        for (String entry : entries) {
            String[] fields = entry.split(" ## ");
            if (fields.length == 0) {
                fields = entry.split("\n");
            }
            EntryType type = BibEntry.DEFAULT_TYPE;
            String PT = "";
            Object pages = "";
            hm.clear();
            block50: for (String string : fields) {
                if (string.length() <= 2) continue;
                String beg = string.substring(0, 2);
                String value = string.substring(3);
                if (value.startsWith(" - ")) {
                    value = value.substring(3);
                }
                value = value.trim();
                switch (beg) {
                    case "PT": {
                        PT = value.startsWith("J") ? "article" : value;
                        type = StandardEntryType.Article;
                        continue block50;
                    }
                    case "TY": {
                        if ("JOUR".equals(value)) {
                            type = StandardEntryType.Article;
                            continue block50;
                        }
                        if (!"CONF".equals(value)) continue block50;
                        type = StandardEntryType.InProceedings;
                        continue block50;
                    }
                    case "JO": {
                        hm.put(StandardField.BOOKTITLE, value);
                        continue block50;
                    }
                    case "AU": {
                        Object author = IsiImporter.isiAuthorsConvert(EOL_PATTERN.matcher(value).replaceAll(" and "));
                        if (hm.get(StandardField.AUTHOR) != null) {
                            author = (String)hm.get(StandardField.AUTHOR) + " and " + (String)author;
                        }
                        hm.put(StandardField.AUTHOR, (String)author);
                        continue block50;
                    }
                    case "TI": {
                        hm.put(StandardField.TITLE, EOL_PATTERN.matcher(value).replaceAll(" "));
                        continue block50;
                    }
                    case "SO": 
                    case "JA": {
                        hm.put(StandardField.JOURNAL, EOL_PATTERN.matcher(value).replaceAll(" "));
                        continue block50;
                    }
                    case "ID": 
                    case "KW": {
                        value = EOL_PATTERN.matcher(value).replaceAll(" ");
                        Object existingKeywords = (String)hm.get(StandardField.KEYWORDS);
                        existingKeywords = existingKeywords == null || ((String)existingKeywords).contains(value) ? value : (String)existingKeywords + ", " + value;
                        hm.put(StandardField.KEYWORDS, (String)existingKeywords);
                        continue block50;
                    }
                    case "AB": {
                        hm.put(StandardField.ABSTRACT, EOL_PATTERN.matcher(value).replaceAll(" "));
                        continue block50;
                    }
                    case "BP": 
                    case "BR": 
                    case "SP": {
                        pages = value;
                        continue block50;
                    }
                    case "EP": {
                        int detpos = value.indexOf(32);
                        if (detpos != -1 && !value.substring(0, detpos).trim().isEmpty()) {
                            value = value.substring(0, detpos);
                        }
                        pages = (String)pages + "--" + value;
                        continue block50;
                    }
                    case "PS": {
                        pages = IsiImporter.parsePages(value);
                        continue block50;
                    }
                    case "AR": {
                        pages = value;
                        continue block50;
                    }
                    case "IS": {
                        hm.put(StandardField.NUMBER, value);
                        continue block50;
                    }
                    case "PY": {
                        hm.put(StandardField.YEAR, value);
                        continue block50;
                    }
                    case "VL": {
                        hm.put(StandardField.VOLUME, value);
                        continue block50;
                    }
                    case "PU": {
                        hm.put(StandardField.PUBLISHER, value);
                        continue block50;
                    }
                    case "DI": {
                        hm.put(StandardField.DOI, value);
                        continue block50;
                    }
                    case "PD": {
                        String month = IsiImporter.parseMonth(value);
                        if (month == null) continue block50;
                        hm.put(StandardField.MONTH, month);
                        continue block50;
                    }
                    case "DT": {
                        if ("Review".equals(value)) {
                            type = StandardEntryType.Article;
                            continue block50;
                        }
                        if (value.startsWith("Article") || value.startsWith("Journal") || "article".equals(PT)) {
                            type = StandardEntryType.Article;
                            continue block50;
                        }
                        type = BibEntry.DEFAULT_TYPE;
                        continue block50;
                    }
                    case "CR": {
                        hm.put(new UnknownField("CitedReferences"), EOL_PATTERN.matcher(value).replaceAll(" ; ").trim());
                        continue block50;
                    }
                    default: {
                        if ("ER".equals(beg) || "EF".equals(beg) || "VR".equals(beg) || "FN".equals(beg)) continue block50;
                        hm.put(FieldFactory.parseField(type, beg), value);
                    }
                }
            }
            if (!((String)pages).isEmpty()) {
                hm.put(StandardField.PAGES, (String)pages);
            }
            if (hm.isEmpty()) continue;
            BibEntry b = new BibEntry(type);
            ArrayList<Field> toRemove = new ArrayList<Field>();
            for (Map.Entry entry2 : hm.entrySet()) {
                String content = (String)entry2.getValue();
                if (content != null && !content.trim().isEmpty()) continue;
                toRemove.add((Field)entry2.getKey());
            }
            for (Field field : toRemove) {
                hm.remove(field);
            }
            IsiImporter.processSubSup(hm);
            IsiImporter.processCapitalization(hm);
            b.setField(hm);
            bibEntries.add(b);
        }
        return new ParserResult(bibEntries);
    }

    private static String parsePages(String value) {
        return value.replace("-", "--");
    }

    static String parseMonth(String value) {
        String[] parts;
        for (String part1 : parts = value.split("\\s|\\-")) {
            Optional<Month> month = Month.getMonthByShortName(part1.toLowerCase(Locale.ROOT));
            if (!month.isPresent()) continue;
            return month.get().getJabRefFormat();
        }
        for (String part : parts) {
            try {
                int number = Integer.parseInt(part);
                Optional<Month> month = Month.getMonthByNumber(number);
                if (!month.isPresent()) continue;
                return month.get().getJabRefFormat();
            }
            catch (NumberFormatException e) {
                LOGGER.info("The import file in ISI format cannot parse part of the content in PD into integers (If there is no month or PD displayed in the imported entity, this may be the reason)", (Throwable)e);
            }
        }
        return null;
    }

    public static String isiAuthorConvert(String author) {
        String[] s = author.split(",");
        if (s.length != 2) {
            return author;
        }
        StringBuilder sb = new StringBuilder();
        String last = s[0].trim();
        sb.append(last).append(", ");
        String first = s[1].trim();
        String[] firstParts = first.split("\\s+");
        for (int i = 0; i < firstParts.length; ++i) {
            first = firstParts[i];
            if (first.toUpperCase(Locale.ROOT).equals(first)) {
                first = first.replace(".", "");
                for (int j = 0; j < first.length(); ++j) {
                    sb.append(first.charAt(j)).append('.');
                    if (j >= first.length() - 1) continue;
                    sb.append(' ');
                }
            } else {
                sb.append(first);
            }
            if (i >= firstParts.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String[] isiAuthorsConvert(String[] authors) {
        String[] result = new String[authors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = IsiImporter.isiAuthorConvert(authors[i]);
        }
        return result;
    }

    public static String isiAuthorsConvert(String authors) {
        CharSequence[] s = IsiImporter.isiAuthorsConvert(authors.split(" and |;"));
        return String.join((CharSequence)" and ", s);
    }
}

