/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.entry.types.StandardEntryType;

public class InspecImporter
extends Importer {
    private static final Pattern INSPEC_PATTERN = Pattern.compile("Record.*INSPEC.*");

    @Override
    public String getName() {
        return "INSPEC";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "INSPEC format importer.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!INSPEC_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 2) continue;
            if (str.indexOf("Record") == 0) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        String[] entries = sb.toString().split("__::__");
        EntryType type = BibEntry.DEFAULT_TYPE;
        HashMap<Field, String> h = new HashMap<Field, String>();
        for (String entry : entries) {
            String[] fields;
            if (entry.indexOf("Record") != 0) continue;
            h.clear();
            block20: for (String s : fields = entry.split("__NEWFIELD__")) {
                String f3 = s.substring(0, 2);
                String frest = s.substring(5);
                switch (f3) {
                    case "TI": {
                        h.put(StandardField.TITLE, frest);
                        continue block20;
                    }
                    case "PY": {
                        h.put(StandardField.YEAR, frest);
                        continue block20;
                    }
                    case "AU": {
                        h.put(StandardField.AUTHOR, AuthorList.fixAuthorLastNameFirst(frest.replace(",-", ", ").replace(";", " and ")));
                        continue block20;
                    }
                    case "AB": {
                        h.put(StandardField.ABSTRACT, frest);
                        continue block20;
                    }
                    case "ID": {
                        h.put(StandardField.KEYWORDS, frest);
                        continue block20;
                    }
                    case "SO": {
                        int m = frest.indexOf(46);
                        if (m < 0) continue block20;
                        String jr = frest.substring(0, m);
                        h.put(StandardField.JOURNAL, jr.replace("-", " "));
                        frest = frest.substring(m);
                        m = frest.indexOf(59);
                        if (m < 5) continue block20;
                        String yr = frest.substring(m - 5, m).trim();
                        h.put(StandardField.YEAR, yr);
                        frest = frest.substring(m);
                        m = frest.indexOf(58);
                        if (m < 0) continue block20;
                        String pg = frest.substring(m + 1).trim();
                        h.put(StandardField.PAGES, pg);
                        String vol = frest.substring(1, m).trim();
                        h.put(StandardField.VOLUME, vol);
                        continue block20;
                    }
                    case "RT": {
                        frest = frest.trim();
                        type = "Journal-Paper".equals(frest) ? StandardEntryType.Article : ("Conference-Paper".equals(frest) || "Conference-Paper; Journal-Paper".equals(frest) ? StandardEntryType.InProceedings : EntryTypeFactory.parse(frest.replace(" ", "")));
                    }
                }
            }
            BibEntry b = new BibEntry(type);
            b.setField(h);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }
}

