/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.StandardEntryType;

public class CopacImporter
extends Importer {
    private static final Pattern COPAC_PATTERN = Pattern.compile("^\\s*TI- ");

    @Override
    public String getName() {
        return "Copac";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getId() {
        return "cpc";
    }

    @Override
    public String getDescription() {
        return "Importer for COPAC format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!COPAC_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    private static void setOrAppend(BibEntry b, Field field, String value, String separator) {
        if (b.hasField(field) && b.getField(field).isPresent()) {
            b.setField(field, b.getField(field).get() + separator + value);
        } else {
            b.setField(field, value);
        }
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        Objects.requireNonNull(reader);
        LinkedList<String> entries = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 4) continue;
            String code = str.substring(0, 4);
            if ("    ".equals(code)) {
                sb.append(' ').append(str.trim());
                continue;
            }
            if ("TI- ".equals(str.substring(0, 4))) {
                if (!sb.isEmpty()) {
                    entries.add(sb.toString());
                }
                sb = new StringBuilder();
            }
            sb.append('\n').append(str);
        }
        if (!sb.isEmpty()) {
            entries.add(sb.toString());
        }
        LinkedList<BibEntry> results = new LinkedList<BibEntry>();
        for (String entry : entries) {
            String[] lines;
            BibEntry b = new BibEntry(StandardEntryType.Book);
            block26: for (String line1 : lines = entry.split("\n")) {
                String code;
                String line = line1.trim();
                if (line.length() < 4) continue;
                switch (code = line.substring(0, 4)) {
                    case "TI- ": {
                        CopacImporter.setOrAppend(b, StandardField.TITLE, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "AU- ": {
                        CopacImporter.setOrAppend(b, StandardField.AUTHOR, line.substring(4).trim(), " and ");
                        continue block26;
                    }
                    case "PY- ": {
                        CopacImporter.setOrAppend(b, StandardField.YEAR, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "PU- ": {
                        CopacImporter.setOrAppend(b, StandardField.PUBLISHER, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "SE- ": {
                        CopacImporter.setOrAppend(b, StandardField.SERIES, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "IS- ": {
                        CopacImporter.setOrAppend(b, StandardField.ISBN, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "KW- ": {
                        CopacImporter.setOrAppend(b, StandardField.KEYWORDS, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "NT- ": {
                        CopacImporter.setOrAppend(b, StandardField.NOTE, line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "PD- ": {
                        CopacImporter.setOrAppend(b, new UnknownField("physicaldimensions"), line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    case "DT- ": {
                        CopacImporter.setOrAppend(b, new UnknownField("documenttype"), line.substring(4).trim(), ", ");
                        continue block26;
                    }
                    default: {
                        CopacImporter.setOrAppend(b, FieldFactory.parseField(StandardEntryType.Book, line.substring(0, 2)), line.substring(4).trim(), ", ");
                    }
                }
            }
            results.add(b);
        }
        return new ParserResult(results);
    }
}

