/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.util.MetaDataParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BibtexParser
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibtexParser.class);
    private static final Integer LOOKAHEAD = 1024;
    private static final String BIB_DESK_ROOT_GROUP_NAME = "BibDeskGroups";
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final Deque<Character> pureTextFromFile = new LinkedList<Character>();
    private final ImportFormatPreferences importFormatPreferences;
    private PushbackReader pushbackReader;
    private BibDatabase database;
    private Set<BibEntryType> entryTypes;
    private boolean eof;
    private int line = 1;
    private ParserResult parserResult;
    private final MetaDataParser metaDataParser;
    private final Map<String, String> parsedBibdeskGroups;
    private GroupTreeNode bibDeskGroupTreeNode;

    public BibtexParser(ImportFormatPreferences importFormatPreferences, FileUpdateMonitor fileMonitor) {
        this.importFormatPreferences = Objects.requireNonNull(importFormatPreferences);
        this.metaDataParser = new MetaDataParser(fileMonitor);
        this.parsedBibdeskGroups = new HashMap<String, String>();
    }

    public BibtexParser(ImportFormatPreferences importFormatPreferences) {
        this(importFormatPreferences, new DummyFileUpdateMonitor());
    }

    public static Optional<BibEntry> singleFromString(String bibtexString, ImportFormatPreferences importFormatPreferences) throws ParseException {
        List<BibEntry> entries = new BibtexParser(importFormatPreferences).parseEntries(bibtexString);
        if (entries == null || entries.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((BibEntry)entries.iterator().next());
    }

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            BufferedReader reader = Importer.getReader(inputStream);
            return this.parse(reader).getDatabase().getEntries();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public Collection<BibtexString> getStringValues() {
        return this.database.getStringValues();
    }

    public Optional<BibEntry> parseSingleEntry(String bibtexString) throws ParseException {
        return this.parseEntries(bibtexString).stream().findFirst();
    }

    public ParserResult parse(Reader in) throws IOException {
        Objects.requireNonNull(in);
        this.pushbackReader = new PushbackReader(in, LOOKAHEAD);
        String newLineSeparator = this.determineNewLineSeparator();
        this.initializeParserResult(newLineSeparator);
        this.parseDatabaseID();
        this.skipWhitespace();
        return this.parseFileContent();
    }

    private String determineNewLineSeparator() throws IOException {
        int currentChar;
        String newLineSeparator = OS.NEWLINE;
        StringWriter stringWriter = new StringWriter(LOOKAHEAD);
        int i = 0;
        do {
            currentChar = this.pushbackReader.read();
            stringWriter.append((char)currentChar);
        } while (++i < LOOKAHEAD && currentChar != 13 && currentChar != 10);
        if (currentChar == 13) {
            newLineSeparator = "\r\n";
        } else if (currentChar == 10) {
            newLineSeparator = "\n";
        }
        this.pushbackReader.unread(stringWriter.toString().toCharArray());
        return newLineSeparator;
    }

    private void initializeParserResult(String newLineSeparator) {
        this.database = new BibDatabase();
        this.database.setNewLineSeparator(newLineSeparator);
        this.entryTypes = new HashSet<BibEntryType>();
        this.parserResult = new ParserResult(this.database, new MetaData(), this.entryTypes);
    }

    private void parseDatabaseID() throws IOException {
        while (!this.eof) {
            this.skipWhitespace();
            char c = (char)this.read();
            if (c == '%') {
                this.skipWhitespace();
                String label = this.parseTextToken().trim();
                if (!label.equals("DBID:")) continue;
                this.skipWhitespace();
                this.database.setSharedDatabaseID(this.parseTextToken().trim());
                continue;
            }
            if (c != '@') continue;
            this.unread(c);
            break;
        }
    }

    private ParserResult parseFileContent() throws IOException {
        boolean found;
        HashMap<String, String> meta = new HashMap<String, String>();
        while (!this.eof && (found = this.consumeUncritically('@'))) {
            String entryType;
            this.skipWhitespace();
            switch (entryType = this.parseTextToken().toLowerCase(Locale.ROOT).trim()) {
                case "preamble": {
                    this.database.setPreamble(this.parsePreamble());
                    this.skipOneNewline();
                    this.dumpTextReadSoFarToString();
                    break;
                }
                case "string": {
                    this.parseBibtexString();
                    break;
                }
                case "comment": {
                    this.parseJabRefComment(meta);
                    break;
                }
                default: {
                    this.parseAndAddEntry(entryType);
                }
            }
            this.skipWhitespace();
        }
        this.addBibDeskGroupEntriesToJabRefGroups();
        try {
            MetaData metaData = this.metaDataParser.parse(meta, this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator());
            if (this.bibDeskGroupTreeNode != null) {
                metaData.getGroups().ifPresentOrElse(existingGroupTree -> {
                    String existingGroups = (String)meta.get("grouping");
                    Stream<GroupTreeNode> groupsToAdd = this.bibDeskGroupTreeNode.getChildren().stream().filter(Predicate.not(groupTreeNode -> existingGroups.contains(":" + groupTreeNode.getName() + "\\")));
                    groupsToAdd.forEach(existingGroupTree::moveTo);
                }, () -> {
                    GroupTreeNode rootNode = new GroupTreeNode(DefaultGroupsFactory.getAllEntriesGroup());
                    this.bibDeskGroupTreeNode.moveTo(rootNode);
                    metaData.setGroups(rootNode);
                });
            }
            this.parserResult.setMetaData(metaData);
        }
        catch (ParseException exception) {
            this.parserResult.addException(exception);
        }
        this.parseRemainingContent();
        this.checkEpilog();
        return this.parserResult;
    }

    private void checkEpilog() {
        if (!this.parserResult.hasWarnings() && Pattern.compile("\\w+\\s*=.*,").matcher(this.database.getEpilog()).find()) {
            this.parserResult.addWarning("following BibTex fragment has not been parsed:\n" + this.database.getEpilog());
        }
    }

    private void parseRemainingContent() {
        this.database.setEpilog(this.dumpTextReadSoFarToString().trim());
    }

    private void parseAndAddEntry(String type) {
        try {
            String commentsAndEntryTypeDefinition = this.dumpTextReadSoFarToString();
            if (commentsAndEntryTypeDefinition.startsWith("\r\n")) {
                commentsAndEntryTypeDefinition = commentsAndEntryTypeDefinition.substring(2);
            } else if (commentsAndEntryTypeDefinition.startsWith("\n")) {
                commentsAndEntryTypeDefinition = commentsAndEntryTypeDefinition.substring(1);
            }
            BibEntry entry = this.parseEntry(type);
            entry.setCommentsBeforeEntry(commentsAndEntryTypeDefinition.substring(0, commentsAndEntryTypeDefinition.lastIndexOf(64)));
            String parsedSerialization = commentsAndEntryTypeDefinition + this.dumpTextReadSoFarToString();
            entry.setParsedSerialization(parsedSerialization);
            this.database.insertEntry(entry);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not parse entry", (Throwable)ex);
            this.parserResult.addWarning(Localization.lang("Error occurred when parsing entry", new Object[0]) + ": '" + ex.getMessage() + "'. \n\n" + Localization.lang("JabRef skipped the entry.", new Object[0]));
        }
    }

    private void parseJabRefComment(Map<String, String> meta) {
        StringBuilder buffer;
        try {
            buffer = this.parseBracketedFieldContent();
        }
        catch (IOException e) {
            LOGGER.info("Found unbracketed comment");
            return;
        }
        String comment = buffer.toString().replaceAll("[\\x0d\\x0a]", "");
        if (comment.substring(0, Math.min(comment.length(), "jabref-meta: ".length())).equals("jabref-meta: ")) {
            String rest;
            int pos;
            if (comment.startsWith("jabref-meta: ") && (pos = (rest = comment.substring("jabref-meta: ".length())).indexOf(58)) > 0) {
                meta.put(rest.substring(0, pos), rest.substring(pos + 1));
                this.dumpTextReadSoFarToString();
            }
        } else if (comment.substring(0, Math.min(comment.length(), "jabref-entrytype: ".length())).equals("jabref-entrytype: ")) {
            Optional<BibEntryType> typ = MetaDataParser.parseCustomEntryType(comment);
            if (typ.isPresent()) {
                this.entryTypes.add(typ.get());
            } else {
                this.parserResult.addWarning(Localization.lang("Ill-formed entrytype comment in BIB file", new Object[0]) + ": " + comment);
            }
            this.dumpTextReadSoFarToString();
        } else if (comment.startsWith("BibDesk Static Groups")) {
            try {
                this.parseBibDeskComment(comment, meta);
            }
            catch (ParseException ex) {
                this.parserResult.addException(ex);
            }
        }
    }

    private void addBibDeskGroupEntriesToJabRefGroups() {
        for (String groupName : this.parsedBibdeskGroups.keySet()) {
            String[] citationKeys;
            for (String citation : citationKeys = this.parsedBibdeskGroups.get(groupName).split(",")) {
                Optional<BibEntry> bibEntry = this.database.getEntryByCitationKey(citation);
                Optional groupValue = bibEntry.flatMap(entry -> entry.getField(StandardField.GROUPS));
                if (groupValue.isEmpty()) {
                    bibEntry.flatMap(entry -> entry.setField(StandardField.GROUPS, groupName));
                    continue;
                }
                if (((String)groupValue.get()).contains(groupName)) continue;
                String concatGroup = (String)groupValue.get() + "," + groupName;
                bibEntry.flatMap(entryByCitationKey -> entryByCitationKey.setField(StandardField.GROUPS, concatGroup));
            }
        }
    }

    private void parseBibDeskComment(String comment, Map<String, String> meta) throws ParseException {
        String xml = comment.substring("BibDesk Static Groups".length() + 1, comment.length() - 1);
        try {
            Document doc = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
            doc.getDocumentElement().normalize();
            NodeList dictList = doc.getElementsByTagName("dict");
            meta.putIfAbsent("databaseType", "bibtex;");
            this.bibDeskGroupTreeNode = GroupTreeNode.fromGroup(new ExplicitGroup(BIB_DESK_ROOT_GROUP_NAME, GroupHierarchyType.INDEPENDENT, this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator()));
            for (int i = 0; i < dictList.getLength(); ++i) {
                Element dictElement = (Element)dictList.item(i);
                NodeList keyList = dictElement.getElementsByTagName("key");
                NodeList stringList = dictElement.getElementsByTagName("string");
                String groupName = null;
                String citationKeys = null;
                for (int j = 0; j < keyList.getLength(); ++j) {
                    if (keyList.item(j).getTextContent().matches("group name")) {
                        groupName = stringList.item(j).getTextContent();
                        ExplicitGroup staticGroup = new ExplicitGroup(groupName, GroupHierarchyType.INDEPENDENT, this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator());
                        this.bibDeskGroupTreeNode.addSubgroup(staticGroup);
                        continue;
                    }
                    if (!keyList.item(j).getTextContent().matches("keys")) continue;
                    citationKeys = stringList.item(j).getTextContent();
                }
                this.parsedBibdeskGroups.putIfAbsent(groupName, citationKeys);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException(e);
        }
    }

    private void parseBibtexString() throws IOException {
        BibtexString bibtexString = this.parseString();
        try {
            this.database.addString(bibtexString);
        }
        catch (KeyCollisionException ex) {
            this.parserResult.addWarning(Localization.lang("Duplicate string name: '%0'", bibtexString.getName()));
        }
    }

    private String dumpTextReadSoFarToString() {
        String result = this.getPureTextFromFile();
        int indexOfAt = result.indexOf("@");
        if (indexOfAt == -1) {
            return this.purgeEOFCharacters(result);
        }
        if (result.contains("DBID:")) {
            return this.purge(result, "DBID:");
        }
        if (result.contains("Encoding: ")) {
            return this.purge(result, "Encoding: ");
        }
        return result;
    }

    private String purge(String context, String stringToPurge) {
        int runningIndex;
        int indexOfAt = context.indexOf("@");
        for (runningIndex = context.indexOf(stringToPurge); runningIndex < indexOfAt && context.charAt(runningIndex) != '\n'; ++runningIndex) {
            if (context.charAt(runningIndex) != '\r') continue;
            if (context.charAt(runningIndex + 1) != '\n') break;
            ++runningIndex;
            break;
        }
        while (runningIndex < indexOfAt && (context.charAt(runningIndex) == '\r' || context.charAt(runningIndex) == '\n')) {
            ++runningIndex;
        }
        return context.substring(runningIndex);
    }

    private String getPureTextFromFile() {
        StringBuilder entry = new StringBuilder();
        while (!this.pureTextFromFile.isEmpty()) {
            entry.append(this.pureTextFromFile.pollFirst());
        }
        return entry.toString();
    }

    private String purgeEOFCharacters(String input) {
        StringBuilder remainingText = new StringBuilder();
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            if (this.isEOFCharacter(character.charValue())) continue;
            remainingText.append(character);
        }
        return remainingText.toString();
    }

    private void skipWhitespace() throws IOException {
        int character;
        do {
            if (!this.isEOFCharacter(character = this.read())) continue;
            this.eof = true;
            return;
        } while (Character.isWhitespace((char)character));
        this.unread(character);
    }

    private void skipSpace() throws IOException {
        int character;
        do {
            if (!this.isEOFCharacter(character = this.read())) continue;
            this.eof = true;
            return;
        } while ((char)character == ' ');
        this.unread(character);
    }

    private void skipOneNewline() throws IOException {
        this.skipSpace();
        if (this.peek() == 13) {
            this.read();
        }
        if (this.peek() == 10) {
            this.read();
        }
    }

    private boolean isEOFCharacter(int character) {
        return character == -1 || character == 65535;
    }

    private String skipAndRecordWhitespace(int character) throws IOException {
        int nextCharacter;
        StringBuilder stringBuilder = new StringBuilder();
        if (character != 32) {
            stringBuilder.append((char)character);
        }
        while (true) {
            if (this.isEOFCharacter(nextCharacter = this.read())) {
                this.eof = true;
                return stringBuilder.toString();
            }
            if (!Character.isWhitespace((char)nextCharacter)) break;
            if (nextCharacter == 32) continue;
            stringBuilder.append((char)nextCharacter);
        }
        this.unread(nextCharacter);
        return stringBuilder.toString();
    }

    private int peek() throws IOException {
        int character = this.read();
        this.unread(character);
        return character;
    }

    private char[] peekTwoCharacters() throws IOException {
        char character1 = (char)this.read();
        char character2 = (char)this.read();
        this.unread(character2);
        this.unread(character1);
        return new char[]{character1, character2};
    }

    private int read() throws IOException {
        int character = this.pushbackReader.read();
        if (!this.isEOFCharacter(character)) {
            this.pureTextFromFile.offerLast(Character.valueOf((char)character));
        }
        if (character == 10) {
            ++this.line;
        }
        return character;
    }

    private void unread(int character) throws IOException {
        if (character == 10) {
            --this.line;
        }
        this.pushbackReader.unread(character);
        if (this.pureTextFromFile.getLast().charValue() == character) {
            this.pureTextFromFile.pollLast();
        }
    }

    private BibtexString parseString() throws IOException {
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        LOGGER.debug("Parsing string name");
        String name = this.parseTextToken();
        LOGGER.debug("Parsed string name");
        this.skipWhitespace();
        LOGGER.debug("Now the contents");
        this.consume('=');
        String content = this.parseFieldContent(FieldFactory.parseField(name));
        LOGGER.debug("Now I'm going to consume a }");
        this.consume('}', ')');
        this.skipOneNewline();
        LOGGER.debug("Finished string parsing.");
        return new BibtexString(name, content, this.dumpTextReadSoFarToString());
    }

    private String parsePreamble() throws IOException {
        this.skipWhitespace();
        String result = this.parseBracketedText();
        this.skipOneNewline();
        return result;
    }

    private BibEntry parseEntry(String entryType) throws IOException {
        BibEntry result = new BibEntry(EntryTypeFactory.parse(entryType));
        this.skipWhitespace();
        this.consume('{', '(');
        int character = this.peek();
        if (character != 10 && character != 13) {
            this.skipWhitespace();
        }
        String key = this.parseKey();
        result.setCitationKey(key);
        this.skipWhitespace();
        while ((character = this.peek()) != 125 && character != 41) {
            if (character == 44) {
                this.consume(',');
            }
            this.skipWhitespace();
            character = this.peek();
            if (character == 125 || character == 41) break;
            this.parseField(result);
        }
        this.consume('}', ')');
        this.skipOneNewline();
        return result;
    }

    private void parseField(BibEntry entry) throws IOException {
        block11: {
            Field field = FieldFactory.parseField(this.parseTextToken().toLowerCase(Locale.ROOT));
            this.skipWhitespace();
            this.consume('=');
            String content = this.parseFieldContent(field);
            if (!content.isEmpty()) {
                if (entry.hasField(field)) {
                    if (field.getProperties().contains((Object)FieldProperty.PERSON_NAMES)) {
                        entry.setField(field, entry.getField(field).orElse("") + " and " + content);
                    } else if (StandardField.KEYWORDS == field) {
                        entry.addKeyword(content, this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator());
                    }
                } else if (field.getName().length() > 10 && field.getName().startsWith("bdsk-file-")) {
                    try {
                        byte[] decodedBytes = Base64.getDecoder().decode(content);
                        NSDictionary plist = (NSDictionary)BinaryPropertyListParser.parse((byte[])decodedBytes);
                        if (plist.containsKey("relativePath")) {
                            NSString relativePath = (NSString)plist.objectForKey("relativePath");
                            Path path = Path.of(relativePath.getContent(), new String[0]);
                            LinkedFile file = new LinkedFile("", path, "");
                            entry.addFile(file);
                            break block11;
                        }
                        LOGGER.error("Could not find attribute 'relativePath' for entry {} in decoded BibDesk field bdsk-file...) ", (Object)entry);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not parse Bibdesk files content (field: bdsk-file...) for entry {}", (Object)entry, (Object)e);
                    }
                } else {
                    entry.setField(field, content);
                }
            }
        }
    }

    private String parseFieldContent(Field field) throws IOException {
        int character;
        this.skipWhitespace();
        StringBuilder value = new StringBuilder();
        while ((character = this.peek()) != 44 && character != 125 && character != 41) {
            if (this.eof) {
                throw new IOException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (character == 34) {
                text = this.parseQuotedFieldExactly();
                value.append(text.toString());
            } else if (character == 123) {
                text = this.parseBracketedFieldContent();
                value.append(text.toString());
            } else if (Character.isDigit((char)character)) {
                String number = this.parseTextToken();
                value.append(number);
            } else if (character == 35) {
                this.consume('#');
            } else {
                String textToken = this.parseTextToken();
                if (textToken.isEmpty()) {
                    throw new IOException("Error in line " + this.line + " or above: Empty text token.\nThis could be caused by a missing comma between two fields.");
                }
                value.append('#').append(textToken).append('#');
            }
            this.skipWhitespace();
        }
        return value.toString();
    }

    private String parseTextToken() throws IOException {
        int character;
        StringBuilder token = new StringBuilder(20);
        while (true) {
            if ((character = this.read()) == -1) {
                this.eof = true;
                return token.toString();
            }
            if (!Character.isLetterOrDigit((char)character) && ":-_*+./'".indexOf(character) < 0) break;
            token.append((char)character);
        }
        this.unread(character);
        return token.toString();
    }

    private String fixKey() throws IOException {
        char currentChar;
        StringBuilder key = new StringBuilder();
        int lookaheadUsed = 0;
        do {
            currentChar = (char)this.read();
            key.append(currentChar);
        } while (currentChar != ',' && currentChar != '\n' && currentChar != '=' && ++lookaheadUsed < LOOKAHEAD);
        this.unread(currentChar);
        key.deleteCharAt(key.length() - 1);
        switch (currentChar) {
            case '=': {
                key = key.reverse();
                boolean matchedAlpha = false;
                for (int i = 0; i < key.length(); ++i) {
                    currentChar = key.charAt(i);
                    if (!matchedAlpha && currentChar == ' ') continue;
                    matchedAlpha = true;
                    this.unread(currentChar);
                    if (currentChar != ' ' && currentChar != '\n') continue;
                    StringBuilder newKey = new StringBuilder();
                    for (int j = i; j < key.length(); ++j) {
                        currentChar = key.charAt(j);
                        if (Character.isWhitespace(currentChar)) continue;
                        newKey.append(currentChar);
                    }
                    key = newKey.reverse();
                    this.parserResult.addWarning(Localization.lang("Line %0: Found corrupted citation key %1.", String.valueOf(this.line), key.toString()));
                }
                break;
            }
            case ',': {
                this.parserResult.addWarning(Localization.lang("Line %0: Found corrupted citation key %1 (contains whitespaces).", String.valueOf(this.line), key.toString()));
                break;
            }
            case '\n': {
                this.parserResult.addWarning(Localization.lang("Line %0: Found corrupted citation key %1 (comma missing).", String.valueOf(this.line), key.toString()));
                break;
            }
            default: {
                this.unreadBuffer(key);
                return "";
            }
        }
        return this.removeWhitespaces(key).toString();
    }

    private StringBuilder removeWhitespaces(StringBuilder toRemove) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toRemove.length(); ++i) {
            char current = toRemove.charAt(i);
            if (Character.isWhitespace(current)) continue;
            result.append(current);
        }
        return result;
    }

    private void unreadBuffer(StringBuilder stringBuilder) throws IOException {
        for (int i = stringBuilder.length() - 1; i >= 0; --i) {
            this.unread(stringBuilder.charAt(i));
        }
    }

    private String parseKey() throws IOException {
        int character;
        StringBuilder token = new StringBuilder(20);
        while (true) {
            if ((character = this.read()) == -1) {
                this.eof = true;
                return token.toString();
            }
            if (Character.isWhitespace((char)character) || !Character.isLetterOrDigit((char)character) && character != 58 && "#{}~,=\ufffd".indexOf(character) != -1) break;
            token.append((char)character);
        }
        if (Character.isWhitespace((char)character)) {
            return String.valueOf(token) + this.fixKey();
        }
        if (character == 44 || character == 125) {
            this.unread(character);
            return token.toString();
        }
        if (character == 61) {
            return token.toString();
        }
        throw new IOException("Error in line " + this.line + ":Character '" + (char)character + "' is not allowed in citation keys.");
    }

    private String parseBracketedText() throws IOException {
        StringBuilder value = new StringBuilder();
        this.consume('{', '(');
        int brackets = 0;
        while (!this.isClosingBracketNext() || brackets != 0) {
            int character = this.read();
            if (this.isEOFCharacter(character)) {
                throw new IOException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (character == 123 || character == 40) {
                ++brackets;
            } else if (character == 125 || character == 41) {
                --brackets;
            }
            if (Character.isWhitespace((char)character)) {
                String whitespacesReduced = this.skipAndRecordWhitespace(character);
                if (!whitespacesReduced.isEmpty() && !"\n\t".equals(whitespacesReduced)) {
                    whitespacesReduced = whitespacesReduced.replace("\t", "");
                    value.append(whitespacesReduced);
                    continue;
                }
                value.append(' ');
                continue;
            }
            value.append((char)character);
        }
        this.consume('}', ')');
        return value.toString();
    }

    private boolean isClosingBracketNext() {
        try {
            int peek = this.peek();
            boolean isCurlyBracket = peek == 125;
            boolean isRoundBracket = peek == 41;
            return isCurlyBracket || isRoundBracket;
        }
        catch (IOException e) {
            return false;
        }
    }

    private StringBuilder parseBracketedFieldContent() throws IOException {
        StringBuilder value = new StringBuilder();
        this.consume('{');
        int brackets = 0;
        char lastCharacter = '\u0000';
        while (true) {
            char character = (char)this.read();
            boolean isClosingBracket = false;
            if (character == '}') {
                char[] nextTwoCharacters;
                isClosingBracket = lastCharacter == '\\' ? (nextTwoCharacters = this.peekTwoCharacters())[0] == ',' && (nextTwoCharacters[1] == OS.NEWLINE.charAt(0) || nextTwoCharacters[1] == '\n') : true;
            }
            if (isClosingBracket && brackets == 0) {
                return value;
            }
            if (this.isEOFCharacter(character)) {
                throw new IOException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (character == '{' && !this.isEscapeSymbol(lastCharacter)) {
                ++brackets;
            } else if (isClosingBracket) {
                --brackets;
            }
            value.append(character);
            lastCharacter = character;
        }
    }

    private boolean isEscapeSymbol(char character) {
        return '\\' == character;
    }

    private StringBuilder parseQuotedFieldExactly() throws IOException {
        StringBuilder value = new StringBuilder();
        this.consume('\"');
        int brackets = 0;
        while (this.peek() != 34 || brackets != 0) {
            int j = this.read();
            if (this.isEOFCharacter(j)) {
                throw new IOException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (j == 123) {
                ++brackets;
            } else if (j == 125) {
                --brackets;
            }
            value.append((char)j);
        }
        this.consume('\"');
        return value;
    }

    private void consume(char expected) throws IOException {
        int character = this.read();
        if (character != expected) {
            throw new IOException("Error in line " + this.line + ": Expected " + expected + " but received " + (char)character);
        }
    }

    private boolean consumeUncritically(char expected) throws IOException {
        int character;
        while ((character = this.read()) != expected && character != -1 && character != 65535) {
        }
        if (this.isEOFCharacter(character)) {
            this.eof = true;
        }
        return character == expected;
    }

    private void consume(char firstOption, char secondOption) throws IOException {
        int character = this.read();
        if (character != firstOption && character != secondOption) {
            throw new IOException("Error in line " + this.line + ": Expected " + firstOption + " or " + secondOption + " but received " + (char)character);
        }
    }
}

