/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fetcher.transformers.DefaultLuceneQueryTransformer;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOAJFetcher
implements SearchBasedParserFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOAJFetcher.class);
    private static final String SEARCH_URL = "https://doaj.org/api/v1/search/articles/";
    private final ImportFormatPreferences preferences;

    public DOAJFetcher(ImportFormatPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    /*
     * WARNING - void declaration
     */
    public static BibEntry parseBibJSONtoBibtex(JSONObject bibJsonEntry, Character keywordSeparator) {
        List<StandardField> singleFields = List.of(StandardField.YEAR, StandardField.TITLE, StandardField.ABSTRACT, StandardField.MONTH);
        List<StandardField> journalSingleFields = List.of(StandardField.PUBLISHER, StandardField.NUMBER, StandardField.VOLUME);
        BibEntry entry = new BibEntry(StandardEntryType.Article);
        if (bibJsonEntry.has("author")) {
            void var7_18;
            JSONArray authors = bibJsonEntry.getJSONArray("author");
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            while (var7_18 < authors.length()) {
                if (authors.getJSONObject((int)var7_18).has("name")) {
                    arrayList.add(authors.getJSONObject((int)var7_18).getString("name"));
                } else {
                    LOGGER.info("Empty author name.");
                }
                ++var7_18;
            }
            entry.setField(StandardField.AUTHOR, String.join((CharSequence)" and ", arrayList));
        } else {
            LOGGER.info("No author found.");
        }
        for (Field field : singleFields) {
            if (!bibJsonEntry.has(field.getName())) continue;
            entry.setField(field, bibJsonEntry.getString(field.getName()));
        }
        if (bibJsonEntry.has("start_page")) {
            if (bibJsonEntry.has("end_page")) {
                entry.setField(StandardField.PAGES, bibJsonEntry.getString("start_page") + "--" + bibJsonEntry.getString("end_page"));
            } else {
                entry.setField(StandardField.PAGES, bibJsonEntry.getString("start_page"));
            }
        }
        if (bibJsonEntry.has("journal")) {
            JSONObject journal = bibJsonEntry.getJSONObject("journal");
            if (journal.has("title")) {
                entry.setField(StandardField.JOURNAL, journal.getString("title").trim());
            } else {
                LOGGER.info("No journal title found.");
            }
            for (Field field : journalSingleFields) {
                if (!journal.has(field.getName())) continue;
                entry.setField(field, journal.getString(field.getName()));
            }
        } else {
            LOGGER.info("No journal information found.");
        }
        if (bibJsonEntry.has("keywords")) {
            void var6_12;
            JSONArray keywords = bibJsonEntry.getJSONArray("keywords");
            boolean bl = false;
            while (var6_12 < keywords.length()) {
                if (!keywords.isNull((int)var6_12)) {
                    entry.addKeyword(keywords.getString((int)var6_12).trim(), keywordSeparator);
                }
                ++var6_12;
            }
        }
        if (bibJsonEntry.has("identifier")) {
            void var6_14;
            JSONArray identifiers = bibJsonEntry.getJSONArray("identifier");
            boolean bl = false;
            while (var6_14 < identifiers.length()) {
                String string = identifiers.getJSONObject((int)var6_14).getString("type");
                if ("doi".equals(string)) {
                    entry.setField(StandardField.DOI, identifiers.getJSONObject((int)var6_14).getString("id"));
                } else if ("pissn".equals(string)) {
                    entry.setField(StandardField.ISSN, identifiers.getJSONObject((int)var6_14).getString("id"));
                } else if ("eissn".equals(string)) {
                    entry.setField(StandardField.ISSN, identifiers.getJSONObject((int)var6_14).getString("id"));
                }
                ++var6_14;
            }
        }
        if (bibJsonEntry.has("link")) {
            void var6_16;
            JSONArray links = bibJsonEntry.getJSONArray("link");
            boolean bl = false;
            while (var6_16 < links.length()) {
                String string;
                if (links.getJSONObject((int)var6_16).has("type") && "fulltext".equals(string = links.getJSONObject((int)var6_16).getString("type")) && links.getJSONObject((int)var6_16).has("url")) {
                    entry.setField(StandardField.URL, links.getJSONObject((int)var6_16).getString("url"));
                }
                ++var6_16;
            }
        }
        return entry;
    }

    public static void addPath(URIBuilder base, String subPath) {
        if (!StringUtil.isBlank(subPath) && !"/".equals(subPath)) {
            base.setPath(DOAJFetcher.appendSegmentToPath(base.getPath(), subPath));
        }
    }

    private static String appendSegmentToPath(String path, String segment) {
        if (StringUtil.isBlank(path)) {
            path = "/";
        }
        if (path.charAt(path.length() - 1) == '/' || segment.startsWith("/")) {
            return path + segment;
        }
        return path + "/" + segment;
    }

    @Override
    public String getName() {
        return "DOAJ";
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_DOAJ);
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder(SEARCH_URL);
        DOAJFetcher.addPath(uriBuilder, new DefaultLuceneQueryTransformer().transformLuceneQuery(luceneQuery).orElse(""));
        uriBuilder.addParameter("pageSize", "30");
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            String response = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(OS.NEWLINE));
            JSONObject jsonObject = new JSONObject(response);
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
            if (jsonObject.has("results")) {
                JSONArray results = jsonObject.getJSONArray("results");
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject bibJsonEntry = results.getJSONObject(i).getJSONObject("bibjson");
                    BibEntry entry = DOAJFetcher.parseBibJSONtoBibtex(bibJsonEntry, this.preferences.bibEntryPreferences().getKeywordSeparator());
                    entries.add(entry);
                }
            }
            return entries;
        };
    }
}

