/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.formatter.bibtexfields.RemoveDigitsFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveRedundantSpacesFormatter;
import org.jabref.logic.formatter.bibtexfields.ReplaceTabsBySpaceFormater;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fetcher.CollectionOfComputerScienceBibliographiesParser;
import org.jabref.logic.importer.fetcher.transformers.CollectionOfComputerScienceBibliographiesQueryTransformer;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;

public class CollectionOfComputerScienceBibliographiesFetcher
implements SearchBasedParserFetcher {
    private static final String BASIC_SEARCH_URL = "http://liinwww.ira.uka.de/bibliography/rss?";
    private final CollectionOfComputerScienceBibliographiesParser parser;

    public CollectionOfComputerScienceBibliographiesFetcher(ImportFormatPreferences importFormatPreferences) {
        this.parser = new CollectionOfComputerScienceBibliographiesParser(importFormatPreferences);
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery) throws URISyntaxException, MalformedURLException, FetcherException {
        return new URIBuilder(BASIC_SEARCH_URL).addParameter("query", new CollectionOfComputerScienceBibliographiesQueryTransformer().transformLuceneQuery(luceneQuery).orElse("")).addParameter("sort", "score").build().toURL();
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public String getName() {
        return "Collection of Computer Science Bibliographies";
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        new FieldFormatterCleanup(StandardField.ABSTRACT, new RemoveNewlinesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.ABSTRACT, new ReplaceTabsBySpaceFormater()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.ABSTRACT, new RemoveRedundantSpacesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.EDITOR, new RemoveDigitsFormatter()).cleanup(entry);
        UnknownField identifierField = new UnknownField("identifier");
        entry.getField(identifierField).stream().flatMap(value -> Arrays.stream(value.split("; "))).forEach(identifierKeyValue -> {
            int length;
            String[] identifierKeyValueSplit = identifierKeyValue.split(" ");
            if (identifierKeyValueSplit.length == 1) {
                identifierKeyValueSplit = identifierKeyValue.split(":");
            }
            if ((length = identifierKeyValueSplit.length) < 2) {
                return;
            }
            String key = identifierKeyValueSplit[length - 2];
            String value = identifierKeyValueSplit[length - 1];
            Field field = FieldFactory.parseField(key);
            if (!entry.hasField(field)) {
                entry.setField(field, value);
            }
        });
        entry.clearField(identifierField);
    }
}

