/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FetcherResult;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FulltextFetchers {
    private static final Logger LOGGER = LoggerFactory.getLogger(FulltextFetchers.class);
    private static final int FETCHER_TIMEOUT = 10;
    private final Set<FulltextFetcher> finders = new HashSet<FulltextFetcher>();
    private final Predicate<String> isPDF = url -> {
        try {
            return new URLDownload((String)url).isPdf();
        }
        catch (MalformedURLException e) {
            LOGGER.warn("URL returned by fulltext fetcher is invalid");
            return false;
        }
    };

    public FulltextFetchers(ImportFormatPreferences importFormatPreferences, ImporterPreferences importerPreferences) {
        this(WebFetchers.getFullTextFetchers(importFormatPreferences, importerPreferences));
    }

    FulltextFetchers(Set<FulltextFetcher> fetcher) {
        this.finders.addAll(fetcher);
    }

    public Optional<URL> findFullTextPDF(BibEntry entry) {
        BibEntry clonedEntry = (BibEntry)entry.clone();
        Optional doi = clonedEntry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (doi.isEmpty()) {
            this.findDoiForEntry(clonedEntry);
        }
        List result = HeadlessExecutorService.INSTANCE.executeAll(this.getCallables(clonedEntry, this.finders), 10, TimeUnit.SECONDS);
        return result.stream().map(FulltextFetchers::getResults).filter(Optional::isPresent).map(Optional::get).filter(res -> res.getSource() != null).sorted(Comparator.comparingInt(res -> res.getTrust().getTrustScore()).reversed()).map(FetcherResult::getSource).findFirst();
    }

    private void findDoiForEntry(BibEntry clonedEntry) {
        try {
            WebFetchers.getIdFetcherForIdentifier(DOI.class).findIdentifier(clonedEntry).ifPresent(e -> clonedEntry.setField(StandardField.DOI, e.getDOI()));
        }
        catch (FetcherException e2) {
            LOGGER.debug("Failed to find DOI", (Throwable)e2);
        }
    }

    private static Optional<FetcherResult> getResults(Future<Optional<FetcherResult>> future) {
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException | ExecutionException e) {
            LOGGER.debug("Fetcher execution failed or was cancelled");
        }
        return Optional.empty();
    }

    private Callable<Optional<FetcherResult>> getCallable(BibEntry entry, FulltextFetcher fetcher) {
        return () -> {
            try {
                return fetcher.findFullText(entry).filter(url -> this.isPDF.test(url.toString())).map(url -> new FetcherResult(fetcher.getTrustLevel(), (URL)url));
            }
            catch (IOException | FetcherException e) {
                LOGGER.debug("Failed to find fulltext PDF at given URL", (Throwable)e);
                return Optional.empty();
            }
        };
    }

    private List<Callable<Optional<FetcherResult>>> getCallables(BibEntry entry, Set<FulltextFetcher> fetchers) {
        return fetchers.stream().map(f -> this.getCallable(entry, (FulltextFetcher)f)).collect(Collectors.toList());
    }
}

