/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.minifier;

import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;

public class MinifyNameListFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Minify list of person names", new Object[0]);
    }

    @Override
    public String getKey() {
        return "minify_name_list";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            return value;
        }
        return this.abbreviateAuthor(value);
    }

    @Override
    public String getDescription() {
        return Localization.lang("Shortens lists of persons if there are more than 2 persons to \"et al.\".", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "Stefan Kolb and Simon Harrer and Oliver Kopp";
    }

    private String abbreviateAuthor(String authorField) {
        String authorSeparator = " and ";
        if (!authorField.contains(authorSeparator)) {
            return authorField;
        }
        String[] authors = authorField.split(authorSeparator);
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = authors[i].trim();
        }
        if ("others".equals(authors[authors.length - 1]) && authors.length == 2) {
            return authorField;
        }
        if (authors.length < 3) {
            return authorField;
        }
        return authors[0] + authorSeparator + "others";
    }
}

