/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import java.util.StringJoiner;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.bibtexfields.RemoveEnclosingBracesFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RemoveWordEnclosingAndOuterEnclosingBracesFormatter
extends Formatter {
    private static final RemoveEnclosingBracesFormatter REMOVE_ENCLOSING_BRACES_FORMATTER = new RemoveEnclosingBracesFormatter();

    @Override
    public String getName() {
        return Localization.lang("Remove word enclosing braces", new Object[0]);
    }

    @Override
    public String getKey() {
        return "remove_enclosing_and_outer_enclosing_braces";
    }

    @Override
    public String getDescription() {
        return Localization.lang("Removes braces encapsulating a complete word and the complete field content.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "{In {CDMA}}";
    }

    @Override
    public String format(String input) {
        Objects.requireNonNull(input);
        if (StringUtil.isBlank(input)) {
            return input;
        }
        if (!input.contains("{")) {
            return input;
        }
        input = REMOVE_ENCLOSING_BRACES_FORMATTER.format(input);
        String[] split = input.split(" ");
        StringJoiner result = new StringJoiner(" ");
        for (String s : split) {
            if (s.length() > 2 && s.startsWith("{") && s.endsWith("}")) {
                String inner = s.substring(1, s.length() - 1);
                if (inner.contains("}")) {
                    if (this.properBrackets(inner)) {
                        s = inner;
                    }
                } else {
                    s = inner;
                }
            }
            result.add(s);
        }
        return result.toString();
    }

    private boolean properBrackets(String s) {
        int level = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '{': {
                    ++level;
                    continue block4;
                }
                case '}': {
                    if (--level != -1) continue block4;
                    return false;
                }
            }
        }
        return level == 0;
    }
}

