/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class NormalizeWhitespaceFormatter {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private final FieldPreferences preferences;

    public NormalizeWhitespaceFormatter(FieldPreferences preferences) {
        Objects.requireNonNull(preferences);
        this.preferences = preferences;
    }

    public String format(String fieldContent, Field field) {
        if (FieldFactory.isMultiLineField(field, this.preferences.getNonWrappableFields())) {
            return fieldContent;
        }
        return WHITESPACE.matcher(fieldContent).replaceAll(" ");
    }

    public String format(StringBuilder fieldContent, Field field) {
        return this.format(fieldContent.toString(), field);
    }
}

