/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.comparator.BibtexStringComparator;
import org.jabref.logic.bibtex.comparator.CrossRefEntryComparator;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.bibtex.comparator.FieldComparatorStack;
import org.jabref.logic.bibtex.comparator.IdComparator;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.citationkeypattern.GlobalCitationKeyPatterns;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.logic.cleanup.NormalizeWhitespacesCleanup;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.exporter.MetaDataSerializer;
import org.jabref.logic.exporter.SelfContainedSaveConfiguration;
import org.jabref.logic.formatter.bibtexfields.TrimWhitespaceFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.metadata.SelfContainedSaveOrder;
import org.jabref.model.strings.StringUtil;
import org.jooq.lambda.Unchecked;

public abstract class BibDatabaseWriter {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("(#[A-Za-z]+#)");
    protected final BibWriter bibWriter;
    protected final SelfContainedSaveConfiguration saveConfiguration;
    protected final CitationKeyPatternPreferences keyPatternPreferences;
    protected final List<FieldChange> saveActionsFieldChanges = new ArrayList<FieldChange>();
    protected final BibEntryTypesManager entryTypesManager;
    protected final FieldPreferences fieldPreferences;

    public BibDatabaseWriter(BibWriter bibWriter, SelfContainedSaveConfiguration saveConfiguration, FieldPreferences fieldPreferences, CitationKeyPatternPreferences keyPatternPreferences, BibEntryTypesManager entryTypesManager) {
        this.bibWriter = Objects.requireNonNull(bibWriter);
        this.saveConfiguration = saveConfiguration;
        this.keyPatternPreferences = keyPatternPreferences;
        this.fieldPreferences = fieldPreferences;
        this.entryTypesManager = entryTypesManager;
        assert (saveConfiguration.getSaveOrder().getOrderType() != SaveOrder.OrderType.TABLE);
    }

    private static List<FieldChange> applySaveActions(List<BibEntry> toChange, MetaData metaData, FieldPreferences fieldPreferences) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        Optional<FieldFormatterCleanups> saveActions = metaData.getSaveActions();
        saveActions.ifPresent(actions -> {
            for (BibEntry entry : toChange) {
                changes.addAll(actions.applySaveActions(entry));
            }
        });
        FieldFormatterCleanup trimWhiteSpaces = new FieldFormatterCleanup(InternalField.INTERNAL_ALL_FIELD, new TrimWhitespaceFormatter());
        NormalizeWhitespacesCleanup normalizeWhitespacesCleanup = new NormalizeWhitespacesCleanup(fieldPreferences);
        for (BibEntry entry : toChange) {
            if (!entry.hasChanged()) continue;
            changes.addAll(trimWhiteSpaces.cleanup(entry));
            changes.addAll(normalizeWhitespacesCleanup.cleanup(entry));
        }
        return changes;
    }

    public static List<FieldChange> applySaveActions(BibEntry entry, MetaData metaData, FieldPreferences fieldPreferences) {
        return BibDatabaseWriter.applySaveActions(List.of(entry), metaData, fieldPreferences);
    }

    private static List<Comparator<BibEntry>> getSaveComparators(SaveOrder saveOrder) {
        ArrayList<Comparator<BibEntry>> comparators = new ArrayList<Comparator<BibEntry>>();
        comparators.add(new CrossRefEntryComparator());
        if (saveOrder.getOrderType() == SaveOrder.OrderType.ORIGINAL) {
            comparators.add(new IdComparator());
        } else {
            List<FieldComparator> fieldComparators = saveOrder.getSortCriteria().stream().map(FieldComparator::new).toList();
            comparators.addAll(fieldComparators);
            comparators.add(new FieldComparator(InternalField.KEY_FIELD));
        }
        return comparators;
    }

    public static List<BibEntry> getSortedEntries(List<BibEntry> entriesToSort, SelfContainedSaveOrder saveOrder) {
        Objects.requireNonNull(entriesToSort);
        Objects.requireNonNull(saveOrder);
        List<Comparator<BibEntry>> comparators = BibDatabaseWriter.getSaveComparators(saveOrder);
        FieldComparatorStack<BibEntry> comparatorStack = new FieldComparatorStack<BibEntry>(comparators);
        ArrayList<BibEntry> sorted = new ArrayList<BibEntry>(entriesToSort);
        sorted.sort(comparatorStack);
        return sorted;
    }

    public List<FieldChange> getSaveActionsFieldChanges() {
        return Collections.unmodifiableList(this.saveActionsFieldChanges);
    }

    public void saveDatabase(BibDatabaseContext bibDatabaseContext) throws IOException {
        List<BibEntry> entries = bibDatabaseContext.getDatabase().getEntries().stream().filter(entry -> !entry.isEmpty()).toList();
        this.savePartOfDatabase(bibDatabaseContext, entries);
    }

    public void savePartOfDatabase(BibDatabaseContext bibDatabaseContext, List<BibEntry> entries) throws IOException {
        Optional<String> sharedDatabaseIDOptional = bibDatabaseContext.getDatabase().getSharedDatabaseID();
        sharedDatabaseIDOptional.ifPresent(Unchecked.consumer(id -> this.writeDatabaseID((String)id)));
        if (this.saveConfiguration.getSaveType() == SaveType.WITH_JABREF_META_DATA) {
            Charset charset = bibDatabaseContext.getMetaData().getEncoding().orElse(StandardCharsets.UTF_8);
            this.writeProlog(bibDatabaseContext, charset);
        }
        this.bibWriter.finishBlock();
        this.writePreamble(bibDatabaseContext.getDatabase().getPreamble().orElse(""));
        this.writeStrings(bibDatabaseContext.getDatabase());
        List<BibEntry> sortedEntries = BibDatabaseWriter.getSortedEntries(entries, this.saveConfiguration.getSelfContainedSaveOrder());
        List<FieldChange> saveActionChanges = BibDatabaseWriter.applySaveActions(sortedEntries, bibDatabaseContext.getMetaData(), this.fieldPreferences);
        this.saveActionsFieldChanges.addAll(saveActionChanges);
        if (this.keyPatternPreferences.shouldGenerateCiteKeysBeforeSaving()) {
            List<FieldChange> keyChanges = this.generateCitationKeys(bibDatabaseContext, sortedEntries);
            this.saveActionsFieldChanges.addAll(keyChanges);
        }
        TreeSet<BibEntryType> typesToWrite = new TreeSet<BibEntryType>();
        for (BibEntry entry : sortedEntries) {
            if (this.entryTypesManager.isCustomType(entry.getType(), bibDatabaseContext.getMode())) {
                this.entryTypesManager.enrich(entry.getType(), bibDatabaseContext.getMode()).ifPresent(typesToWrite::add);
            }
            this.writeEntry(entry, bibDatabaseContext.getMode());
        }
        if (this.saveConfiguration.getSaveType() == SaveType.WITH_JABREF_META_DATA) {
            this.writeMetaData(bibDatabaseContext.getMetaData(), this.keyPatternPreferences.getKeyPatterns());
            this.writeEntryTypeDefinitions(typesToWrite);
        }
        this.writeEpilogue(bibDatabaseContext.getDatabase().getEpilog());
    }

    protected abstract void writeProlog(BibDatabaseContext var1, Charset var2) throws IOException;

    protected abstract void writeEntry(BibEntry var1, BibDatabaseMode var2) throws IOException;

    protected abstract void writeEpilogue(String var1) throws IOException;

    protected void writeMetaData(MetaData metaData, GlobalCitationKeyPatterns globalCiteKeyPattern) throws IOException {
        Objects.requireNonNull(metaData);
        Map<String, String> serializedMetaData = MetaDataSerializer.getSerializedStringMap(metaData, globalCiteKeyPattern);
        for (Map.Entry<String, String> metaItem : serializedMetaData.entrySet()) {
            this.writeMetaDataItem(metaItem);
        }
    }

    protected abstract void writeMetaDataItem(Map.Entry<String, String> var1) throws IOException;

    protected abstract void writePreamble(String var1) throws IOException;

    protected abstract void writeDatabaseID(String var1) throws IOException;

    private void writeStrings(BibDatabase database) throws IOException {
        List<BibtexString> strings = database.getStringKeySet().stream().map(database::getString).sorted(new BibtexStringComparator(true)).toList();
        HashMap<String, BibtexString> remaining = new HashMap<String, BibtexString>();
        int maxKeyLength = 0;
        for (BibtexString string : strings) {
            remaining.put(string.getName(), string);
            maxKeyLength = Math.max(maxKeyLength, string.getName().length());
        }
        for (BibtexString.Type t : BibtexString.Type.values()) {
            for (BibtexString bs : strings) {
                if (!remaining.containsKey(bs.getName()) || bs.getType() != t) continue;
                this.writeString(bs, remaining, maxKeyLength);
            }
        }
        this.bibWriter.finishBlock();
    }

    protected void writeString(BibtexString bibtexString, Map<String, BibtexString> remaining, int maxKeyLength) throws IOException {
        Matcher m;
        remaining.remove(bibtexString.getName());
        String content = bibtexString.getContent();
        while ((m = REFERENCE_PATTERN.matcher(content)).find()) {
            String foundLabel = m.group(1);
            int restIndex = content.indexOf(foundLabel) + foundLabel.length();
            content = content.substring(restIndex);
            String label = foundLabel.substring(1, foundLabel.length() - 1);
            if (!remaining.containsKey(label)) continue;
            BibtexString referred = remaining.get(label);
            this.writeString(referred, remaining, maxKeyLength);
        }
        this.writeString(bibtexString, maxKeyLength);
    }

    protected abstract void writeString(BibtexString var1, int var2) throws IOException;

    protected void writeEntryTypeDefinitions(SortedSet<BibEntryType> types) throws IOException {
        for (BibEntryType type : types) {
            this.writeEntryTypeDefinition(type);
        }
    }

    protected abstract void writeEntryTypeDefinition(BibEntryType var1) throws IOException;

    protected List<FieldChange> generateCitationKeys(BibDatabaseContext databaseContext, List<BibEntry> entries) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        CitationKeyGenerator keyGenerator = new CitationKeyGenerator(databaseContext, this.keyPatternPreferences);
        for (BibEntry bes : entries) {
            Optional<String> oldKey = bes.getCitationKey();
            if (!StringUtil.isBlank(oldKey)) continue;
            Optional<FieldChange> change = keyGenerator.generateAndSetKey(bes);
            change.ifPresent(changes::add);
        }
        return changes;
    }

    public static enum SaveType {
        WITH_JABREF_META_DATA,
        PLAIN_BIBTEX;

    }
}

