/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStyleGenerator;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;

public final class CitationStylePreviewLayout
implements PreviewLayout {
    private final CitationStyle citationStyle;
    private final BibEntryTypesManager bibEntryTypesManager;

    public CitationStylePreviewLayout(CitationStyle citationStyle, BibEntryTypesManager bibEntryTypesManager) {
        this.citationStyle = citationStyle;
        this.bibEntryTypesManager = bibEntryTypesManager;
    }

    @Override
    public String generatePreview(BibEntry entry, BibDatabaseContext databaseContext) {
        return CitationStyleGenerator.generateCitation(entry, this.citationStyle.getSource(), CitationStyleOutputFormat.HTML, databaseContext, this.bibEntryTypesManager);
    }

    @Override
    public String getDisplayName() {
        return this.citationStyle.getTitle();
    }

    @Override
    public String getText() {
        return this.citationStyle.getSource();
    }

    public String getFilePath() {
        return this.citationStyle.getFilePath();
    }

    @Override
    public String getName() {
        return this.citationStyle.getTitle();
    }
}

