/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst.util;

import org.jabref.logic.bst.util.BstCaseChanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BstPurifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstPurifier.class);

    private BstPurifier() {
    }

    public static String purify(String toPurify) {
        StringBuilder sb = new StringBuilder();
        char[] cs = toPurify.toCharArray();
        int n = cs.length;
        int i = 0;
        int braceLevel = 0;
        while (i < n) {
            char c = cs[i];
            if (Character.isWhitespace(c) || c == '-' || c == '~') {
                sb.append(' ');
            } else if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else if (c == '{') {
                if (++braceLevel == 1 && i + 1 < n && cs[i + 1] == '\\') {
                    ++i;
                    while (i < n && braceLevel > 0) {
                        BstCaseChanger.findSpecialChar(cs, ++i).ifPresent(sb::append);
                        while (i < n && Character.isLetter(cs[i])) {
                            ++i;
                        }
                        while (i < n && braceLevel > 0 && (c = cs[i]) != '\\') {
                            if (Character.isLetterOrDigit(c)) {
                                sb.append(c);
                            } else if (c == '}') {
                                --braceLevel;
                            } else if (c == '{') {
                                ++braceLevel;
                            }
                            ++i;
                        }
                    }
                    continue;
                }
            } else if (c == '}') {
                if (braceLevel > 0) {
                    --braceLevel;
                } else {
                    LOGGER.warn("Unbalanced brace in string for purify$: {}", (Object)toPurify);
                }
            }
            ++i;
        }
        if (braceLevel != 0) {
            LOGGER.warn("Unbalanced brace in string for purify$: {}", (Object)toPurify);
        }
        return sb.toString();
    }
}

