/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.bst.BstVMException;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BstNameFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstNameFormatter.class);

    private BstNameFormatter() {
    }

    public static String formatName(String authorsNameList, int whichName, String formatString) {
        AuthorList al = AuthorList.parse(authorsNameList);
        if (whichName < 1 && whichName > al.getNumberOfAuthors()) {
            LOGGER.warn("AuthorList {} does not contain an author with number {}", (Object)authorsNameList, (Object)whichName);
            return "";
        }
        return BstNameFormatter.formatName(al.getAuthor(whichName - 1), formatString);
    }

    public static String formatName(Author author, String format) {
        StringBuilder sb = new StringBuilder();
        char[] c = format.toCharArray();
        int n = c.length;
        int braceLevel = 0;
        int group = 0;
        int i = 0;
        while (i < n) {
            if (c[i] == '{') {
                ++group;
                ++i;
                ++braceLevel;
                StringBuilder level1Chars = new StringBuilder();
                StringBuilder wholeChar = new StringBuilder();
                while (i < n && braceLevel > 0) {
                    wholeChar.append(c[i]);
                    if (c[i] == '{') {
                        ++braceLevel;
                        ++i;
                        continue;
                    }
                    if (c[i] == '}') {
                        --braceLevel;
                        ++i;
                        continue;
                    }
                    if (braceLevel == 1 && Character.isLetter(c[i])) {
                        if ("fvlj".indexOf(c[i]) == -1) {
                            LOGGER.warn("Format string in format.name$ may only contain fvlj on brace level 1 in group {}: {}", (Object)group, (Object)format);
                        } else {
                            level1Chars.append(c[i]);
                        }
                    }
                    ++i;
                }
                --i;
                String control = level1Chars.toString().toLowerCase(Locale.ROOT);
                if (control.isEmpty()) continue;
                if (control.length() > 2) {
                    LOGGER.warn("Format string in format.name$ may only be one or two character long on brace level 1 in group {}: {}", (Object)group, (Object)format);
                }
                char type = control.charAt(0);
                Optional<String> tokenS = switch (type) {
                    case 'f' -> author.getGivenName();
                    case 'v' -> author.getNamePrefix();
                    case 'l' -> author.getFamilyName();
                    case 'j' -> author.getNameSuffix();
                    default -> throw new BstVMException("Internal error");
                };
                if (tokenS.isEmpty()) {
                    ++i;
                    continue;
                }
                String[] tokens = tokenS.get().split(" ");
                boolean abbreviateThatIsSingleLetter = true;
                if (control.length() == 2) {
                    if (control.charAt(1) == control.charAt(0)) {
                        abbreviateThatIsSingleLetter = false;
                    } else {
                        LOGGER.warn("Format string in format.name$ may only contain one type of vlfj on brace level 1 in group {}: {}", (Object)group, (Object)format);
                    }
                }
                if (braceLevel == 0 && wholeChar.charAt(wholeChar.length() - 1) == '}') {
                    wholeChar.deleteCharAt(wholeChar.length() - 1);
                }
                char[] d = wholeChar.toString().toCharArray();
                int bLevel = 1;
                String interToken = null;
                int groupStart = sb.length();
                for (int j = 0; j < d.length; ++j) {
                    if (Character.isLetter(d[j]) && bLevel == 1) {
                        groupStart = sb.length();
                        if (!abbreviateThatIsSingleLetter) {
                            ++j;
                        }
                        if (j + 1 < d.length && d[j + 1] == '{') {
                            StringBuilder interTokenSb = new StringBuilder();
                            j = BstNameFormatter.consumeToMatchingBrace(interTokenSb, d, j + 1);
                            interToken = interTokenSb.substring(1, interTokenSb.length() - 1);
                        }
                        for (int k = 0; k < tokens.length; ++k) {
                            String token = tokens[k];
                            if (abbreviateThatIsSingleLetter) {
                                String[] dashes = token.split("-");
                                token = Arrays.stream(dashes).map(BstNameFormatter::getFirstCharOfString).collect(Collectors.joining(".-"));
                            }
                            sb.append(token);
                            if (k >= tokens.length - 1) continue;
                            if (interToken == null) {
                                if (abbreviateThatIsSingleLetter) {
                                    sb.append('.');
                                }
                                if (k == tokens.length - 2 || BstNameFormatter.numberOfChars(sb.substring(groupStart, sb.length()), 3) < 3) {
                                    sb.append('~');
                                    continue;
                                }
                                sb.append(' ');
                                continue;
                            }
                            sb.append(interToken);
                        }
                        continue;
                    }
                    if (d[j] == '}') {
                        if (--bLevel <= 0) continue;
                        sb.append('}');
                        continue;
                    }
                    if (d[j] == '{') {
                        ++bLevel;
                        sb.append('{');
                        continue;
                    }
                    sb.append(d[j]);
                }
                if (sb.length() > 0) {
                    boolean noDisTie = false;
                    if (sb.charAt(sb.length() - 1) == '~' && (BstNameFormatter.numberOfChars(sb.substring(groupStart, sb.length()), 4) >= 4 || sb.length() > 1 && (noDisTie = sb.charAt(sb.length() - 2) == '~'))) {
                        sb.deleteCharAt(sb.length() - 1);
                        if (!noDisTie) {
                            sb.append(' ');
                        }
                    }
                }
            } else if (c[i] == '}') {
                LOGGER.warn("Unmatched brace in format string: {}", (Object)format);
            } else {
                sb.append(c[i]);
            }
            ++i;
        }
        if (braceLevel != 0) {
            LOGGER.warn("Unbalanced brace in format string for nameFormat: {}", (Object)format);
        }
        return sb.toString();
    }

    public static int consumeToMatchingBrace(StringBuilder interTokenSb, char[] c, int pos) {
        int braceLevel = 0;
        for (int i = pos; i < c.length; ++i) {
            if (c[i] == '}') {
                if (--braceLevel == 0) {
                    interTokenSb.append('}');
                    return i;
                }
            } else if (c[i] == '{') {
                ++braceLevel;
            }
            interTokenSb.append(c[i]);
        }
        return c.length;
    }

    public static String getFirstCharOfString(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isLetter(c[i])) {
                return String.valueOf(c[i]);
            }
            if (c[i] != '{' || i + 1 >= c.length || c[i + 1] != '\\') continue;
            StringBuilder sb = new StringBuilder();
            BstNameFormatter.consumeToMatchingBrace(sb, c, i);
            return sb.toString();
        }
        return "";
    }

    public static int numberOfChars(String token, int inStop) {
        int result;
        int stop = inStop;
        if (stop < 0) {
            stop = Integer.MAX_VALUE;
        }
        int i = 0;
        char[] c = token.toCharArray();
        int n = c.length;
        int braceLevel = 0;
        for (result = 0; i < n && result < stop; ++result) {
            if (c[++i - 1] == '{') {
                if (++braceLevel != 1 || i >= n || c[i] != '\\') continue;
                ++i;
                while (i < n && braceLevel > 0) {
                    if (c[i] == '}') {
                        --braceLevel;
                    } else if (c[i] == '{') {
                        ++braceLevel;
                    }
                    ++i;
                }
                continue;
            }
            if (c[i - 1] != '}') continue;
            --braceLevel;
        }
        return result;
    }
}

