/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import javafx.util.StringConverter;
import javax.swing.undo.UndoManager;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.IEEEField;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.preferences.PreferencesService;

public class FieldsUtil {
    public static final StringConverter<Field> FIELD_STRING_CONVERTER = new StringConverter<Field>(){

        public String toString(Field object) {
            if (object != null) {
                return object.getDisplayName();
            }
            return "";
        }

        public Field fromString(String string) {
            return FieldFactory.parseField(string);
        }
    };

    public static String getNameWithType(Field field, PreferencesService preferencesService, UndoManager undoManager) {
        if (field instanceof SpecialField) {
            SpecialField specialField = (SpecialField)field;
            return new SpecialFieldViewModel(specialField, preferencesService, undoManager).getLocalization() + " (" + Localization.lang("Special", new Object[0]) + ")";
        }
        if (field instanceof IEEEField) {
            return field.getDisplayName() + " (" + Localization.lang("IEEE", new Object[0]) + ")";
        }
        if (field instanceof InternalField) {
            return field.getDisplayName() + " (" + Localization.lang("Internal", new Object[0]) + ")";
        }
        if (field instanceof UnknownField) {
            return field.getDisplayName() + " (" + Localization.lang("Custom", new Object[0]) + ")";
        }
        return field.getDisplayName();
    }
}

