/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.theme;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.jabref.gui.JabRefGUI;
import org.jabref.gui.theme.StyleSheetDataUrl;
import org.jabref.gui.theme.StyleSheetFile;
import org.jabref.gui.theme.StyleSheetResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StyleSheet {
    static final String DATA_URL_PREFIX = "data:text/css;charset=utf-8;base64,";
    static final String EMPTY_WEBENGINE_CSS = "data:text/css;charset=utf-8;base64,";
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleSheet.class);

    StyleSheet() {
    }

    abstract URL getSceneStylesheet();

    abstract String getWebEngineStylesheet();

    Path getWatchPath() {
        return null;
    }

    abstract void reload();

    static Optional<StyleSheet> create(String name) {
        Optional<URL> styleSheetUrl = Optional.ofNullable(JabRefGUI.class.getResource(name));
        if (styleSheetUrl.isEmpty()) {
            try {
                styleSheetUrl = Optional.of(Path.of(name, new String[0]).toUri().toURL());
            }
            catch (InvalidPathException e) {
                LOGGER.warn("Cannot load additional css {} because it is an invalid path: {}", (Object)name, (Object)e.getLocalizedMessage());
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Cannot load additional css url {} because it is a malformed url: {}", (Object)name, (Object)e.getLocalizedMessage());
            }
        }
        if (styleSheetUrl.isEmpty()) {
            try {
                return Optional.of(new StyleSheetDataUrl(new URI("data:text/css;charset=utf-8;base64,").toURL()));
            }
            catch (MalformedURLException | URISyntaxException e) {
                return Optional.empty();
            }
        }
        if ("file".equals(styleSheetUrl.get().getProtocol())) {
            StyleSheetFile styleSheet = new StyleSheetFile(styleSheetUrl.get());
            if (Files.isDirectory(((StyleSheet)styleSheet).getWatchPath(), new LinkOption[0])) {
                LOGGER.warn("Failed to loadCannot load additional css {} because it is a directory.", (Object)((StyleSheet)styleSheet).getWatchPath());
                return Optional.empty();
            }
            if (!Files.exists(((StyleSheet)styleSheet).getWatchPath(), new LinkOption[0])) {
                LOGGER.warn("Cannot load additional css {} because the file does not exist.", (Object)((StyleSheet)styleSheet).getWatchPath());
            }
            return Optional.of(new StyleSheetFile(styleSheetUrl.get()));
        }
        return Optional.of(new StyleSheetResource(styleSheetUrl.get()));
    }

    public String toString() {
        return "StyleSheet{" + String.valueOf(this.getSceneStylesheet()) + "}";
    }
}

