/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import de.saxsys.mvvmfx.utils.commands.Command;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.textfield.CustomTextField;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.edit.EditAction;
import org.jabref.logic.l10n.Localization;

public class SearchFieldRightClickMenu {
    public static ContextMenu create(StateManager stateManager, CustomTextField searchField, LibraryTabContainer tabContainer, UndoManager undoManager) {
        ActionFactory factory = new ActionFactory();
        ContextMenu contextMenu = new ContextMenu();
        Object[] objectArray = new MenuItem[9];
        objectArray[0] = factory.createMenuItem(StandardActions.UNDO, (Command)new EditAction(StandardActions.UNDO, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[1] = factory.createMenuItem(StandardActions.REDO, (Command)new EditAction(StandardActions.REDO, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[2] = factory.createMenuItem(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[3] = factory.createMenuItem(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[4] = factory.createMenuItem(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[5] = factory.createMenuItem(StandardActions.DELETE, (Command)new EditAction(StandardActions.DELETE, tabContainer::getCurrentLibraryTab, stateManager, undoManager));
        objectArray[6] = new SeparatorMenuItem();
        objectArray[7] = factory.createMenuItem(StandardActions.SELECT_ALL, (Command)new EditAction(StandardActions.SELECT_ALL, null, stateManager, undoManager));
        objectArray[8] = SearchFieldRightClickMenu.createSearchFromHistorySubMenu(factory, stateManager, searchField);
        contextMenu.getItems().addAll(objectArray);
        return contextMenu;
    }

    private static Menu createSearchFromHistorySubMenu(ActionFactory factory, final StateManager stateManager, final CustomTextField searchField) {
        Menu searchFromHistorySubMenu = factory.createMenu(() -> Localization.lang("Search from history...", new Object[0]));
        int num = stateManager.getLastSearchHistory(10).size();
        if (num == 0) {
            MenuItem item = new MenuItem(Localization.lang("your search history is empty", new Object[0]));
            searchFromHistorySubMenu.getItems().addAll((Object[])new MenuItem[]{item});
        } else {
            int i = 0;
            while (i < num) {
                final int finalI = i++;
                MenuItem item = factory.createMenuItem(() -> stateManager.getLastSearchHistory(10).get(finalI), (Command)new SimpleCommand(){

                    public void execute() {
                        searchField.setText(stateManager.getLastSearchHistory(10).get(finalI));
                    }
                });
                searchFromHistorySubMenu.getItems().addAll((Object[])new MenuItem[]{item});
            }
            MenuItem clear = factory.createMenuItem(() -> Localization.lang("Clear history", new Object[0]), (Command)new SimpleCommand(){

                public void execute() {
                    stateManager.clearSearchHistory();
                }
            });
            searchFromHistorySubMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), clear});
        }
        return searchFromHistorySubMenu;
    }
}

