/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.Validator;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import impl.org.controlsfx.skin.AutoCompletePopup;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.StringConverter;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.autocompleter.AppendPersonNamesStrategy;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.PersonNameStringConverter;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.search.GlobalSearchResultDialog;
import org.jabref.gui.search.SearchFieldRightClickMenu;
import org.jabref.gui.search.SearchTextField;
import org.jabref.gui.search.SearchType;
import org.jabref.gui.search.rules.describer.SearchDescribers;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.OptionalObjectProperty;
import org.jabref.gui.util.TooltipTextUtil;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.entry.Author;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.SearchPreferences;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSearchBar
extends HBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSearchBar.class);
    private static final int SEARCH_DELAY = 400;
    private static final PseudoClass CLASS_NO_RESULTS = PseudoClass.getPseudoClass((String)"emptyResult");
    private static final PseudoClass CLASS_RESULTS_FOUND = PseudoClass.getPseudoClass((String)"emptyResult");
    private final CustomTextField searchField;
    private final ToggleButton caseSensitiveButton;
    private final ToggleButton regularExpressionButton;
    private final ToggleButton fulltextButton;
    private final Button openGlobalSearchButton;
    private final ToggleButton keepSearchString;
    private final Tooltip searchFieldTooltip = new Tooltip();
    private final Label currentResults = new Label("");
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final Validator regexValidator;
    private final UndoManager undoManager;
    private final LibraryTabContainer tabContainer;
    private final SearchPreferences searchPreferences;
    private final DialogService dialogService;
    private final BooleanProperty globalSearchActive = new SimpleBooleanProperty(false);
    private final OptionalObjectProperty<SearchQuery> searchQueryProperty;
    private GlobalSearchResultDialog globalSearchResultDialog;

    public GlobalSearchBar(LibraryTabContainer tabContainer, StateManager stateManager, PreferencesService preferencesService, UndoManager undoManager, DialogService dialogService, SearchType searchType) {
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.searchPreferences = preferencesService.getSearchPreferences();
        this.undoManager = undoManager;
        this.dialogService = dialogService;
        this.tabContainer = tabContainer;
        this.searchQueryProperty = searchType == SearchType.NORMAL_SEARCH ? stateManager.activeSearchQueryProperty() : stateManager.activeGlobalSearchQueryProperty();
        KeyBindingRepository keyBindingRepository = preferencesService.getKeyBindingRepository();
        this.searchField = SearchTextField.create(keyBindingRepository);
        this.searchField.disableProperty().bind((ObservableValue)ActionHelper.needsDatabase(stateManager).not());
        this.currentResults.setPrefWidth(150.0);
        this.searchField.setTooltip(this.searchFieldTooltip);
        this.searchFieldTooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.searchFieldTooltip.setMaxHeight(10.0);
        this.updateHintVisibility();
        this.searchField.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (keyBindingRepository.matches((KeyEvent)event, KeyBinding.CLEAR_SEARCH)) {
                this.searchField.clear();
                if (searchType == SearchType.NORMAL_SEARCH) {
                    tabContainer.getCurrentLibraryTab().getMainTable().getSelectionModel().selectFirst();
                }
                event.consume();
            }
        });
        this.searchField.setContextMenu(SearchFieldRightClickMenu.create(stateManager, this.searchField, tabContainer, undoManager));
        ObservableList<String> search = stateManager.getWholeSearchHistory();
        search.addListener(change -> this.searchField.setContextMenu(SearchFieldRightClickMenu.create(stateManager, this.searchField, tabContainer, undoManager)));
        ClipBoardManager.addX11Support((TextInputControl)this.searchField);
        this.regularExpressionButton = IconTheme.JabRefIcons.REG_EX.asToggleButton();
        this.caseSensitiveButton = IconTheme.JabRefIcons.CASE_SENSITIVE.asToggleButton();
        this.fulltextButton = IconTheme.JabRefIcons.FULLTEXT.asToggleButton();
        this.openGlobalSearchButton = IconTheme.JabRefIcons.OPEN_GLOBAL_SEARCH.asButton();
        this.keepSearchString = IconTheme.JabRefIcons.KEEP_SEARCH_STRING.asToggleButton();
        this.initSearchModifierButtons();
        BooleanBinding focusedOrActive = this.searchField.focusedProperty().or((ObservableBooleanValue)this.regularExpressionButton.focusedProperty()).or((ObservableBooleanValue)this.caseSensitiveButton.focusedProperty()).or((ObservableBooleanValue)this.fulltextButton.focusedProperty()).or((ObservableBooleanValue)this.keepSearchString.focusedProperty()).or((ObservableBooleanValue)this.searchField.textProperty().isNotEmpty());
        this.regularExpressionButton.visibleProperty().unbind();
        this.regularExpressionButton.visibleProperty().bind((ObservableValue)focusedOrActive);
        this.caseSensitiveButton.visibleProperty().unbind();
        this.caseSensitiveButton.visibleProperty().bind((ObservableValue)focusedOrActive);
        this.fulltextButton.visibleProperty().unbind();
        this.fulltextButton.visibleProperty().bind((ObservableValue)focusedOrActive);
        this.keepSearchString.visibleProperty().unbind();
        this.keepSearchString.visibleProperty().bind((ObservableValue)focusedOrActive);
        StackPane modifierButtons = searchType == SearchType.NORMAL_SEARCH ? new StackPane(new Node[]{new HBox(new Node[]{this.regularExpressionButton, this.caseSensitiveButton, this.fulltextButton, this.keepSearchString})}) : new StackPane(new Node[]{new HBox(new Node[]{this.regularExpressionButton, this.caseSensitiveButton, this.fulltextButton})});
        modifierButtons.setAlignment(Pos.CENTER);
        this.searchField.setRight((Node)new HBox(new Node[]{this.searchField.getRight(), modifierButtons}));
        this.searchField.getStyleClass().add((Object)"search-field");
        this.searchField.setMinWidth(100.0);
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        this.regexValidator = new FunctionBasedValidator((ObservableValue)this.searchField.textProperty(), query -> !this.regularExpressionButton.isSelected() || this.validRegex(), ValidationMessage.error((String)Localization.lang("Invalid regular expression", new Object[0])));
        ControlsFxVisualizer visualizer = new ControlsFxVisualizer();
        visualizer.setDecoration((ValidationDecoration)new IconValidationDecorator(Pos.CENTER_LEFT));
        Platform.runLater(() -> visualizer.initVisualization(this.regexValidator.getValidationStatus(), (Control)this.searchField));
        if (searchType == SearchType.NORMAL_SEARCH) {
            this.getChildren().addAll((Object[])new Node[]{this.searchField, this.openGlobalSearchButton, this.currentResults});
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.searchField, this.currentResults});
        }
        this.setSpacing(4.0);
        this.setAlignment(Pos.CENTER_LEFT);
        Timer searchTask = FxTimer.create((Duration)Duration.ofMillis(400L), this::updateSearchQuery);
        BindingsHelper.bindBidirectional(this.searchQueryProperty, this.searchField.textProperty(), searchTerm -> searchTask.restart(), query -> this.setSearchTerm(query.map(SearchQuery::getQuery).orElse("")));
        this.searchQueryProperty.addListener((obs, oldValue, newValue) -> newValue.ifPresent(this::updateSearchResultsForQuery));
        this.stateManager.activeDatabaseProperty().addListener(obs -> ((Optional)this.searchQueryProperty.get()).ifPresent(this::updateSearchResultsForQuery));
        this.searchField.focusedProperty().addListener((obs, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue() && !this.searchField.getText().isBlank()) {
                this.stateManager.addSearchHistory((String)this.searchField.textProperty().get());
            }
        });
    }

    private void updateSearchResultsForQuery(SearchQuery query) {
        this.updateResults(this.stateManager.getSearchResultSize(this.searchQueryProperty).intValue(), SearchDescribers.getSearchDescriberFor(query).getDescription(), query.isGrammarBasedSearch());
    }

    private void initSearchModifierButtons() {
        this.regularExpressionButton.setSelected(this.searchPreferences.isRegularExpression());
        this.regularExpressionButton.setTooltip(new Tooltip(Localization.lang("regular expression", new Object[0])));
        this.initSearchModifierButton((ButtonBase)this.regularExpressionButton);
        this.regularExpressionButton.setOnAction(event -> {
            this.searchPreferences.setSearchFlag(SearchRules.SearchFlags.REGULAR_EXPRESSION, this.regularExpressionButton.isSelected());
            this.updateSearchQuery();
        });
        this.caseSensitiveButton.setSelected(this.searchPreferences.isCaseSensitive());
        this.caseSensitiveButton.setTooltip(new Tooltip(Localization.lang("Case sensitive", new Object[0])));
        this.initSearchModifierButton((ButtonBase)this.caseSensitiveButton);
        this.caseSensitiveButton.setOnAction(event -> {
            this.searchPreferences.setSearchFlag(SearchRules.SearchFlags.CASE_SENSITIVE, this.caseSensitiveButton.isSelected());
            this.updateSearchQuery();
        });
        this.fulltextButton.setSelected(this.searchPreferences.isFulltext());
        this.fulltextButton.setTooltip(new Tooltip(Localization.lang("Fulltext search", new Object[0])));
        this.initSearchModifierButton((ButtonBase)this.fulltextButton);
        this.fulltextButton.setOnAction(event -> {
            this.searchPreferences.setSearchFlag(SearchRules.SearchFlags.FULLTEXT, this.fulltextButton.isSelected());
            this.updateSearchQuery();
        });
        this.keepSearchString.setSelected(this.searchPreferences.shouldKeepSearchString());
        this.keepSearchString.setTooltip(new Tooltip(Localization.lang("Keep search string across libraries", new Object[0])));
        this.initSearchModifierButton((ButtonBase)this.keepSearchString);
        this.keepSearchString.setOnAction(evt -> {
            this.searchPreferences.setSearchFlag(SearchRules.SearchFlags.KEEP_SEARCH_STRING, this.keepSearchString.isSelected());
            this.updateSearchQuery();
        });
        this.openGlobalSearchButton.disableProperty().bindBidirectional((Property)this.globalSearchActive);
        this.openGlobalSearchButton.setTooltip(new Tooltip(Localization.lang("Search across libraries in a new window", new Object[0])));
        this.initSearchModifierButton((ButtonBase)this.openGlobalSearchButton);
        this.openGlobalSearchButton.setOnAction(evt -> {
            this.globalSearchActive.setValue(Boolean.valueOf(true));
            if (this.globalSearchResultDialog == null) {
                this.globalSearchResultDialog = new GlobalSearchResultDialog(this.undoManager, this.tabContainer);
            }
            this.stateManager.activeGlobalSearchQueryProperty().setValue((Optional)this.searchQueryProperty.get());
            this.updateSearchQuery();
            this.dialogService.showCustomDialogAndWait(this.globalSearchResultDialog);
            this.globalSearchActive.setValue(Boolean.valueOf(false));
        });
    }

    private void initSearchModifierButton(ButtonBase searchButton) {
        searchButton.setCursor(Cursor.DEFAULT);
        searchButton.setMinHeight(28.0);
        searchButton.setMaxHeight(28.0);
        searchButton.setMinWidth(28.0);
        searchButton.setMaxWidth(28.0);
        searchButton.setPadding(new Insets(1.0));
        searchButton.managedProperty().bind((ObservableValue)this.searchField.editableProperty());
        searchButton.visibleProperty().bind((ObservableValue)this.searchField.editableProperty());
    }

    public void focus() {
        if (!this.searchField.isFocused()) {
            this.searchField.requestFocus();
        }
        this.searchField.selectAll();
    }

    public void updateSearchQuery() {
        LOGGER.debug("Flags: {}", this.searchPreferences.getSearchFlags());
        LOGGER.debug("Updated search query: {}", (Object)this.searchField.getText());
        if (this.searchField.getText().isEmpty()) {
            this.currentResults.setText("");
            this.setSearchFieldHintTooltip(null);
            this.stateManager.clearSearchQuery(this.searchQueryProperty);
            return;
        }
        if (!this.regexValidator.getValidationStatus().isValid()) {
            this.currentResults.setText(Localization.lang("Invalid regular expression", new Object[0]));
            return;
        }
        SearchQuery searchQuery = new SearchQuery(this.searchField.getText(), this.searchPreferences.getSearchFlags());
        if (!searchQuery.isValid()) {
            this.informUserAboutInvalidSearchQuery();
            return;
        }
        this.stateManager.setSearchQuery(this.searchQueryProperty, searchQuery);
    }

    private boolean validRegex() {
        try {
            Pattern.compile(this.searchField.getText());
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug(e.getMessage());
            return false;
        }
        return true;
    }

    private void informUserAboutInvalidSearchQuery() {
        this.searchField.pseudoClassStateChanged(CLASS_NO_RESULTS, true);
        this.stateManager.clearSearchQuery(this.searchQueryProperty);
        String illegalSearch = Localization.lang("Search failed: illegal search expression", new Object[0]);
        this.currentResults.setText(illegalSearch);
    }

    public void setAutoCompleter(SuggestionProvider<Author> searchCompleter) {
        if (this.preferencesService.getAutoCompletePreferences().shouldAutoComplete()) {
            AutoCompletionTextInputBinding<Author> autoComplete = AutoCompletionTextInputBinding.autoComplete((TextInputControl)this.searchField, searchCompleter::provideSuggestions, new PersonNameStringConverter(false, false, AutoCompleteFirstNameMode.BOTH), new AppendPersonNamesStrategy());
            AutoCompletePopup<Author> popup = this.getPopup(autoComplete);
            popup.setSkin(new SearchPopupSkin<Author>(popup));
        }
    }

    private <T> AutoCompletePopup<T> getPopup(AutoCompletionBinding<T> autoCompletionBinding) {
        try {
            Field privatePopup = AutoCompletionBinding.class.getDeclaredField("autoCompletionPopup");
            privatePopup.setAccessible(true);
            return (AutoCompletePopup)privatePopup.get(autoCompletionBinding);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Could not get access to auto completion popup", (Throwable)e);
            return new AutoCompletePopup();
        }
    }

    private void updateResults(int matched, TextFlow description, boolean grammarBasedSearch) {
        if (matched == 0) {
            this.currentResults.setText(Localization.lang("No results found.", new Object[0]));
            this.searchField.pseudoClassStateChanged(CLASS_NO_RESULTS, true);
        } else {
            this.currentResults.setText(Localization.lang("Found %0 results.", String.valueOf(matched)));
            this.searchField.pseudoClassStateChanged(CLASS_RESULTS_FOUND, true);
        }
        if (grammarBasedSearch) {
            // empty if block
        }
        this.setSearchFieldHintTooltip(description);
    }

    private void setSearchFieldHintTooltip(TextFlow description) {
        if (this.preferencesService.getWorkspacePreferences().shouldShowAdvancedHints()) {
            String genericDescription = Localization.lang("Hint:\n\nTo search all fields for <b>Smith</b>, enter:\n<tt>smith</tt>\n\nTo search the field <b>author</b> for <b>Smith</b> and the field <b>title</b> for <b>electrical</b>, enter:\n<tt>author=Smith and title=electrical</tt>", new Object[0]);
            List<Text> genericDescriptionTexts = TooltipTextUtil.createTextsFromHtml(genericDescription);
            if (description == null) {
                TextFlow emptyHintTooltip = new TextFlow();
                emptyHintTooltip.getChildren().setAll(genericDescriptionTexts);
                this.searchFieldTooltip.setGraphic((Node)emptyHintTooltip);
            } else {
                description.getChildren().add((Object)new Text("\n\n"));
                description.getChildren().addAll(genericDescriptionTexts);
                this.searchFieldTooltip.setGraphic((Node)description);
            }
        }
    }

    public void updateHintVisibility() {
        this.setSearchFieldHintTooltip(null);
    }

    public void setSearchTerm(String searchTerm) {
        if (searchTerm.equals(this.searchField.getText())) {
            return;
        }
        UiTaskExecutor.runInJavaFXThread(() -> this.searchField.setText(searchTerm));
    }

    private static class SearchPopupSkin<T>
    implements Skin<AutoCompletePopup<T>> {
        private final AutoCompletePopup<T> control;
        private final ListView<T> suggestionList;
        private final BorderPane container;

        public SearchPopupSkin(AutoCompletePopup<T> control) {
            this.control = control;
            this.suggestionList = new ListView(control.getSuggestions());
            this.suggestionList.getStyleClass().add((Object)"auto-complete-popup");
            this.suggestionList.getStylesheets().add((Object)Objects.requireNonNull(AutoCompletionBinding.class.getResource("autocompletion.css")).toExternalForm());
            this.suggestionList.prefHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)control.visibleRowCountProperty(), (ObservableNumberValue)Bindings.size((ObservableList)this.suggestionList.getItems())).multiply(24).add(18));
            this.suggestionList.setCellFactory(TextFieldListCell.forListView((StringConverter)control.getConverter()));
            this.suggestionList.prefWidthProperty().bind((ObservableValue)control.prefWidthProperty());
            this.suggestionList.maxWidthProperty().bind((ObservableValue)control.maxWidthProperty());
            this.suggestionList.minWidthProperty().bind((ObservableValue)control.minWidthProperty());
            this.container = new BorderPane();
            this.container.setCenter(this.suggestionList);
            this.registerEventListener();
        }

        private void registerEventListener() {
            this.suggestionList.setOnMouseClicked(me -> {
                if (me.getButton() == MouseButton.PRIMARY) {
                    this.onSuggestionChosen(this.suggestionList.getSelectionModel().getSelectedItem());
                }
            });
            this.suggestionList.setOnKeyPressed(ke -> {
                switch (ke.getCode()) {
                    case TAB: 
                    case ENTER: {
                        this.onSuggestionChosen(this.suggestionList.getSelectionModel().getSelectedItem());
                        break;
                    }
                    case ESCAPE: {
                        if (!this.control.isHideOnEscape()) break;
                        this.control.hide();
                        break;
                    }
                }
            });
        }

        private void onSuggestionChosen(T suggestion) {
            if (suggestion != null) {
                Event.fireEvent(this.control, (Event)new AutoCompletePopup.SuggestionEvent(suggestion));
            }
        }

        public Node getNode() {
            return this.container;
        }

        public AutoCompletePopup<T> getSkinnable() {
            return this.control;
        }

        public void dispose() {
        }
    }
}

