/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.network;

import java.time.LocalDate;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.AbstractViewModel;
import org.jabref.logic.net.ssl.SSLCertificate;

public class CustomCertificateViewModel
extends AbstractViewModel {
    private final StringProperty serialNumberProperty = new SimpleStringProperty("");
    private final StringProperty issuerProperty = new SimpleStringProperty("");
    private final ObjectProperty<LocalDate> validFromProperty = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> validToProperty = new SimpleObjectProperty();
    private final StringProperty signatureAlgorithmProperty = new SimpleStringProperty("");
    private final StringProperty versionProperty = new SimpleStringProperty("");
    private final StringProperty thumbprintProperty = new SimpleStringProperty("");
    private final StringProperty pathProperty = new SimpleStringProperty("");

    public CustomCertificateViewModel(String thumbprint, String serialNumber, String issuer, LocalDate validFrom, LocalDate validTo, String sigAlgorithm, String version) {
        this.serialNumberProperty.setValue(serialNumber);
        this.issuerProperty.setValue(issuer);
        this.validFromProperty.setValue((Object)validFrom);
        this.validToProperty.setValue((Object)validTo);
        this.signatureAlgorithmProperty.setValue(sigAlgorithm);
        this.versionProperty.setValue(version);
        this.thumbprintProperty.setValue(thumbprint);
    }

    public ReadOnlyStringProperty serialNumberProperty() {
        return this.serialNumberProperty;
    }

    public ReadOnlyStringProperty issuerProperty() {
        return this.issuerProperty;
    }

    public ReadOnlyObjectProperty<LocalDate> validFromProperty() {
        return this.validFromProperty;
    }

    public ReadOnlyObjectProperty<LocalDate> validToProperty() {
        return this.validToProperty;
    }

    public ReadOnlyStringProperty signatureAlgorithmProperty() {
        return this.signatureAlgorithmProperty;
    }

    public ReadOnlyStringProperty versionProperty() {
        return this.versionProperty;
    }

    public String getVersion() {
        return this.versionProperty.getValue();
    }

    public String getThumbprint() {
        return this.thumbprintProperty.getValue();
    }

    public LocalDate getValidFrom() {
        return (LocalDate)this.validFromProperty.getValue();
    }

    public LocalDate getValidTo() {
        return (LocalDate)this.validToProperty.getValue();
    }

    public StringProperty pathPropertyProperty() {
        return this.pathProperty;
    }

    public Optional<String> getPath() {
        if (this.pathProperty.getValue() == null || this.pathProperty.getValue().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.pathProperty.getValue());
    }

    public CustomCertificateViewModel setPath(String path) {
        this.pathProperty.setValue(path);
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumberProperty.getValue();
    }

    public String getIssuer() {
        return this.issuerProperty.getValue();
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithmProperty.getValue();
    }

    public static CustomCertificateViewModel fromSSLCertificate(SSLCertificate sslCertificate) {
        return new CustomCertificateViewModel(sslCertificate.getSHA256Thumbprint(), sslCertificate.getSerialNumber(), sslCertificate.getIssuer(), sslCertificate.getValidFrom(), sslCertificate.getValidTo(), sslCertificate.getSignatureAlgorithm(), sslCertificate.getVersion().toString());
    }
}

