/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.general;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.general.GeneralTabViewModel;
import org.jabref.gui.theme.ThemeTypes;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Language;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;

public class GeneralTab
extends AbstractPreferenceTabView<GeneralTabViewModel>
implements PreferencesTab {
    @FXML
    private ComboBox<Language> language;
    @FXML
    private ComboBox<ThemeTypes> theme;
    @FXML
    private CheckBox themeSyncOs;
    @FXML
    private TextField customThemePath;
    @FXML
    private Button customThemeBrowse;
    @FXML
    private CheckBox fontOverride;
    @FXML
    private Spinner<Integer> fontSize;
    @FXML
    private CheckBox openLastStartup;
    @FXML
    private CheckBox showAdvancedHints;
    @FXML
    private CheckBox inspectionWarningDuplicate;
    @FXML
    private CheckBox confirmDelete;
    @FXML
    private ComboBox<BibDatabaseMode> biblatexMode;
    @FXML
    private CheckBox alwaysReformatBib;
    @FXML
    private CheckBox autosaveLocalLibraries;
    @FXML
    private Button autosaveLocalLibrariesHelp;
    @FXML
    private CheckBox createBackup;
    @FXML
    private TextField backupDirectory;
    @FXML
    private CheckBox remoteServer;
    @FXML
    private TextField remotePort;
    @FXML
    private Button remoteHelp;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @Inject
    private BibEntryTypesManager entryTypesManager;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();
    private final TextFormatter<Integer> fontSizeFormatter = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)9, c -> {
        if (Pattern.matches("\\d*", c.getText())) {
            return c;
        }
        c.setText("0");
        return c;
    });

    public GeneralTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("General", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new GeneralTabViewModel(this.dialogService, this.preferencesService, this.fileUpdateMonitor, this.entryTypesManager);
        new ViewModelListCellFactory().withText(Language::getDisplayName).install(this.language);
        this.language.itemsProperty().bind(((GeneralTabViewModel)this.viewModel).languagesListProperty());
        this.language.valueProperty().bindBidirectional(((GeneralTabViewModel)this.viewModel).selectedLanguageProperty());
        this.fontOverride.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).fontOverrideProperty());
        this.fontSize.disableProperty().bind((ObservableValue)this.fontOverride.selectedProperty().not());
        this.fontSize.getEditor().setAlignment(Pos.CENTER_RIGHT);
        this.fontSize.setValueFactory(GeneralTabViewModel.fontSizeValueFactory);
        this.fontSize.getEditor().textProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).fontSizeProperty());
        this.fontSize.getEditor().setTextFormatter(this.fontSizeFormatter);
        new ViewModelListCellFactory().withText(ThemeTypes::getDisplayName).install(this.theme);
        this.theme.itemsProperty().bind(((GeneralTabViewModel)this.viewModel).themesListProperty());
        this.theme.valueProperty().bindBidirectional(((GeneralTabViewModel)this.viewModel).selectedThemeProperty());
        this.themeSyncOs.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).themeSyncOsProperty());
        this.customThemePath.textProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).customPathToThemeProperty());
        EasyBind.subscribe(((GeneralTabViewModel)this.viewModel).selectedThemeProperty(), theme -> {
            boolean isCustomTheme = theme == ThemeTypes.CUSTOM;
            this.customThemePath.disableProperty().set(!isCustomTheme);
            this.customThemeBrowse.disableProperty().set(!isCustomTheme);
        });
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.openLastStartup.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).openLastStartupProperty());
        this.showAdvancedHints.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).showAdvancedHintsProperty());
        this.inspectionWarningDuplicate.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).inspectionWarningDuplicateProperty());
        this.confirmDelete.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).confirmDeleteProperty());
        new ViewModelListCellFactory().withText(BibDatabaseMode::getFormattedName).install(this.biblatexMode);
        this.biblatexMode.itemsProperty().bind(((GeneralTabViewModel)this.viewModel).biblatexModeListProperty());
        this.biblatexMode.valueProperty().bindBidirectional(((GeneralTabViewModel)this.viewModel).selectedBiblatexModeProperty());
        this.alwaysReformatBib.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).alwaysReformatBibProperty());
        this.autosaveLocalLibraries.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).autosaveLocalLibrariesProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP, (Command)new HelpAction(HelpFile.AUTOSAVE, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.autosaveLocalLibrariesHelp);
        actionFactory.configureIconButton(StandardActions.HELP, (Command)new HelpAction(HelpFile.REMOTE, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.remoteHelp);
        this.createBackup.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).createBackupProperty());
        this.backupDirectory.textProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).backupDirectoryProperty());
        this.backupDirectory.disableProperty().bind((ObservableValue)((GeneralTabViewModel)this.viewModel).createBackupProperty().not());
        Platform.runLater(() -> {
            this.validationVisualizer.initVisualization(((GeneralTabViewModel)this.viewModel).remotePortValidationStatus(), (Control)this.remotePort);
            this.validationVisualizer.initVisualization(((GeneralTabViewModel)this.viewModel).fontSizeValidationStatus(), this.fontSize);
            this.validationVisualizer.initVisualization(((GeneralTabViewModel)this.viewModel).customPathToThemeValidationStatus(), (Control)this.customThemePath);
        });
        this.remoteServer.selectedProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).remoteServerProperty());
        this.remotePort.textProperty().bindBidirectional((Property)((GeneralTabViewModel)this.viewModel).remotePortProperty());
        this.remotePort.disableProperty().bind((ObservableValue)this.remoteServer.selectedProperty().not());
    }

    @FXML
    void importTheme() {
        ((GeneralTabViewModel)this.viewModel).importCSSFile();
    }

    public void backupFileDirBrowse() {
        ((GeneralTabViewModel)this.viewModel).backupFileDirBrowse();
    }

    @FXML
    public void openBrowser() {
        ((GeneralTabViewModel)this.viewModel).openBrowser();
    }
}

