/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customentrytypes;

import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.customentrytypes.CustomEntryTypeViewModel;
import org.jabref.gui.preferences.customentrytypes.EntryTypeViewModel;
import org.jabref.gui.preferences.customentrytypes.FieldViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.BibField;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldPriority;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.UnknownEntryType;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;

public class CustomEntryTypesTabViewModel
implements PreferenceTabViewModel {
    private final ObservableList<Field> fieldsForAdding;
    private final ObjectProperty<EntryTypeViewModel> selectedEntryType;
    private final StringProperty entryTypeToAdd;
    private final ObjectProperty<Field> newFieldToAdd;
    private final ObservableList<EntryTypeViewModel> entryTypesWithFields;
    private final List<BibEntryType> entryTypesToDelete;
    private final PreferencesService preferencesService;
    private final BibEntryTypesManager entryTypesManager;
    private final DialogService dialogService;
    private final BibDatabaseMode bibDatabaseMode;
    private final Validator entryTypeValidator;
    private final Validator fieldValidator;
    private final Set<Field> multiLineFields;
    Predicate<Field> isMultiline;

    /*
     * Exception decompiling
     */
    public CustomEntryTypesTabViewModel(BibDatabaseMode mode, BibEntryTypesManager entryTypesManager, DialogService dialogService, PreferencesService preferencesService) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setValues() {
        if (!this.entryTypesWithFields.isEmpty()) {
            this.entryTypesWithFields.clear();
        }
        Collection<BibEntryType> allTypes = this.entryTypesManager.getAllTypes(this.bibDatabaseMode);
        for (BibEntryType entryType : allTypes) {
            EntryTypeViewModel viewModel = this.entryTypesManager.isCustomType(entryType, this.bibDatabaseMode) ? new CustomEntryTypeViewModel(entryType, this.isMultiline) : new EntryTypeViewModel(entryType, this.isMultiline);
            this.entryTypesWithFields.add((Object)viewModel);
        }
    }

    @Override
    public void storeSettings() {
        HashSet<Field> multilineFields = new HashSet<Field>();
        for (EntryTypeViewModel typeViewModel : this.entryTypesWithFields) {
            ObservableList<FieldViewModel> allFields = typeViewModel.fields();
            BibEntryType type = (BibEntryType)typeViewModel.entryType().getValue();
            EntryType newPlainType = type.getType();
            multilineFields.addAll(allFields.stream().filter(FieldViewModel::isMultiline).map(model -> model.toField(newPlainType)).toList());
            List<OrFields> required = allFields.stream().filter(FieldViewModel::isRequired).map(model -> model.toField(newPlainType)).map(OrFields::new).collect(Collectors.toList());
            List<BibField> fields = allFields.stream().map(model -> model.toBibField(newPlainType)).collect(Collectors.toList());
            BibEntryType newType = new BibEntryType(newPlainType, fields, required);
            this.entryTypesManager.update(newType, this.bibDatabaseMode);
        }
        for (BibEntryType entryType : this.entryTypesToDelete) {
            this.entryTypesManager.removeCustomOrModifiedEntryType(entryType, this.bibDatabaseMode);
        }
        this.preferencesService.getFieldPreferences().setNonWrappableFields(multilineFields);
        this.preferencesService.storeCustomEntryTypesRepository(this.entryTypesManager);
    }

    public EntryTypeViewModel addNewCustomEntryType() {
        UnknownEntryType newentryType = new UnknownEntryType(this.entryTypeToAdd.getValue());
        BibEntryType type = new BibEntryType(newentryType, new ArrayList<BibField>(), Collections.emptyList());
        CustomEntryTypeViewModel viewModel = new CustomEntryTypeViewModel(type, this.isMultiline);
        this.entryTypesWithFields.add((Object)viewModel);
        this.entryTypeToAdd.setValue("");
        return viewModel;
    }

    public void removeEntryType(EntryTypeViewModel focusedItem) {
        this.entryTypesWithFields.remove((Object)focusedItem);
        this.entryTypesToDelete.add((BibEntryType)focusedItem.entryType().getValue());
    }

    public void addNewField() {
        Field field = (Field)this.newFieldToAdd.getValue();
        boolean fieldExists = this.displayNameExists(field.getDisplayName());
        if (fieldExists) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Duplicate fields", new Object[0]), Localization.lang("Warning: You added field \"%0\" twice. Only one will be kept.", field.getDisplayName()));
        } else {
            ((EntryTypeViewModel)this.selectedEntryType.getValue()).addField(new FieldViewModel(field, FieldViewModel.Mandatory.REQUIRED, FieldPriority.IMPORTANT, false));
        }
        this.newFieldToAddProperty().setValue(null);
    }

    public boolean displayNameExists(String displayName) {
        ObservableList<FieldViewModel> entryFields = ((EntryTypeViewModel)this.selectedEntryType.getValue()).fields();
        return entryFields.stream().anyMatch(fieldViewModel -> fieldViewModel.displayNameProperty().getValue().equals(displayName));
    }

    public void removeField(FieldViewModel focusedItem) {
        ((EntryTypeViewModel)this.selectedEntryType.getValue()).removeField(focusedItem);
    }

    public void resetAllCustomEntryTypes() {
        this.entryTypesManager.clearAllCustomEntryTypes(this.bibDatabaseMode);
        this.preferencesService.storeCustomEntryTypesRepository(this.entryTypesManager);
    }

    public ObjectProperty<EntryTypeViewModel> selectedEntryTypeProperty() {
        return this.selectedEntryType;
    }

    public StringProperty entryTypeToAddProperty() {
        return this.entryTypeToAdd;
    }

    public ObjectProperty<Field> newFieldToAddProperty() {
        return this.newFieldToAdd;
    }

    public ObservableList<EntryTypeViewModel> entryTypes() {
        return this.entryTypesWithFields;
    }

    public ObservableList<Field> fieldsForAdding() {
        return this.fieldsForAdding;
    }

    public ValidationStatus entryTypeValidationStatus() {
        return this.entryTypeValidator.getValidationStatus();
    }

    public ValidationStatus fieldValidationStatus() {
        return this.fieldValidator.getValidationStatus();
    }

    private static /* synthetic */ boolean lambda$new$2(Field input) {
        return input != null && StringUtil.isNotBlank(input.getDisplayName());
    }

    private /* synthetic */ boolean lambda$new$1(Field field) {
        return this.multiLineFields.contains(field) || field.getProperties().contains((Object)FieldProperty.MULTILINE_TEXT);
    }
}

