/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.sun.star.lang.DisposedException;
import org.jabref.gui.DialogService;
import org.jabref.logic.JabRefException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.NoDocumentFoundException;
import org.jabref.model.openoffice.uno.NoDocumentException;

class OOError
extends JabRefException {
    private String localizedTitle;

    public OOError(String title, String localizedMessage) {
        super(localizedMessage, localizedMessage);
        this.localizedTitle = title;
    }

    public OOError(String title, String localizedMessage, Throwable cause) {
        super(localizedMessage, localizedMessage, cause);
        this.localizedTitle = title;
    }

    public String getTitle() {
        return this.localizedTitle;
    }

    public OOError setTitle(String title) {
        this.localizedTitle = title;
        return this;
    }

    public void showErrorDialog(DialogService dialogService) {
        dialogService.showErrorDialogAndWait(this.getTitle(), this.getLocalizedMessage());
    }

    public static OOError from(JabRefException err) {
        return new OOError(Localization.lang("JabRefException", new Object[0]), err.getLocalizedMessage(), err);
    }

    public static OOError from(DisposedException err) {
        return new OOError(Localization.lang("Connection lost", new Object[0]), Localization.lang("Connection to OpenOffice/LibreOffice has been lost. Please make sure OpenOffice/LibreOffice is running, and try to reconnect.", new Object[0]), err);
    }

    public static OOError from(NoDocumentException err) {
        return new OOError(Localization.lang("Not connected to document", new Object[0]), Localization.lang("Not connected to any Writer document. Please make sure a document is open, and use the 'Select Writer document' button to connect to it.", new Object[0]), err);
    }

    public static OOError from(NoDocumentFoundException err) {
        return new OOError(Localization.lang("No Writer documents found", new Object[0]), Localization.lang("Could not connect to any Writer document. Please make sure a document is open before using the 'Select Writer document' button to connect to it.", new Object[0]), err);
    }

    public static OOError fromMisc(Exception err) {
        return new OOError("Exception", err.getMessage(), err);
    }

    public static OOError noDataBaseIsOpenForCiting() {
        return new OOError(Localization.lang("No database", new Object[0]), Localization.lang("No bibliography database is open for citation.", new Object[0]) + "\n" + Localization.lang("Open one before citing.", new Object[0]));
    }

    public static OOError noDataBaseIsOpenForSyncingAfterCitation() {
        return new OOError(Localization.lang("No database", new Object[0]), Localization.lang("No database is open for updating citation markers after citing.", new Object[0]) + "\n" + Localization.lang("Open one before citing.", new Object[0]));
    }

    public static OOError noDataBaseIsOpenForExport() {
        return new OOError(Localization.lang("No database is open", new Object[0]), Localization.lang("We need a database to export from. Open one.", new Object[0]));
    }

    public static OOError noDataBaseIsOpen() {
        return new OOError(Localization.lang("No database is open", new Object[0]), Localization.lang("This operation requires a bibliography database.", new Object[0]));
    }

    public static OOError noValidStyleSelected() {
        return new OOError(Localization.lang("No valid style file defined", new Object[0]), Localization.lang("No bibliography style is selected for citation.", new Object[0]) + "\n" + Localization.lang("Select one before citing.", new Object[0]) + "\n" + Localization.lang("You must select either a valid style file, or use one of the default styles.", new Object[0]));
    }

    public static OOError noEntriesSelectedForCitation() {
        return new OOError(Localization.lang("No entries selected for citation", new Object[0]), Localization.lang("No bibliography entries are selected for citation.", new Object[0]) + "\n" + Localization.lang("Select some before citing.", new Object[0]));
    }
}

