/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.fieldsmerger;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMerger;
import org.jabref.model.strings.StringUtil;

public class GroupMerger
implements FieldMerger {
    public static final String GROUPS_SEPARATOR = ", ";
    public static final Pattern GROUPS_SEPARATOR_REGEX = Pattern.compile(" *, *");

    @Override
    public String merge(String groupsA, String groupsB) {
        if (StringUtil.isBlank(groupsA) && StringUtil.isBlank(groupsB)) {
            return "";
        }
        if (StringUtil.isBlank(groupsA)) {
            return groupsB;
        }
        if (StringUtil.isBlank(groupsB)) {
            return groupsA;
        }
        return Arrays.stream(GROUPS_SEPARATOR_REGEX.split(groupsA + GROUPS_SEPARATOR + groupsB)).distinct().collect(Collectors.joining(GROUPS_SEPARATOR));
    }
}

