/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import java.util.Map;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.ButtonType;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class MultiMergeEntriesViewModel
extends AbstractViewModel {
    private final ListProperty<EntrySource> entries = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<BibEntry> mergedEntry = new SimpleObjectProperty((Object)new BibEntry());
    private final ListProperty<String> failedSuppliers = new SimpleListProperty(FXCollections.observableArrayList());

    public void addSource(EntrySource entrySource) {
        if (!entrySource.isLoading.getValue().booleanValue()) {
            this.updateFields((BibEntry)entrySource.entry.get());
        } else {
            entrySource.isLoading.addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.updateFields((BibEntry)entrySource.entry.get());
                    if (entrySource.entryProperty().get() == null) {
                        this.failedSuppliers.add((Object)((String)entrySource.titleProperty().get()));
                    }
                }
            });
        }
        this.entries.add((Object)entrySource);
    }

    public void updateFields(BibEntry entry) {
        if (entry == null) {
            return;
        }
        for (Map.Entry<Field, String> fieldEntry : entry.getFieldMap().entrySet()) {
            if (((BibEntry)this.mergedEntry.get()).getFieldsObservable().containsKey((Object)fieldEntry.getKey())) continue;
            ((BibEntry)this.mergedEntry.get()).setField(fieldEntry.getKey(), fieldEntry.getValue());
        }
    }

    public BibEntry resultConverter(ButtonType button) {
        if (button == ButtonType.CANCEL) {
            return null;
        }
        return (BibEntry)this.mergedEntry.get();
    }

    public ListProperty<EntrySource> entriesProperty() {
        return this.entries;
    }

    public ObjectProperty<BibEntry> mergedEntryProperty() {
        return this.mergedEntry;
    }

    public ListProperty<String> failedSuppliersProperty() {
        return this.failedSuppliers;
    }

    public static class EntrySource {
        private final StringProperty title = new SimpleStringProperty("");
        private final ObjectProperty<BibEntry> entry = new SimpleObjectProperty();
        private final BooleanProperty isLoading = new SimpleBooleanProperty(false);

        public EntrySource(String title, Supplier<BibEntry> entrySupplier, TaskExecutor taskExecutor) {
            this.title.set((Object)title);
            this.isLoading.set(true);
            BackgroundTask.wrap(entrySupplier::get).onSuccess(value -> {
                this.entry.set(value);
                this.isLoading.set(false);
            }).executeWith(taskExecutor);
        }

        public EntrySource(String title, BibEntry entry) {
            this.title.set((Object)title);
            this.entry.set((Object)entry);
        }

        public StringProperty titleProperty() {
            return this.title;
        }

        public ObjectProperty<BibEntry> entryProperty() {
            return this.entry;
        }

        public BooleanProperty isLoadingProperty() {
            return this.isLoading;
        }
    }
}

