/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.util.LinkedList;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;

public class OpenExternalFileAction
extends SimpleCommand {
    private final int FILES_LIMIT = 10;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final BibEntry entry;
    private final LinkedFile linkedFile;
    private final TaskExecutor taskExecutor;

    public OpenExternalFileAction(DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, TaskExecutor taskExecutor) {
        this(dialogService, stateManager, preferencesService, null, null, taskExecutor);
    }

    public OpenExternalFileAction(DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, BibEntry entry, LinkedFile linkedFile, TaskExecutor taskExecutor) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.entry = entry;
        this.linkedFile = linkedFile;
        this.taskExecutor = taskExecutor;
        if (this.linkedFile == null) {
            this.executable.bind((ObservableValue)ActionHelper.hasLinkedFileForSelectedEntries(stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(stateManager)));
        } else {
            this.setExecutable(true);
        }
    }

    public void execute() {
        this.stateManager.getActiveDatabase().ifPresent(databaseContext -> {
            if (this.entry == null) {
                boolean continueOpening;
                ObservableList<BibEntry> selectedEntries = this.stateManager.getSelectedEntries();
                LinkedList<LinkedFileViewModel> linkedFileViewModelList = new LinkedList<LinkedFileViewModel>();
                for (BibEntry entry : selectedEntries) {
                    for (LinkedFile linkedFile : entry.getFiles()) {
                        LinkedFileViewModel linkedFileViewModel = new LinkedFileViewModel(linkedFile, entry, (BibDatabaseContext)databaseContext, this.taskExecutor, this.dialogService, this.preferencesService);
                        linkedFileViewModelList.add(linkedFileViewModel);
                    }
                }
                if (linkedFileViewModelList.size() > 10 && !(continueOpening = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Opening large number of files", new Object[0]), Localization.lang("You are about to open %0 files. Continue?", linkedFileViewModelList.size()), Localization.lang("Continue", new Object[0]), Localization.lang("Cancel", new Object[0])))) {
                    return;
                }
                linkedFileViewModelList.forEach(LinkedFileViewModel::open);
            } else {
                LinkedFileViewModel linkedFileViewModel = new LinkedFileViewModel(this.linkedFile, this.entry, (BibDatabaseContext)databaseContext, this.taskExecutor, this.dialogService, this.preferencesService);
                linkedFileViewModel.open();
            }
        });
    }
}

