/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.airhacks.afterburner.injection.Injector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.CellFactory;
import org.jabref.gui.maintable.ColumnPreferences;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.MainTableTooltip;
import org.jabref.gui.maintable.columns.FieldColumn;
import org.jabref.gui.maintable.columns.FileColumn;
import org.jabref.gui.maintable.columns.LibraryColumn;
import org.jabref.gui.maintable.columns.LinkedIdentifierColumn;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.maintable.columns.SpecialFieldColumn;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTableColumnFactory {
    public static final String STYLE_ICON_COLUMN = "column-icon";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainTableColumnFactory.class);
    private final PreferencesService preferencesService;
    private final ColumnPreferences columnPreferences;
    private final BibDatabaseContext database;
    private final CellFactory cellFactory;
    private final UndoManager undoManager;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final ThemeManager themeManager = (ThemeManager)Injector.instantiateModelOrService(ThemeManager.class);
    private final StateManager stateManager;
    private final MainTableTooltip tooltip;

    public MainTableColumnFactory(BibDatabaseContext database, PreferencesService preferencesService, ColumnPreferences abstractColumnPrefs, UndoManager undoManager, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor) {
        this.database = Objects.requireNonNull(database);
        this.preferencesService = Objects.requireNonNull(preferencesService);
        this.columnPreferences = abstractColumnPrefs;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.cellFactory = new CellFactory(preferencesService, undoManager);
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.tooltip = new MainTableTooltip(database, dialogService, preferencesService, stateManager, this.themeManager, taskExecutor);
    }

    public TableColumn<BibEntryTableViewModel, ?> createColumn(MainTableColumnModel column) {
        Object returnColumn = null;
        switch (column.getType()) {
            case INDEX: {
                returnColumn = this.createIndexColumn(column);
                break;
            }
            case GROUPS: {
                returnColumn = this.createGroupColumn(column);
                break;
            }
            case GROUP_ICONS: {
                returnColumn = this.createGroupIconColumn(column);
                break;
            }
            case FILES: {
                returnColumn = this.createFilesColumn(column);
                break;
            }
            case LINKED_IDENTIFIER: {
                returnColumn = this.createIdentifierColumn(column);
                break;
            }
            case LIBRARY_NAME: {
                returnColumn = this.createLibraryColumn(column);
                break;
            }
            case EXTRAFILE: {
                if (column.getQualifier().isBlank()) break;
                returnColumn = this.createExtraFileColumn(column);
                break;
            }
            case SPECIALFIELD: {
                if (column.getQualifier().isBlank()) break;
                Field field = FieldFactory.parseField(column.getQualifier());
                if (field instanceof SpecialField) {
                    returnColumn = this.createSpecialFieldColumn(column);
                    break;
                }
                LOGGER.warn("Special field type '{}' is unknown. Using normal column type.", (Object)column.getQualifier());
                returnColumn = this.createFieldColumn(column, this.tooltip);
                break;
            }
            default: {
                if (column.getQualifier().isBlank()) break;
                returnColumn = this.createFieldColumn(column, this.tooltip);
            }
        }
        return returnColumn;
    }

    public List<TableColumn<BibEntryTableViewModel, ?>> createColumns() {
        ArrayList columns = new ArrayList();
        this.columnPreferences.getColumns().forEach(column -> columns.add(this.createColumn((MainTableColumnModel)column)));
        return columns;
    }

    public static void setExactWidth(TableColumn<?, ?> column, double width) {
        column.setMinWidth(width);
        column.setPrefWidth(width);
        column.setMaxWidth(width);
    }

    private TableColumn<BibEntryTableViewModel, String> createIndexColumn(MainTableColumnModel columnModel) {
        MainTableColumn<String> column = new MainTableColumn<String>(columnModel);
        Text header = new Text("#");
        header.getStyleClass().add((Object)"mainTable-header");
        Tooltip.install((Node)header, (Tooltip)new Tooltip(MainTableColumnModel.Type.INDEX.getDisplayName()));
        column.setGraphic((Node)header);
        column.setStyle("-fx-alignment: CENTER-RIGHT;");
        column.setCellValueFactory(cellData -> new ReadOnlyObjectWrapper((Object)String.valueOf(cellData.getTableView().getItems().indexOf(cellData.getValue()) + 1)));
        new ValueTableCellFactory().withText(text -> text).install(column);
        column.setSortable(false);
        return column;
    }

    private TableColumn<BibEntryTableViewModel, ?> createGroupColumn(MainTableColumnModel columnModel) {
        MainTableColumn column = new MainTableColumn(columnModel);
        Node headerGraphic = IconTheme.JabRefIcons.DEFAULT_GROUP_ICON.getGraphicNode();
        Tooltip.install((Node)headerGraphic, (Tooltip)new Tooltip(Localization.lang("Group color", new Object[0])));
        column.setGraphic(headerGraphic);
        column.getStyleClass().add((Object)STYLE_ICON_COLUMN);
        MainTableColumnFactory.setExactWidth(column, 28.0);
        column.setResizable(false);
        column.setCellValueFactory(cellData -> ((BibEntryTableViewModel)cellData.getValue()).getMatchedGroups());
        new ValueTableCellFactory<BibEntryTableViewModel, List>().withGraphic(this::createGroupColorRegion).install(column);
        column.setStyle("-fx-padding: 0 0 0 0;");
        column.setSortable(true);
        return column;
    }

    private TableColumn<BibEntryTableViewModel, ?> createGroupIconColumn(MainTableColumnModel columnModel) {
        MainTableColumn column = new MainTableColumn(columnModel);
        Node headerGraphic = IconTheme.JabRefIcons.DEFAULT_GROUP_ICON_COLUMN.getGraphicNode();
        Tooltip.install((Node)headerGraphic, (Tooltip)new Tooltip(Localization.lang("Group icons", new Object[0])));
        column.setGraphic(headerGraphic);
        column.getStyleClass().add((Object)STYLE_ICON_COLUMN);
        column.setResizable(true);
        column.setCellValueFactory(cellData -> ((BibEntryTableViewModel)cellData.getValue()).getMatchedGroups());
        new ValueTableCellFactory<BibEntryTableViewModel, List>().withGraphic(this::createGroupIconRegion).install(column);
        column.setStyle("-fx-padding: 0 0 0 0;");
        column.setSortable(true);
        return column;
    }

    private Node createGroupColorRegion(BibEntryTableViewModel entry, List<AbstractGroup> matchedGroups) {
        List groupColors = matchedGroups.stream().flatMap(group -> group.getColor().stream()).toList();
        if (!groupColors.isEmpty()) {
            HBox container = new HBox();
            container.setSpacing(2.0);
            container.setMinWidth(10.0);
            container.setAlignment(Pos.CENTER_LEFT);
            container.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            groupColors.stream().distinct().forEach(groupColor -> {
                Rectangle groupRectangle = new Rectangle();
                groupRectangle.getStyleClass().add((Object)"groupColumnBackground");
                groupRectangle.setWidth(3.0);
                groupRectangle.setHeight(18.0);
                groupRectangle.setFill((Paint)groupColor);
                groupRectangle.setStrokeWidth(1.0);
                container.getChildren().add((Object)groupRectangle);
            });
            String matchedGroupsString = matchedGroups.stream().distinct().map(AbstractGroup::getName).collect(Collectors.joining(", "));
            Tooltip tooltip = new Tooltip(Localization.lang("Entry is contained in the following groups:", new Object[0]) + "\n" + matchedGroupsString);
            Tooltip.install((Node)container, (Tooltip)tooltip);
            return container;
        }
        return new Pane();
    }

    private Node createGroupIconRegion(BibEntryTableViewModel entry, List<AbstractGroup> matchedGroups) {
        List groupIcons = matchedGroups.stream().filter(abstractGroup -> abstractGroup.getIconName().isPresent()).flatMap(group -> IconTheme.findIcon(group.getIconName().get(), group.getColor().orElse(IconTheme.getDefaultGroupColor())).stream()).toList();
        if (!groupIcons.isEmpty()) {
            HBox container = new HBox();
            container.setSpacing(2.0);
            container.setMinWidth(10.0);
            container.setAlignment(Pos.CENTER_LEFT);
            container.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            groupIcons.stream().distinct().forEach(groupIcon -> container.getChildren().add((Object)groupIcon.getGraphicNode()));
            String matchedGroupsString = matchedGroups.stream().distinct().map(AbstractGroup::getName).collect(Collectors.joining(", "));
            Tooltip tooltip = new Tooltip(Localization.lang("Entry is contained in the following groups:", new Object[0]) + "\n" + matchedGroupsString);
            Tooltip.install((Node)container, (Tooltip)tooltip);
            return container;
        }
        return new Pane();
    }

    private TableColumn<BibEntryTableViewModel, ?> createFieldColumn(MainTableColumnModel columnModel, MainTableTooltip tooltip) {
        return new FieldColumn(columnModel, tooltip);
    }

    private TableColumn<BibEntryTableViewModel, Map<Field, String>> createIdentifierColumn(MainTableColumnModel columnModel) {
        return new LinkedIdentifierColumn(columnModel, this.cellFactory, this.database, this.dialogService, this.preferencesService, this.stateManager);
    }

    private TableColumn<BibEntryTableViewModel, Optional<SpecialFieldValueViewModel>> createSpecialFieldColumn(MainTableColumnModel columnModel) {
        return new SpecialFieldColumn(columnModel, this.preferencesService, this.undoManager);
    }

    private TableColumn<BibEntryTableViewModel, List<LinkedFile>> createFilesColumn(MainTableColumnModel columnModel) {
        return new FileColumn(columnModel, this.database, this.dialogService, this.preferencesService, this.taskExecutor);
    }

    private TableColumn<BibEntryTableViewModel, List<LinkedFile>> createExtraFileColumn(MainTableColumnModel columnModel) {
        return new FileColumn(columnModel, this.database, this.dialogService, this.preferencesService, columnModel.getQualifier(), this.taskExecutor);
    }

    private TableColumn<BibEntryTableViewModel, String> createLibraryColumn(MainTableColumnModel columnModel) {
        return new LibraryColumn(columnModel);
    }
}

