/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.saving;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.commonfxcontrols.SortCriterionViewModel;
import org.jabref.gui.libraryproperties.PropertiesTabViewModel;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.PreferencesService;

public class SavingPropertiesViewModel
implements PropertiesTabViewModel {
    private static final SaveOrder UI_DEFAULT_SAVE_ORDER = new SaveOrder(SaveOrder.OrderType.ORIGINAL, List.of(new SaveOrder.SortCriterion(StandardField.AUTHOR), new SaveOrder.SortCriterion(StandardField.YEAR), new SaveOrder.SortCriterion(StandardField.TITLE), new SaveOrder.SortCriterion(InternalField.KEY_FIELD)));
    private final BooleanProperty protectDisableProperty = new SimpleBooleanProperty();
    private final BooleanProperty libraryProtectedProperty = new SimpleBooleanProperty();
    private final BooleanProperty saveInOriginalProperty = new SimpleBooleanProperty();
    private final BooleanProperty saveInTableOrderProperty = new SimpleBooleanProperty();
    private final BooleanProperty saveInSpecifiedOrderProperty = new SimpleBooleanProperty();
    private final ListProperty<Field> sortableFieldsProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<SortCriterionViewModel> sortCriteriaProperty = new SimpleListProperty(FXCollections.observableArrayList(new ArrayList()));
    private final BooleanProperty cleanupsDisableProperty = new SimpleBooleanProperty();
    private final ListProperty<FieldFormatterCleanup> cleanupsProperty = new SimpleListProperty(FXCollections.emptyObservableList());
    private final BibDatabaseContext databaseContext;
    private final MetaData initialMetaData;
    private final SaveOrder saveOrder;
    private final PreferencesService preferencesService;

    public SavingPropertiesViewModel(BibDatabaseContext databaseContext, PreferencesService preferencesService) {
        this.databaseContext = databaseContext;
        this.preferencesService = preferencesService;
        this.initialMetaData = databaseContext.getMetaData();
        this.saveOrder = this.initialMetaData.getSaveOrder().orElse(UI_DEFAULT_SAVE_ORDER);
    }

    @Override
    public void setValues() {
        this.libraryProtectedProperty.setValue(Boolean.valueOf(this.initialMetaData.isProtected()));
        switch (this.saveOrder.getOrderType()) {
            case SPECIFIED: {
                this.saveInSpecifiedOrderProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case ORIGINAL: {
                this.saveInOriginalProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case TABLE: {
                this.saveInTableOrderProperty.setValue(Boolean.valueOf(true));
            }
        }
        this.sortableFieldsProperty.clear();
        Set<Field> fields = FieldFactory.getAllFieldsWithOutInternal();
        fields.add(InternalField.INTERNAL_ALL_FIELD);
        fields.add(InternalField.INTERNAL_ALL_TEXT_FIELDS_FIELD);
        fields.add(InternalField.KEY_FIELD);
        fields.add(InternalField.TYPE_HEADER);
        this.sortableFieldsProperty.addAll(FieldFactory.getStandardFieldsWithCitationKey());
        this.sortCriteriaProperty.clear();
        this.sortCriteriaProperty.addAll(this.saveOrder.getSortCriteria().stream().map(SortCriterionViewModel::new).toList());
        Optional<FieldFormatterCleanups> saveActions = this.initialMetaData.getSaveActions();
        saveActions.ifPresentOrElse(value -> {
            this.cleanupsDisableProperty.setValue(Boolean.valueOf(!value.isEnabled()));
            this.cleanupsProperty.setValue(FXCollections.observableArrayList(value.getConfiguredActions()));
        }, () -> {
            CleanupPreferences defaultPreset = this.preferencesService.getDefaultCleanupPreset();
            this.cleanupsDisableProperty.setValue(Boolean.valueOf(!defaultPreset.getFieldFormatterCleanups().isEnabled()));
            this.cleanupsProperty.setValue(FXCollections.observableArrayList(defaultPreset.getFieldFormatterCleanups().getConfiguredActions()));
        });
    }

    @Override
    public void storeSettings() {
        MetaData newMetaData = this.databaseContext.getMetaData();
        if (this.libraryProtectedProperty.getValue().booleanValue()) {
            newMetaData.markAsProtected();
        } else {
            newMetaData.markAsNotProtected();
        }
        FieldFormatterCleanups fieldFormatterCleanups = new FieldFormatterCleanups(this.cleanupsDisableProperty().getValue() == false, (List<FieldFormatterCleanup>)this.cleanupsProperty());
        if (FieldFormatterCleanups.DEFAULT_SAVE_ACTIONS.equals(fieldFormatterCleanups.getConfiguredActions())) {
            newMetaData.clearSaveActions();
        } else if (fieldFormatterCleanups.getConfiguredActions().isEmpty()) {
            newMetaData.clearSaveActions();
        } else {
            newMetaData.setSaveActions(fieldFormatterCleanups);
        }
        SaveOrder newSaveOrder = new SaveOrder(SaveOrder.OrderType.fromBooleans(this.saveInSpecifiedOrderProperty.getValue(), this.saveInOriginalProperty.getValue()), this.sortCriteriaProperty.stream().map(SortCriterionViewModel::getCriterion).toList());
        if (!newSaveOrder.equals(this.saveOrder)) {
            if (newSaveOrder.equals(SaveOrder.getDefaultSaveOrder())) {
                newMetaData.clearSaveOrder();
            } else {
                newMetaData.setSaveOrder(newSaveOrder);
            }
        }
        this.databaseContext.setMetaData(newMetaData);
    }

    public BooleanProperty protectDisableProperty() {
        return this.protectDisableProperty;
    }

    public BooleanProperty libraryProtectedProperty() {
        return this.libraryProtectedProperty;
    }

    public BooleanProperty saveInOriginalProperty() {
        return this.saveInOriginalProperty;
    }

    public BooleanProperty saveInTableOrderProperty() {
        return this.saveInTableOrderProperty;
    }

    public BooleanProperty saveInSpecifiedOrderProperty() {
        return this.saveInSpecifiedOrderProperty;
    }

    public ListProperty<Field> sortableFieldsProperty() {
        return this.sortableFieldsProperty;
    }

    public ListProperty<SortCriterionViewModel> sortCriteriaProperty() {
        return this.sortCriteriaProperty;
    }

    public BooleanProperty cleanupsDisableProperty() {
        return this.cleanupsDisableProperty;
    }

    public ListProperty<FieldFormatterCleanup> cleanupsProperty() {
        return this.cleanupsProperty;
    }
}

