/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.preamble;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.swing.undo.UndoManager;
import org.jabref.gui.libraryproperties.PropertiesTabViewModel;
import org.jabref.gui.undo.UndoablePreambleChange;
import org.jabref.model.database.BibDatabaseContext;

public class PreamblePropertiesViewModel
implements PropertiesTabViewModel {
    private final StringProperty preambleProperty = new SimpleStringProperty("");
    private final BibDatabaseContext databaseContext;
    private final UndoManager undoManager;

    PreamblePropertiesViewModel(BibDatabaseContext databaseContext, UndoManager undoManager) {
        this.undoManager = undoManager;
        this.databaseContext = databaseContext;
    }

    @Override
    public void setValues() {
        this.preambleProperty.setValue(this.databaseContext.getDatabase().getPreamble().orElse(""));
    }

    @Override
    public void storeSettings() {
        String newPreamble = this.preambleProperty.getValue();
        if (!this.databaseContext.getDatabase().getPreamble().orElse("").equals(newPreamble)) {
            this.undoManager.addEdit(new UndoablePreambleChange(this.databaseContext.getDatabase(), this.databaseContext.getDatabase().getPreamble().orElse(null), newPreamble));
            this.databaseContext.getDatabase().setPreamble(newPreamble);
        }
    }

    public StringProperty preambleProperty() {
        return this.preambleProperty;
    }
}

