/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.contentselectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import org.jabref.gui.DialogService;
import org.jabref.gui.libraryproperties.PropertiesTabViewModel;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.MetaData;

public class ContentSelectorViewModel
implements PropertiesTabViewModel {
    private final MetaData metaData;
    private final DialogService dialogService;
    private Map<Field, List<String>> fieldKeywordsMap = new HashMap<Field, List<String>>();
    private final ListProperty<Field> fields = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<String> keywords = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<Field> selectedField = new SimpleObjectProperty();
    private final StringProperty selectedKeyword = new SimpleStringProperty();

    ContentSelectorViewModel(BibDatabaseContext databaseContext, DialogService dialogService) {
        this.metaData = databaseContext.getMetaData();
        this.dialogService = dialogService;
    }

    @Override
    public void setValues() {
        this.fieldKeywordsMap = ContentSelectors.getFieldKeywordsMap(this.metaData.getContentSelectors().getContentSelectors());
        ArrayList<Field> existingFields = new ArrayList<Field>(this.fieldKeywordsMap.keySet());
        this.fields.addAll(existingFields);
        if (this.fields.isEmpty()) {
            ContentSelectors.DEFAULT_FIELD_NAMES.forEach(this::addFieldIfUnique);
        }
    }

    @Override
    public void storeSettings() {
        List<Field> metaDataFields = this.metaData.getContentSelectors().getFieldsWithSelectors();
        List<Field> fieldNamesToRemove = ContentSelectors.isDefaultMap(this.fieldKeywordsMap) ? this.metaData.getContentSelectorsSorted().stream().map(ContentSelector::getField).toList() : this.determineFieldsToRemove();
        this.fieldKeywordsMap.forEach((field, keywords) -> this.updateMetaDataContentSelector(metaDataFields, (Field)field, (List<String>)keywords));
        fieldNamesToRemove.forEach(this.metaData::clearContentSelectors);
    }

    public ListProperty<Field> getFieldNamesBackingList() {
        return this.fields;
    }

    public ObjectProperty<Field> selectedFieldProperty() {
        return this.selectedField;
    }

    public BooleanBinding isFieldNameListEmpty() {
        return Bindings.isEmpty(this.fields);
    }

    public BooleanBinding isNoFieldNameSelected() {
        return Bindings.isEmpty((ObservableStringValue)this.selectedField.asString());
    }

    public ListProperty<String> getKeywordsBackingList() {
        return this.keywords;
    }

    StringProperty selectedKeywordProperty() {
        return this.selectedKeyword;
    }

    BooleanBinding isNoKeywordSelected() {
        return Bindings.isEmpty((ObservableStringValue)this.selectedKeyword);
    }

    void showInputFieldNameDialog() {
        this.dialogService.showEditableChoiceDialogAndWait(Localization.lang("Add new field name", new Object[0]), Localization.lang("Field name", new Object[0]), Localization.lang("Add", new Object[0]), FXCollections.observableArrayList(FieldFactory.getStandardFieldsWithCitationKey()), FieldsUtil.FIELD_STRING_CONVERTER).ifPresent(this::addFieldIfUnique);
    }

    private void addFieldIfUnique(Field fieldToAdd) {
        boolean exists = this.fieldKeywordsMap.containsKey(fieldToAdd);
        if (exists) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Field name \"%0\" already exists", fieldToAdd.getDisplayName()));
            return;
        }
        this.fieldKeywordsMap.put(fieldToAdd, new ArrayList());
        this.fields.add((Object)fieldToAdd);
    }

    void showRemoveFieldNameConfirmationDialog(Field fieldToRemove) {
        if (fieldToRemove == null) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("No field name selected!", new Object[0]));
            return;
        }
        boolean deleteConfirmed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove field name", new Object[0]), Localization.lang("Are you sure you want to remove field name: \"%0\"?", fieldToRemove.getDisplayName()));
        if (deleteConfirmed) {
            this.removeFieldName(fieldToRemove);
        }
    }

    private void removeFieldName(Field fieldToRemove) {
        this.fieldKeywordsMap.remove(fieldToRemove);
        this.fields.remove((Object)fieldToRemove);
    }

    void populateKeywords(Field selectedField) {
        this.keywords.clear();
        if (selectedField != null) {
            this.keywords.addAll((Collection)this.fieldKeywordsMap.get(selectedField));
        }
    }

    void showInputKeywordDialog(Field selectedField) {
        this.dialogService.showInputDialogAndWait(Localization.lang("Add new keyword", new Object[0]), Localization.lang("Keyword:", new Object[0])).ifPresent(newKeyword -> this.addKeywordIfUnique(selectedField, (String)newKeyword));
    }

    private void addKeywordIfUnique(Field field, String keywordToAdd) {
        boolean exists = this.fieldKeywordsMap.get(field).contains(keywordToAdd);
        if (exists) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Keyword \"%0\" already exists", keywordToAdd));
            return;
        }
        List existingKeywords = this.fieldKeywordsMap.getOrDefault(field, new ArrayList());
        existingKeywords.add(keywordToAdd);
        existingKeywords.sort(Comparator.naturalOrder());
        this.fieldKeywordsMap.put(field, existingKeywords);
        this.populateKeywords(field);
    }

    void showRemoveKeywordConfirmationDialog(Field field, String keywordToRemove) {
        boolean deleteConfirmed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove keyword", new Object[0]), Localization.lang("Are you sure you want to remove keyword: \"%0\"?", keywordToRemove));
        if (deleteConfirmed) {
            this.removeKeyword(field, keywordToRemove);
        }
    }

    private void removeKeyword(Field field, String keywordToRemove) {
        this.fieldKeywordsMap.get(field).remove(keywordToRemove);
        this.keywords.remove((Object)keywordToRemove);
    }

    private List<Field> determineFieldsToRemove() {
        Set<Field> newlyAddedKeywords = this.fieldKeywordsMap.keySet();
        ArrayList<Field> result = new ArrayList<Field>(this.metaData.getContentSelectors().getFieldsWithSelectors().stream().filter(field -> !newlyAddedKeywords.contains(field)).toList());
        result.addAll(this.fieldKeywordsMap.entrySet().stream().filter(entry -> ContentSelectors.DEFAULT_FIELD_NAMES.contains(entry.getKey()) && ((List)entry.getValue()).isEmpty()).map(Map.Entry::getKey).toList());
        return result;
    }

    private void updateMetaDataContentSelector(List<Field> existingFields, Field field, List<String> keywords) {
        boolean fieldNameDoNotExists;
        boolean bl = fieldNameDoNotExists = !existingFields.contains(field);
        if (fieldNameDoNotExists) {
            this.metaData.addContentSelector(new ContentSelector(field, keywords));
        }
        if (this.keywordsHaveChanged(field, keywords)) {
            this.metaData.clearContentSelectors(field);
            this.metaData.addContentSelector(new ContentSelector(field, keywords));
        }
    }

    private boolean keywordsHaveChanged(Field field, List<String> keywords) {
        List<String> existingKeywords;
        HashSet<String> keywordsSet = this.asHashSet(keywords);
        if (!keywordsSet.equals(this.asHashSet(existingKeywords = this.metaData.getContentSelectorValuesForField(field)))) {
            return true;
        }
        return !keywordsSet.isEmpty() && existingKeywords.isEmpty();
    }

    private HashSet<String> asHashSet(List<String> listToConvert) {
        return new HashSet<String>(listToConvert);
    }
}

