/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.contentselectors;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.property.ListProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.libraryproperties.AbstractPropertiesTabView;
import org.jabref.gui.libraryproperties.contentselectors.ContentSelectorViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.Field;

public class ContentSelectorView
extends AbstractPropertiesTabView<ContentSelectorViewModel> {
    @FXML
    private Button removeFieldNameButton;
    @FXML
    private Button addKeywordButton;
    @FXML
    private Button removeKeywordButton;
    @FXML
    private ListView<Field> fieldsListView;
    @FXML
    private ListView<String> keywordsListView;
    @Inject
    private DialogService dialogService;
    private final BibDatabaseContext databaseContext;

    public ContentSelectorView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Content selectors", new Object[0]);
    }

    @FXML
    public void initialize() {
        this.viewModel = new ContentSelectorViewModel(this.databaseContext, this.dialogService);
        this.initFieldNameComponents();
        this.initKeywordsComponents();
    }

    private void initFieldNameComponents() {
        this.initListView(this.fieldsListView, ((ContentSelectorViewModel)this.viewModel)::getFieldNamesBackingList);
        ((ContentSelectorViewModel)this.viewModel).selectedFieldProperty().bind((ObservableValue)this.fieldsListView.getSelectionModel().selectedItemProperty());
        new ViewModelListCellFactory().withText(Field::getDisplayName).install(this.fieldsListView);
        this.removeFieldNameButton.disableProperty().bind((ObservableValue)((ContentSelectorViewModel)this.viewModel).isNoFieldNameSelected());
        EasyBind.subscribe(((ContentSelectorViewModel)this.viewModel).selectedFieldProperty(), ((ContentSelectorViewModel)this.viewModel)::populateKeywords);
    }

    private void initKeywordsComponents() {
        this.initListView(this.keywordsListView, ((ContentSelectorViewModel)this.viewModel)::getKeywordsBackingList);
        ((ContentSelectorViewModel)this.viewModel).selectedKeywordProperty().bind((ObservableValue)this.keywordsListView.getSelectionModel().selectedItemProperty());
        this.addKeywordButton.disableProperty().bind((ObservableValue)((ContentSelectorViewModel)this.viewModel).isFieldNameListEmpty());
        this.removeKeywordButton.disableProperty().bind((ObservableValue)((ContentSelectorViewModel)this.viewModel).isNoKeywordSelected());
    }

    @FXML
    private void addNewFieldName() {
        ((ContentSelectorViewModel)this.viewModel).showInputFieldNameDialog();
    }

    @FXML
    private void removeFieldName() {
        this.getSelectedField().ifPresent(((ContentSelectorViewModel)this.viewModel)::showRemoveFieldNameConfirmationDialog);
    }

    @FXML
    private void addNewKeyword() {
        this.getSelectedField().ifPresent(((ContentSelectorViewModel)this.viewModel)::showInputKeywordDialog);
    }

    @FXML
    private void removeKeyword() {
        Optional<Field> fieldName = this.getSelectedField();
        Optional<String> keywordToRemove = this.getSelectedKeyword();
        if (fieldName.isPresent() && keywordToRemove.isPresent()) {
            ((ContentSelectorViewModel)this.viewModel).showRemoveKeywordConfirmationDialog(fieldName.get(), keywordToRemove.get());
        }
    }

    private <T> void initListView(ListView<T> listViewToInit, Supplier<ListProperty<T>> backingList) {
        listViewToInit.itemsProperty().bind((ObservableValue)backingList.get());
        listViewToInit.getSelectionModel().selectFirst();
    }

    private Optional<Field> getSelectedField() {
        return Optional.of(this.fieldsListView.getSelectionModel()).map(SelectionModel::getSelectedItem);
    }

    private Optional<String> getSelectedKeyword() {
        return Optional.of(this.keywordsListView.getSelectionModel()).map(SelectionModel::getSelectedItem);
    }
}

