/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.beans.property.MapProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.collections.FXCollections;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.util.OS;

public class KeyBindingRepository {
    private final MapProperty<KeyBinding, String> bindings;

    public KeyBindingRepository() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public KeyBindingRepository(SortedMap<KeyBinding, String> bindings) {
        this.bindings = new SimpleMapProperty(FXCollections.observableMap(bindings));
    }

    public KeyBindingRepository(List<String> bindNames, List<String> bindings) {
        this.bindings = new SimpleMapProperty(FXCollections.observableMap(new TreeMap(Comparator.comparing(KeyBinding::getLocalization))));
        if (bindNames.isEmpty() || bindings.isEmpty() || bindNames.size() != bindings.size()) {
            for (KeyBinding keyBinding : KeyBinding.values()) {
                this.put(keyBinding, keyBinding.getDefaultKeyBinding());
            }
        } else {
            for (int i = 0; i < bindNames.size(); ++i) {
                this.put(bindNames.get(i), bindings.get(i));
            }
        }
    }

    public static boolean checkKeyCombinationEquality(KeyCombination combination, KeyEvent keyEvent) {
        KeyCode code = keyEvent.getCode();
        if (code == KeyCode.UNDEFINED) {
            return false;
        }
        return combination.match(keyEvent);
    }

    public Optional<String> get(KeyBinding key) {
        return Optional.ofNullable((String)this.bindings.get((Object)key));
    }

    public String get(String key) {
        Optional<KeyBinding> keyBinding = this.getKeyBinding(key);
        Optional result = keyBinding.flatMap(k -> Optional.ofNullable((String)this.bindings.get((Object)k)));
        if (result.isPresent()) {
            return (String)result.get();
        }
        if (keyBinding.isPresent()) {
            return keyBinding.get().getDefaultKeyBinding();
        }
        return "Not associated";
    }

    public SortedMap<KeyBinding, String> getKeyBindings() {
        return new TreeMap<KeyBinding, String>((Map<KeyBinding, String>)this.bindings);
    }

    public void put(KeyBinding key, String value) {
        this.bindings.put((Object)key, (Object)value);
    }

    public void put(String key, String value) {
        this.getKeyBinding(key).ifPresent(binding -> this.put((KeyBinding)((Object)binding), value));
    }

    private Optional<KeyBinding> getKeyBinding(String key) {
        return Arrays.stream(KeyBinding.values()).filter(b -> b.getConstant().equals(key)).findFirst();
    }

    public void resetToDefault(String key) {
        this.getKeyBinding(key).ifPresent(b -> this.bindings.put((Object)b, (Object)b.getDefaultKeyBinding()));
    }

    public void resetToDefault() {
        this.bindings.forEach((b, s) -> this.bindings.put((Object)b, (Object)b.getDefaultKeyBinding()));
    }

    public int size() {
        return this.bindings.size();
    }

    public Optional<KeyBinding> mapToKeyBinding(KeyEvent keyEvent) {
        for (KeyBinding binding : KeyBinding.values()) {
            if (!this.checkKeyCombinationEquality(binding, keyEvent)) continue;
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    private Set<KeyBinding> mapToKeyBindings(KeyEvent keyEvent) {
        return Arrays.stream(KeyBinding.values()).filter(binding -> this.checkKeyCombinationEquality((KeyBinding)((Object)binding), keyEvent)).collect(Collectors.toSet());
    }

    public boolean matches(KeyEvent event, KeyBinding keyBinding) {
        return this.mapToKeyBindings(event).stream().anyMatch(binding -> binding == keyBinding);
    }

    public Optional<KeyCombination> getKeyCombination(KeyBinding bindName) {
        String binding = this.get(bindName.getConstant());
        if (binding.isEmpty()) {
            return Optional.empty();
        }
        if (OS.OS_X) {
            binding = binding.replace("ctrl", "meta");
        }
        return Optional.of(KeyCombination.valueOf((String)binding));
    }

    public boolean checkKeyCombinationEquality(KeyBinding binding, KeyEvent keyEvent) {
        return this.getKeyCombination(binding).filter(combination -> KeyBindingRepository.checkKeyCombinationEquality(combination, keyEvent)).isPresent();
    }

    public List<String> getBindNames() {
        return this.bindings.keySet().stream().map(KeyBinding::getConstant).collect(Collectors.toList());
    }

    public List<String> getBindings() {
        return new ArrayList<String>(this.bindings.values());
    }

    public MapProperty<KeyBinding, String> getBindingsProperty() {
        return this.bindings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBindingRepository that = (KeyBindingRepository)o;
        return this.bindings.equals(that.bindings);
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }
}

