/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javax.swing.undo.UndoManager;
import org.controlsfx.control.CheckListView;
import org.fxmisc.richtext.CodeArea;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.entryeditor.citationrelationtab.BibEntryView;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.importer.ImportEntriesViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.NoSelectionModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class ImportEntriesDialog
extends BaseDialog<Boolean> {
    @FXML
    private CheckListView<BibEntry> entriesListView;
    @FXML
    private ComboBox<BibDatabaseContext> libraryListView;
    @FXML
    private ButtonType importButton;
    @FXML
    private Label totalItems;
    @FXML
    private Label selectedItems;
    @FXML
    private Label bibTeXDataLabel;
    @FXML
    private CheckBox downloadLinkedOnlineFiles;
    @FXML
    private CheckBox showEntryInformation;
    @FXML
    private CodeArea bibTeXData;
    @FXML
    private VBox bibTeXDataBox;
    private final BackgroundTask<ParserResult> task;
    private final BibDatabaseContext database;
    private ImportEntriesViewModel viewModel;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private DialogService dialogService;
    @Inject
    private UndoManager undoManager;
    @Inject
    private PreferencesService preferences;
    @Inject
    private StateManager stateManager;
    @Inject
    private BibEntryTypesManager entryTypesManager;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;

    public ImportEntriesDialog(BibDatabaseContext database, BackgroundTask<ParserResult> task) {
        this.database = database;
        this.task = task;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        BooleanBinding booleanBind = Bindings.isEmpty((ObservableList)this.entriesListView.getCheckModel().getCheckedItems());
        Button btn = (Button)this.getDialogPane().lookupButton(this.importButton);
        btn.disableProperty().bind((ObservableValue)booleanBind);
        this.downloadLinkedOnlineFiles.setSelected(this.preferences.getFilePreferences().shouldDownloadLinkedFiles());
        this.setResultConverter(button -> {
            if (button == this.importButton) {
                this.viewModel.importEntries((List<BibEntry>)this.entriesListView.getCheckModel().getCheckedItems(), this.downloadLinkedOnlineFiles.isSelected());
            } else {
                this.dialogService.notify(Localization.lang("Import canceled", new Object[0]));
            }
            return false;
        });
    }

    @FXML
    private void initialize() {
        this.viewModel = new ImportEntriesViewModel(this.task, this.taskExecutor, this.database, this.dialogService, this.undoManager, this.preferences, this.stateManager, this.entryTypesManager, this.fileUpdateMonitor);
        Label placeholder = new Label();
        placeholder.textProperty().bind((ObservableValue)this.viewModel.messageProperty());
        this.entriesListView.setPlaceholder((Node)placeholder);
        this.entriesListView.setItems(this.viewModel.getEntries());
        this.libraryListView.setEditable(false);
        this.libraryListView.getItems().addAll(this.stateManager.getOpenDatabases());
        new ViewModelListCellFactory().withText(database -> {
            Optional<String> dbOpt = Optional.empty();
            if (database.getDatabasePath().isPresent()) {
                dbOpt = FileUtil.getUniquePathFragment(this.stateManager.collectAllDatabasePaths(), database.getDatabasePath().get());
            }
            if (database.getLocation() == DatabaseLocation.SHARED) {
                return database.getDBMSSynchronizer().getDBName() + " [" + Localization.lang("shared", new Object[0]) + "]";
            }
            return dbOpt.orElseGet(() -> Localization.lang("untitled", new Object[0]));
        }).install(this.libraryListView);
        this.viewModel.selectedDbProperty().bind((ObservableValue)this.libraryListView.getSelectionModel().selectedItemProperty());
        this.stateManager.getActiveDatabase().ifPresent(database1 -> this.libraryListView.getSelectionModel().select(database1));
        PseudoClass entrySelected = PseudoClass.getPseudoClass((String)"selected");
        new ViewModelListCellFactory().withGraphic(entry -> {
            ToggleButton addToggle = IconTheme.JabRefIcons.ADD.asToggleButton();
            EasyBind.subscribe((ObservableValue)addToggle.selectedProperty(), selected -> {
                if (selected.booleanValue()) {
                    addToggle.setGraphic(IconTheme.JabRefIcons.ADD_FILLED.withColor(IconTheme.SELECTED_COLOR).getGraphicNode());
                } else {
                    addToggle.setGraphic(IconTheme.JabRefIcons.ADD.getGraphicNode());
                }
            });
            addToggle.getStyleClass().add((Object)"addEntryButton");
            addToggle.selectedProperty().bindBidirectional((Property)this.entriesListView.getItemBooleanProperty(entry));
            HBox separator = new HBox();
            HBox.setHgrow((Node)separator, (Priority)Priority.SOMETIMES);
            Node entryNode = BibEntryView.getEntryNode(entry);
            HBox.setHgrow((Node)entryNode, (Priority)Priority.ALWAYS);
            HBox container = new HBox(new Node[]{entryNode, separator, addToggle});
            container.getStyleClass().add((Object)"entry-container");
            container.prefWidthProperty().bind((ObservableValue)this.entriesListView.widthProperty().subtract(25));
            BackgroundTask.wrap(() -> this.viewModel.hasDuplicate((BibEntry)entry)).onSuccess(duplicateFound -> {
                if (duplicateFound.booleanValue()) {
                    Node icon = IconTheme.JabRefIcons.ERROR.getGraphicNode();
                    Tooltip tooltip = new Tooltip(Localization.lang("Possible duplicate of existing entry. Will be resolved on import.", new Object[0]));
                    Tooltip.install((Node)icon, (Tooltip)tooltip);
                    container.getChildren().add((Object)icon);
                }
            }).executeWith(this.taskExecutor);
            if (this.entriesListView.getItems().size() == 1) {
                this.selectAllNewEntries();
            }
            return container;
        }).withOnMouseClickedEvent((entry, event) -> {
            this.entriesListView.getCheckModel().toggleCheckState(entry);
            this.displayBibTeX((BibEntry)entry, this.viewModel.getSourceString((BibEntry)entry));
        }).withPseudoClass(entrySelected, (Callback<BibEntry, ObservableValue<Boolean>>)((Callback)arg_0 -> this.entriesListView.getItemBooleanProperty(arg_0))).install((ListView<BibEntry>)this.entriesListView);
        this.selectedItems.textProperty().bind((ObservableValue)Bindings.size((ObservableList)this.entriesListView.getCheckModel().getCheckedItems()).asString());
        this.totalItems.textProperty().bind((ObservableValue)Bindings.size((ObservableList)this.entriesListView.getItems()).asString());
        this.entriesListView.setSelectionModel(new NoSelectionModel());
        this.initBibTeX();
    }

    private void displayBibTeX(BibEntry entry, String bibTeX) {
        if (this.entriesListView.getCheckModel().isChecked((Object)entry)) {
            this.bibTeXData.clear();
            this.bibTeXData.appendText(bibTeX);
            this.bibTeXData.moveTo(0);
            this.bibTeXData.requestFollowCaret();
        } else {
            this.bibTeXData.clear();
        }
    }

    private void initBibTeX() {
        this.bibTeXDataLabel.setText(Localization.lang("%0 source", "BibTeX"));
        this.bibTeXData.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GREY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        this.bibTeXData.setPadding(new Insets(5.0));
        this.showEntryInformation.selectedProperty().addListener((observableValue, old_val, new_val) -> {
            this.bibTeXDataBox.setVisible(new_val.booleanValue());
            this.bibTeXDataBox.setManaged(new_val.booleanValue());
        });
    }

    public void unselectAll() {
        this.entriesListView.getCheckModel().clearChecks();
    }

    public void selectAllNewEntries() {
        this.unselectAll();
        for (BibEntry entry : this.entriesListView.getItems()) {
            if (this.viewModel.hasDuplicate(entry)) continue;
            this.entriesListView.getCheckModel().check((Object)entry);
            this.displayBibTeX(entry, this.viewModel.getSourceString(entry));
        }
    }

    public void selectAllEntries() {
        this.unselectAll();
        this.entriesListView.getCheckModel().checkAll();
    }
}

