/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import org.jabref.gui.DialogService;
import org.jabref.logic.importer.fetcher.GrobidPreferences;
import org.jabref.logic.l10n.Localization;

public class GrobidOptInDialogHelper {
    public static boolean showAndWaitIfUserIsUndecided(DialogService dialogService, GrobidPreferences preferences) {
        if (preferences.isGrobidEnabled()) {
            return true;
        }
        if (preferences.isGrobidOptOut()) {
            return false;
        }
        boolean grobidEnabled = dialogService.showConfirmationDialogWithOptOutAndWait(Localization.lang("Remote services", new Object[0]), Localization.lang("Allow sending PDF files and raw citation strings to a JabRef online service (Grobid) to determine Metadata. This produces better results.", new Object[0]), Localization.lang("Do not ask again", new Object[0]), optOut -> preferences.grobidOptOutProperty().setValue(optOut));
        preferences.grobidEnabledProperty().setValue(Boolean.valueOf(grobidEnabled));
        return grobidEnabled;
    }
}

