/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.icon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import org.jabref.gui.icon.InternalMaterialDesignIcon;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.icon.JabRefMaterialDesignIcon;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonProvider;
import org.kordamp.ikonli.materialdesign2.MaterialDesignA;
import org.kordamp.ikonli.materialdesign2.MaterialDesignB;
import org.kordamp.ikonli.materialdesign2.MaterialDesignC;
import org.kordamp.ikonli.materialdesign2.MaterialDesignD;
import org.kordamp.ikonli.materialdesign2.MaterialDesignE;
import org.kordamp.ikonli.materialdesign2.MaterialDesignF;
import org.kordamp.ikonli.materialdesign2.MaterialDesignG;
import org.kordamp.ikonli.materialdesign2.MaterialDesignH;
import org.kordamp.ikonli.materialdesign2.MaterialDesignI;
import org.kordamp.ikonli.materialdesign2.MaterialDesignK;
import org.kordamp.ikonli.materialdesign2.MaterialDesignL;
import org.kordamp.ikonli.materialdesign2.MaterialDesignM;
import org.kordamp.ikonli.materialdesign2.MaterialDesignN;
import org.kordamp.ikonli.materialdesign2.MaterialDesignO;
import org.kordamp.ikonli.materialdesign2.MaterialDesignP;
import org.kordamp.ikonli.materialdesign2.MaterialDesignR;
import org.kordamp.ikonli.materialdesign2.MaterialDesignS;
import org.kordamp.ikonli.materialdesign2.MaterialDesignT;
import org.kordamp.ikonli.materialdesign2.MaterialDesignU;
import org.kordamp.ikonli.materialdesign2.MaterialDesignV;
import org.kordamp.ikonli.materialdesign2.MaterialDesignW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconTheme {
    public static final Color DEFAULT_DISABLED_COLOR = Color.web((String)"#c8c8c8");
    public static final Color SELECTED_COLOR = Color.web((String)"#50618F");
    private static final String DEFAULT_ICON_PATH = "/images/external/red.png";
    private static final Logger LOGGER = LoggerFactory.getLogger(IconTheme.class);
    private static final Map<String, String> KEY_TO_ICON = IconTheme.readIconThemeFile(IconTheme.class.getResource("/images/Icons.properties"), "/images/external/");
    private static final Set<Ikon> ICON_NAMES = new HashSet<Ikon>();

    public static Color getDefaultGroupColor() {
        return Color.web((String)"#8a8a8a");
    }

    public static Optional<JabRefIcon> findIcon(String code, Color color) {
        if (ICON_NAMES.isEmpty()) {
            IconTheme.loadAllIkons();
        }
        return ICON_NAMES.stream().filter(icon -> icon.toString().equals(code.toUpperCase(Locale.ENGLISH))).map(internalMat -> new InternalMaterialDesignIcon((Ikon)internalMat).withColor(color)).findFirst();
    }

    public static Image getJabRefImage() {
        return IconTheme.getImageFX("jabrefIcon48");
    }

    private static void loadAllIkons() {
        ServiceLoader<IkonProvider> providers = ServiceLoader.load(IkonProvider.class);
        for (IkonProvider provider : providers) {
            ICON_NAMES.addAll(EnumSet.allOf(provider.getIkon()));
        }
    }

    private static Image getImageFX(String name) {
        return new Image(IconTheme.getIconUrl(name).toString());
    }

    public static URL getIconUrl(String name) {
        String key = Objects.requireNonNull(name, "icon name");
        if (!KEY_TO_ICON.containsKey(key)) {
            LOGGER.warn("Could not find icon url by name " + name + ", so falling back on default icon /images/external/red.png");
        }
        String path = KEY_TO_ICON.getOrDefault(key, DEFAULT_ICON_PATH);
        return Objects.requireNonNull(IconTheme.class.getResource(path), "Path must not be null for key " + key);
    }

    private static Map<String, String> readIconThemeFile(URL url, String prefix) {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(prefix, "prefix");
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains("=")) continue;
                int index = line.indexOf(61);
                String key = line.substring(0, index).trim();
                String value = prefix + line.substring(index + 1).trim();
                result.put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read default icon theme.", (Throwable)e);
        }
        return result;
    }

    public static List<Image> getLogoSetFX() {
        ArrayList<Image> jabrefLogos = new ArrayList<Image>();
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon16").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon20").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon32").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon40").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon48").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon64").toString()));
        jabrefLogos.add(new Image(IconTheme.getIconUrl("jabrefIcon128").toString()));
        return jabrefLogos;
    }

    public static enum JabRefIcons implements JabRefIcon
    {
        ADD(new Ikon[]{MaterialDesignP.PLUS_CIRCLE_OUTLINE}),
        ADD_FILLED(new Ikon[]{MaterialDesignP.PLUS_CIRCLE}),
        ADD_NOBOX(new Ikon[]{MaterialDesignP.PLUS}),
        ADD_ARTICLE(new Ikon[]{MaterialDesignP.PLUS}),
        ADD_ENTRY(new Ikon[]{MaterialDesignP.PLAYLIST_PLUS}),
        EDIT_ENTRY(new Ikon[]{MaterialDesignT.TOOLTIP_EDIT}),
        EDIT_STRINGS(new Ikon[]{MaterialDesignT.TOOLTIP_TEXT}),
        FOLDER(new Ikon[]{MaterialDesignF.FOLDER_OUTLINE}),
        REMOVE(new Ikon[]{MaterialDesignM.MINUS_BOX}),
        REMOVE_NOBOX(new Ikon[]{MaterialDesignM.MINUS}),
        FILE(new Ikon[]{MaterialDesignF.FILE_OUTLINE}),
        PDF_FILE(new Ikon[]{MaterialDesignF.FILE_PDF}),
        DOI(new Ikon[]{MaterialDesignB.BARCODE_SCAN}),
        DUPLICATE(new Ikon[]{MaterialDesignC.CONTENT_DUPLICATE}),
        EDIT(new Ikon[]{MaterialDesignP.PENCIL}),
        NEW(new Ikon[]{MaterialDesignF.FOLDER_PLUS}),
        SAVE(new Ikon[]{MaterialDesignC.CONTENT_SAVE}),
        SAVE_ALL(new Ikon[]{MaterialDesignC.CONTENT_SAVE_ALL}),
        CLOSE(new Ikon[]{MaterialDesignC.CLOSE_CIRCLE}),
        PASTE(JabRefMaterialDesignIcon.PASTE),
        CUT(new Ikon[]{MaterialDesignC.CONTENT_CUT}),
        COPY(new Ikon[]{MaterialDesignC.CONTENT_COPY}),
        COMMENT(new Ikon[]{MaterialDesignC.COMMENT}),
        REDO(new Ikon[]{MaterialDesignR.REDO}),
        UNDO(new Ikon[]{MaterialDesignU.UNDO}),
        MARKER(new Ikon[]{MaterialDesignM.MARKER}),
        REFRESH(new Ikon[]{MaterialDesignR.REFRESH}),
        MEMORYSTICK(new Ikon[]{MaterialDesignU.USB_FLASH_DRIVE_OUTLINE}),
        DELETE_ENTRY(new Ikon[]{MaterialDesignD.DELETE}),
        SEARCH(new Ikon[]{MaterialDesignM.MAGNIFY}),
        FILE_SEARCH(new Ikon[]{MaterialDesignF.FILE_FIND}),
        FILE_STAR(new Ikon[]{MaterialDesignF.FILE_STAR}),
        PDF_METADATA_READ(new Ikon[]{MaterialDesignF.FORMAT_ALIGN_TOP}),
        PDF_METADATA_WRITE(new Ikon[]{MaterialDesignF.FORMAT_ALIGN_BOTTOM}),
        ADVANCED_SEARCH(Color.CYAN, new Ikon[]{MaterialDesignM.MAGNIFY}),
        PREFERENCES(new Ikon[]{MaterialDesignC.COG}),
        SELECTORS(new Ikon[]{MaterialDesignS.STAR_SETTINGS}),
        HELP(new Ikon[]{MaterialDesignH.HELP_CIRCLE}),
        UP(new Ikon[]{MaterialDesignA.ARROW_UP}),
        DOWN(new Ikon[]{MaterialDesignA.ARROW_DOWN}),
        LEFT(new Ikon[]{MaterialDesignA.ARROW_LEFT_BOLD}),
        RIGHT(new Ikon[]{MaterialDesignA.ARROW_RIGHT_BOLD}),
        SOURCE(new Ikon[]{MaterialDesignC.CODE_BRACES}),
        MAKE_KEY(new Ikon[]{MaterialDesignK.KEY_VARIANT}),
        CLEANUP_ENTRIES(new Ikon[]{MaterialDesignB.BROOM}),
        PRIORITY(new Ikon[]{MaterialDesignF.FLAG}),
        PRIORITY_HIGH(Color.RED, new Ikon[]{MaterialDesignF.FLAG}),
        PRIORITY_MEDIUM(Color.ORANGE, new Ikon[]{MaterialDesignF.FLAG}),
        PRIORITY_LOW(Color.rgb((int)111, (int)204, (int)117), new Ikon[]{MaterialDesignF.FLAG}),
        PRINTED(new Ikon[]{MaterialDesignP.PRINTER}),
        RANKING(new Ikon[]{MaterialDesignS.STAR}),
        RANK1(new Ikon[]{MaterialDesignS.STAR, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE}),
        RANK2(new Ikon[]{MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE}),
        RANK3(new Ikon[]{MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR_OUTLINE, MaterialDesignS.STAR_OUTLINE}),
        RANK4(new Ikon[]{MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR_OUTLINE}),
        RANK5(new Ikon[]{MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR, MaterialDesignS.STAR}),
        WWW(new Ikon[]{MaterialDesignW.WEB}),
        GROUP_INCLUDING(new Ikon[]{MaterialDesignF.FILTER_OUTLINE}),
        GROUP_REFINING(new Ikon[]{MaterialDesignF.FILTER}),
        AUTO_GROUP(new Ikon[]{MaterialDesignA.AUTO_FIX}),
        GROUP_INTERSECTION(JabRefMaterialDesignIcon.SET_CENTER),
        GROUP_UNION(JabRefMaterialDesignIcon.SET_ALL),
        EMAIL(new Ikon[]{MaterialDesignE.EMAIL}),
        EXPORT_TO_CLIPBOARD(new Ikon[]{MaterialDesignC.CLIPBOARD_ARROW_LEFT}),
        ATTACH_FILE(new Ikon[]{MaterialDesignP.PAPERCLIP}),
        AUTO_FILE_LINK(new Ikon[]{MaterialDesignF.FILE_FIND}),
        AUTO_RENAME(new Ikon[]{MaterialDesignA.AUTO_FIX}),
        DOWNLOAD_FILE(new Ikon[]{MaterialDesignD.DOWNLOAD}),
        MOVE_TO_FOLDER(new Ikon[]{MaterialDesignF.FILE_SEND}),
        COPY_TO_FOLDER(new Ikon[]{MaterialDesignC.CONTENT_COPY}),
        RENAME(new Ikon[]{MaterialDesignR.RENAME_BOX}),
        DELETE_FILE(new Ikon[]{MaterialDesignD.DELETE_FOREVER}),
        REMOVE_LINK(new Ikon[]{MaterialDesignL.LINK_OFF}),
        AUTO_LINKED_FILE(new Ikon[]{MaterialDesignL.LINK_PLUS}),
        QUALITY_ASSURED(new Ikon[]{MaterialDesignC.CERTIFICATE}),
        QUALITY(new Ikon[]{MaterialDesignC.CERTIFICATE}),
        OPEN(new Ikon[]{MaterialDesignF.FOLDER_OUTLINE}),
        OPEN_LIST(new Ikon[]{MaterialDesignF.FOLDER_OPEN_OUTLINE}),
        ADD_ROW(new Ikon[]{MaterialDesignS.SERVER_PLUS}),
        REMOVE_ROW(new Ikon[]{MaterialDesignS.SERVER_MINUS}),
        PICTURE(new Ikon[]{MaterialDesignF.FILE_IMAGE}),
        READ_STATUS_READ(Color.rgb((int)111, (int)204, (int)117, (double)1.0), new Ikon[]{MaterialDesignE.EYE}),
        READ_STATUS_SKIMMED(Color.ORANGE, new Ikon[]{MaterialDesignE.EYE}),
        READ_STATUS(new Ikon[]{MaterialDesignE.EYE}),
        RELEVANCE(new Ikon[]{MaterialDesignS.STAR_CIRCLE}),
        MERGE_ENTRIES(new Ikon[]{MaterialDesignC.COMPARE}),
        CONNECT_OPEN_OFFICE(new Ikon[]{MaterialDesignO.OPEN_IN_APP}),
        PLAIN_TEXT_IMPORT_TODO(new Ikon[]{MaterialDesignC.CHECKBOX_BLANK_CIRCLE_OUTLINE}),
        PLAIN_TEXT_IMPORT_DONE(new Ikon[]{MaterialDesignC.CHECKBOX_MARKED_CIRCLE_OUTLINE}),
        DONATE(new Ikon[]{MaterialDesignG.GIFT}),
        MOVE_TAB_ARROW(new Ikon[]{MaterialDesignA.ARROW_UP_BOLD}),
        OPTIONAL(new Ikon[]{MaterialDesignL.LABEL_OUTLINE}),
        REQUIRED(new Ikon[]{MaterialDesignL.LABEL}),
        INTEGRITY_FAIL(Color.RED, new Ikon[]{MaterialDesignC.CLOSE_CIRCLE}),
        INTEGRITY_INFO(new Ikon[]{MaterialDesignI.INFORMATION}),
        INTEGRITY_WARN(new Ikon[]{MaterialDesignA.ALERT_CIRCLE}),
        INTEGRITY_SUCCESS(new Ikon[]{MaterialDesignC.CHECKBOX_MARKED_CIRCLE_OUTLINE}),
        GITHUB(new Ikon[]{MaterialDesignG.GITHUB}),
        TOGGLE_ENTRY_PREVIEW(new Ikon[]{MaterialDesignL.LIBRARY}),
        TOGGLE_GROUPS(new Ikon[]{MaterialDesignV.VIEW_LIST}),
        SHOW_PREFERENCES_LIST(new Ikon[]{MaterialDesignV.VIEW_LIST}),
        WRITE_XMP(new Ikon[]{MaterialDesignI.IMPORT}),
        FILE_WORD(new Ikon[]{MaterialDesignF.FILE_WORD}),
        FILE_EXCEL(new Ikon[]{MaterialDesignF.FILE_EXCEL}),
        FILE_POWERPOINT(new Ikon[]{MaterialDesignF.FILE_POWERPOINT}),
        FILE_TEXT(new Ikon[]{MaterialDesignF.FILE_DOCUMENT}),
        FILE_MULTIPLE(new Ikon[]{MaterialDesignF.FILE_MULTIPLE}),
        FILE_OPENOFFICE(JabRefMaterialDesignIcon.OPEN_OFFICE),
        APPLICATION_GENERIC(new Ikon[]{MaterialDesignA.APPLICATION}),
        APPLICATION_EMACS(JabRefMaterialDesignIcon.EMACS),
        APPLICATION_LYX(JabRefMaterialDesignIcon.LYX),
        APPLICATION_TEXSTUDIO(JabRefMaterialDesignIcon.TEX_STUDIO),
        APPLICATION_TEXMAKER(JabRefMaterialDesignIcon.TEX_MAKER),
        APPLICATION_VIM(JabRefMaterialDesignIcon.VIM),
        APPLICATION_WINEDT(JabRefMaterialDesignIcon.WINEDT),
        APPLICATION_SUBLIMETEXT(JabRefMaterialDesignIcon.SUBLIME_TEXT),
        APPLICATION_TEXSHOP(JabRefMaterialDesignIcon.TEXSHOP),
        APPLICATION_TEXWORS(JabRefMaterialDesignIcon.TEXWORKS),
        KEY_BINDINGS(new Ikon[]{MaterialDesignK.KEYBOARD}),
        FIND_DUPLICATES(new Ikon[]{MaterialDesignC.CODE_EQUAL}),
        CONNECT_DB(new Ikon[]{MaterialDesignC.CLOUD_UPLOAD}),
        SUCCESS(new Ikon[]{MaterialDesignC.CHECK_CIRCLE}),
        CHECK(new Ikon[]{MaterialDesignC.CHECK}),
        WARNING(new Ikon[]{MaterialDesignA.ALERT}),
        ERROR(new Ikon[]{MaterialDesignA.ALERT_CIRCLE}),
        CASE_SENSITIVE(new Ikon[]{MaterialDesignA.ALPHABETICAL}),
        REG_EX(new Ikon[]{MaterialDesignR.REGEX}),
        FULLTEXT(new Ikon[]{MaterialDesignF.FILE_EYE}),
        CONSOLE(new Ikon[]{MaterialDesignC.CONSOLE}),
        FORUM(new Ikon[]{MaterialDesignF.FORUM}),
        FACEBOOK(new Ikon[]{MaterialDesignF.FACEBOOK}),
        TWITTER(new Ikon[]{MaterialDesignT.TWITTER}),
        BLOG(new Ikon[]{MaterialDesignR.RSS}),
        DATE_PICKER(new Ikon[]{MaterialDesignC.CALENDAR}),
        DEFAULT_GROUP_ICON_COLORED(new Ikon[]{MaterialDesignR.RECORD}),
        DEFAULT_GROUP_ICON(new Ikon[]{MaterialDesignF.FILE_TREE}),
        DEFAULT_GROUP_ICON_COLUMN(new Ikon[]{MaterialDesignL.LABEL_OUTLINE}),
        ALL_ENTRIES_GROUP_ICON(new Ikon[]{MaterialDesignD.DATABASE}),
        IMPORT(new Ikon[]{MaterialDesignC.CALL_RECEIVED}),
        EXPORT(new Ikon[]{MaterialDesignC.CALL_MADE}),
        PREVIOUS_LEFT(new Ikon[]{MaterialDesignC.CHEVRON_LEFT}),
        PREVIOUS_UP(new Ikon[]{MaterialDesignC.CHEVRON_UP}),
        NEXT_RIGHT(new Ikon[]{MaterialDesignC.CHEVRON_RIGHT}),
        NEXT_DOWN(new Ikon[]{MaterialDesignC.CHEVRON_DOWN}),
        LIST_MOVE_LEFT(new Ikon[]{MaterialDesignC.CHEVRON_LEFT}),
        LIST_MOVE_UP(new Ikon[]{MaterialDesignC.CHEVRON_UP}),
        LIST_MOVE_RIGHT(new Ikon[]{MaterialDesignC.CHEVRON_RIGHT}),
        LIST_MOVE_DOWN(new Ikon[]{MaterialDesignC.CHEVRON_DOWN}),
        FIT_WIDTH(new Ikon[]{MaterialDesignA.ARROW_EXPAND_ALL}),
        FIT_SINGLE_PAGE(new Ikon[]{MaterialDesignN.NOTE}),
        ZOOM_OUT(new Ikon[]{MaterialDesignM.MAGNIFY_MINUS}),
        ZOOM_IN(new Ikon[]{MaterialDesignM.MAGNIFY_PLUS}),
        ENTRY_TYPE(new Ikon[]{MaterialDesignP.PENCIL}),
        NEW_GROUP(new Ikon[]{MaterialDesignP.PLUS}),
        OPEN_LINK(new Ikon[]{MaterialDesignO.OPEN_IN_NEW}),
        LOOKUP_IDENTIFIER(new Ikon[]{MaterialDesignS.SEARCH_WEB}),
        LINKED_FILE_ADD(new Ikon[]{MaterialDesignP.PLUS}),
        FETCH_FULLTEXT(new Ikon[]{MaterialDesignS.SEARCH_WEB}),
        FETCH_BY_IDENTIFIER(new Ikon[]{MaterialDesignC.CLIPBOARD_ARROW_DOWN}),
        TOGGLE_ABBREVIATION(new Ikon[]{MaterialDesignF.FORMAT_ALIGN_CENTER}),
        VIEW_JOURNAL_INFO(new Ikon[]{MaterialDesignI.INFORMATION_VARIANT}),
        NEW_FILE(new Ikon[]{MaterialDesignP.PLUS}),
        DOWNLOAD(new Ikon[]{MaterialDesignD.DOWNLOAD}),
        OWNER(new Ikon[]{MaterialDesignA.ACCOUNT}),
        CLOSE_JABREF(new Ikon[]{MaterialDesignD.DOOR}),
        ARTICLE(new Ikon[]{MaterialDesignF.FILE_DOCUMENT}),
        BOOK(new Ikon[]{MaterialDesignB.BOOK_OPEN_PAGE_VARIANT}),
        LATEX_CITATIONS(JabRefMaterialDesignIcon.TEX_STUDIO),
        LATEX_FILE_DIRECTORY(new Ikon[]{MaterialDesignF.FOLDER_OUTLINE}),
        LATEX_FILE(new Ikon[]{MaterialDesignF.FILE_OUTLINE}),
        LATEX_COMMENT(new Ikon[]{MaterialDesignC.COMMENT_TEXT_OUTLINE}),
        LATEX_LINE(new Ikon[]{MaterialDesignF.FORMAT_LINE_SPACING}),
        PASSWORD_REVEALED(new Ikon[]{MaterialDesignE.EYE}),
        ADD_ABBREVIATION_LIST(new Ikon[]{MaterialDesignP.PLUS}),
        OPEN_ABBREVIATION_LIST(new Ikon[]{MaterialDesignF.FOLDER_OUTLINE}),
        REMOVE_ABBREVIATION_LIST(new Ikon[]{MaterialDesignM.MINUS}),
        ADD_ABBREVIATION(new Ikon[]{MaterialDesignP.PLAYLIST_PLUS}),
        REMOVE_ABBREVIATION(new Ikon[]{MaterialDesignP.PLAYLIST_MINUS}),
        NEW_ENTRY_FROM_PLAIN_TEXT(new Ikon[]{MaterialDesignP.PLUS_BOX}),
        REMOTE_DATABASE(new Ikon[]{MaterialDesignD.DATABASE}),
        HOME(new Ikon[]{MaterialDesignH.HOME}),
        LINK(new Ikon[]{MaterialDesignL.LINK}),
        LINK_VARIANT(new Ikon[]{MaterialDesignL.LINK_VARIANT}),
        PROTECT_STRING(new Ikon[]{MaterialDesignC.CODE_BRACES}),
        SELECT_ICONS(new Ikon[]{MaterialDesignA.APPS}),
        KEEP_SEARCH_STRING(new Ikon[]{MaterialDesignE.EARTH}),
        KEEP_ON_TOP(new Ikon[]{MaterialDesignP.PIN}),
        KEEP_ON_TOP_OFF(new Ikon[]{MaterialDesignP.PIN_OFF_OUTLINE}),
        OPEN_GLOBAL_SEARCH(new Ikon[]{MaterialDesignO.OPEN_IN_NEW}),
        REMOVE_TAGS(new Ikon[]{MaterialDesignC.CLOSE}),
        ACCEPT_LEFT(new Ikon[]{MaterialDesignS.SUBDIRECTORY_ARROW_LEFT}),
        ACCEPT_RIGHT(new Ikon[]{MaterialDesignS.SUBDIRECTORY_ARROW_RIGHT}),
        MERGE_GROUPS(new Ikon[]{MaterialDesignS.SOURCE_MERGE});

        private final JabRefIcon icon;

        private JabRefIcons(Ikon ... icons) {
            this.icon = new InternalMaterialDesignIcon(icons);
        }

        private JabRefIcons(Color color, Ikon ... icons) {
            this.icon = new InternalMaterialDesignIcon(color, icons);
        }

        @Override
        public Ikon getIkon() {
            return this.icon.getIkon();
        }

        @Override
        public Node getGraphicNode() {
            return this.icon.getGraphicNode();
        }

        public Button asButton() {
            Button button = new Button();
            button.setGraphic(this.getGraphicNode());
            button.getStyleClass().add((Object)"icon-button");
            return button;
        }

        public ToggleButton asToggleButton() {
            ToggleButton button = new ToggleButton();
            button.setGraphic(this.getGraphicNode());
            button.getStyleClass().add((Object)"icon-button");
            return button;
        }

        @Override
        public JabRefIcon withColor(Color color) {
            return this.icon.withColor(color);
        }

        @Override
        public JabRefIcon disabled() {
            return this.icon.disabled();
        }
    }
}

