/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.help;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jabref.gui.DialogService;
import org.jabref.gui.help.NewVersionDialog;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.Version;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.InternalPreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionWorker.class);
    private final Version installedVersion;
    private final DialogService dialogService;
    private final TaskExecutor taskExecutor;
    private final InternalPreferences internalPreferences;
    private final FilePreferences filePreferences;

    public VersionWorker(Version installedVersion, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferencesService) {
        this.installedVersion = Objects.requireNonNull(installedVersion);
        this.dialogService = Objects.requireNonNull(dialogService);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.internalPreferences = preferencesService.getInternalPreferences();
        this.filePreferences = preferencesService.getFilePreferences();
    }

    private Optional<Version> getNewVersion() throws IOException {
        List<Version> availableVersions = Version.getAllAvailableVersions();
        return this.installedVersion.shouldBeUpdatedTo(availableVersions);
    }

    public void checkForNewVersionAsync() {
        if (!this.internalPreferences.isVersionCheckEnabled()) {
            return;
        }
        BackgroundTask.wrap(this::getNewVersion).onSuccess(version -> this.showUpdateInfo((Optional<Version>)version, true)).onFailure(exception -> this.showConnectionError((Exception)exception, true)).executeWith(this.taskExecutor);
    }

    public void checkForNewVersionDelayed() {
        if (!this.internalPreferences.isVersionCheckEnabled()) {
            return;
        }
        BackgroundTask.wrap(this::getNewVersion).onSuccess(version -> this.showUpdateInfo((Optional<Version>)version, false)).onFailure(exception -> this.showConnectionError((Exception)exception, false)).scheduleWith(this.taskExecutor, 30L, TimeUnit.SECONDS);
    }

    private void showConnectionError(Exception exception, boolean manualExecution) {
        if (manualExecution) {
            String couldNotConnect = Localization.lang("Could not connect to the update server.", new Object[0]);
            String tryLater = Localization.lang("Please try again later and/or check your network connection.", new Object[0]);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error", new Object[0]), couldNotConnect + "\n" + tryLater, exception);
        }
        LOGGER.debug("Could not connect to the update server.", (Throwable)exception);
    }

    private void showUpdateInfo(Optional<Version> newerVersion, boolean manualExecution) {
        if (newerVersion.isEmpty() || newerVersion.get().equals(this.internalPreferences.getIgnoredVersion()) && !manualExecution) {
            if (manualExecution) {
                this.dialogService.notify(Localization.lang("JabRef is up-to-date.", new Object[0]));
            }
        } else if (this.dialogService.showCustomDialogAndWait(new NewVersionDialog(this.installedVersion, newerVersion.get(), this.dialogService, this.filePreferences)).orElse(true).booleanValue()) {
            this.internalPreferences.setIgnoredVersion(newerVersion.get());
        }
    }
}

