/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.tobiasdiez.easybind.EasyBind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.groups.GroupDialogHeader;
import org.jabref.gui.groups.GroupDialogView;
import org.jabref.gui.groups.GroupNodeViewModel;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticKeywordGroup;
import org.jabref.model.groups.AutomaticPersonsGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.RegexKeywordGroup;
import org.jabref.model.groups.SearchGroup;
import org.jabref.model.groups.TexGroup;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.metadata.MetaData;
import org.jabref.preferences.PreferencesService;

public class GroupTreeViewModel
extends AbstractViewModel {
    private final ObjectProperty<GroupNodeViewModel> rootGroup = new SimpleObjectProperty();
    private final ListProperty<GroupNodeViewModel> selectedGroups = new SimpleListProperty(FXCollections.observableArrayList());
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final TaskExecutor taskExecutor;
    private final CustomLocalDragboard localDragboard;
    private final ObjectProperty<Predicate<GroupNodeViewModel>> filterPredicate = new SimpleObjectProperty();
    private final StringProperty filterText = new SimpleStringProperty();
    private final Comparator<GroupTreeNode> compAlphabetIgnoreCase = (v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName());
    private final Comparator<GroupTreeNode> compAlphabetIgnoreCaseReverse = (v1, v2) -> v2.getName().compareToIgnoreCase(v1.getName());
    private final Comparator<GroupTreeNode> compEntries = (v1, v2) -> {
        int numChildren1 = v1.getEntriesInGroup(this.currentDatabase.get().getEntries()).size();
        int numChildren2 = v2.getEntriesInGroup(this.currentDatabase.get().getEntries()).size();
        return Integer.compare(numChildren2, numChildren1);
    };
    private final Comparator<GroupTreeNode> compEntriesReverse = (v1, v2) -> {
        int numChildren1 = v1.getEntriesInGroup(this.currentDatabase.get().getEntries()).size();
        int numChildren2 = v2.getEntriesInGroup(this.currentDatabase.get().getEntries()).size();
        return Integer.compare(numChildren1, numChildren2);
    };
    private Optional<BibDatabaseContext> currentDatabase = Optional.empty();

    public GroupTreeViewModel(StateManager stateManager, DialogService dialogService, PreferencesService preferencesService, TaskExecutor taskExecutor, CustomLocalDragboard localDragboard) {
        this.stateManager = Objects.requireNonNull(stateManager);
        this.dialogService = Objects.requireNonNull(dialogService);
        this.preferences = Objects.requireNonNull(preferencesService);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.localDragboard = Objects.requireNonNull(localDragboard);
        EasyBind.subscribe(stateManager.activeDatabaseProperty(), this::onActiveDatabaseChanged);
        EasyBind.subscribe(this.selectedGroups, this::onSelectedGroupChanged);
        this.filterPredicate.bind((ObservableValue)EasyBind.map((ObservableValue)this.filterText, text -> group -> group.isMatchedBy((String)text)));
        this.refresh();
    }

    private void refresh() {
        this.onActiveDatabaseChanged((Optional)this.stateManager.activeDatabaseProperty().getValue());
    }

    public ObjectProperty<GroupNodeViewModel> rootGroupProperty() {
        return this.rootGroup;
    }

    public ListProperty<GroupNodeViewModel> selectedGroupsProperty() {
        return this.selectedGroups;
    }

    public ObjectProperty<Predicate<GroupNodeViewModel>> filterPredicateProperty() {
        return this.filterPredicate;
    }

    public StringProperty filterTextProperty() {
        return this.filterText;
    }

    private void onSelectedGroupChanged(ObservableList<GroupNodeViewModel> newValue) {
        if (!this.currentDatabase.equals(this.stateManager.activeDatabaseProperty().getValue())) {
            return;
        }
        this.currentDatabase.ifPresent(database -> {
            if (newValue == null || newValue.isEmpty()) {
                this.stateManager.clearSelectedGroups((BibDatabaseContext)database);
            } else {
                this.stateManager.setSelectedGroups((BibDatabaseContext)database, newValue.stream().map(GroupNodeViewModel::getGroupNode).collect(Collectors.toList()));
            }
        });
    }

    public void addNewGroupToRoot() {
        if (this.currentDatabase.isPresent()) {
            this.addNewSubgroup((GroupNodeViewModel)this.rootGroup.get(), GroupDialogHeader.GROUP);
        } else {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Cannot create group", new Object[0]), Localization.lang("Cannot create group. Please create a library first.", new Object[0]));
        }
    }

    private void onActiveDatabaseChanged(Optional<BibDatabaseContext> newDatabase) {
        if (newDatabase.isPresent()) {
            GroupNodeViewModel newRoot = newDatabase.map(BibDatabaseContext::getMetaData).flatMap(MetaData::getGroups).map(root -> new GroupNodeViewModel((BibDatabaseContext)newDatabase.get(), this.stateManager, this.taskExecutor, (GroupTreeNode)root, this.localDragboard, this.preferences)).orElse(GroupNodeViewModel.getAllEntriesGroup(newDatabase.get(), this.stateManager, this.taskExecutor, this.localDragboard, this.preferences));
            this.rootGroup.setValue((Object)newRoot);
            if (this.stateManager.getSelectedGroups(newDatabase.get()).isEmpty()) {
                this.stateManager.setSelectedGroups(newDatabase.get(), Collections.singletonList(newRoot.getGroupNode()));
            }
            this.selectedGroups.setAll((Collection)this.stateManager.getSelectedGroups(newDatabase.get()).stream().map(selectedGroup -> new GroupNodeViewModel((BibDatabaseContext)newDatabase.get(), this.stateManager, this.taskExecutor, (GroupTreeNode)selectedGroup, this.localDragboard, this.preferences)).collect(Collectors.toList()));
        } else {
            this.rootGroup.setValue(null);
        }
        this.currentDatabase = newDatabase;
    }

    public void addNewSubgroup(GroupNodeViewModel parent, GroupDialogHeader groupDialogHeader) {
        this.currentDatabase.ifPresent(database -> {
            Optional<AbstractGroup> newGroup = this.dialogService.showCustomDialogAndWait(new GroupDialogView((BibDatabaseContext)database, parent.getGroupNode(), null, groupDialogHeader));
            newGroup.ifPresent(group -> {
                GroupTreeNode newSubgroup = parent.addSubgroup((AbstractGroup)group);
                this.selectedGroups.setAll((Object[])new GroupNodeViewModel[]{new GroupNodeViewModel((BibDatabaseContext)database, this.stateManager, this.taskExecutor, newSubgroup, this.localDragboard, this.preferences)});
                this.dialogService.notify(Localization.lang("Added group \"%0\".", group.getName()));
                this.writeGroupChangesToMetaData();
            });
        });
    }

    public void writeGroupChangesToMetaData() {
        this.currentDatabase.ifPresent(database -> database.getMetaData().setGroups(((GroupNodeViewModel)this.rootGroup.get()).getGroupNode()));
    }

    private boolean isGroupTypeEqual(AbstractGroup oldGroup, AbstractGroup newGroup) {
        return oldGroup.getClass().equals(newGroup.getClass());
    }

    boolean onlyMinorChanges(AbstractGroup oldGroup, AbstractGroup newGroup) {
        if (oldGroup.getClass() == WordKeywordGroup.class) {
            WordKeywordGroup oldWordKeywordGroup = (WordKeywordGroup)oldGroup;
            WordKeywordGroup newWordKeywordGroup = (WordKeywordGroup)newGroup;
            return Objects.equals(oldWordKeywordGroup.getSearchField().getName(), newWordKeywordGroup.getSearchField().getName()) && Objects.equals(oldWordKeywordGroup.getSearchExpression(), newWordKeywordGroup.getSearchExpression()) && Objects.equals(oldWordKeywordGroup.isCaseSensitive(), newWordKeywordGroup.isCaseSensitive());
        }
        if (oldGroup.getClass() == RegexKeywordGroup.class) {
            RegexKeywordGroup oldRegexKeywordGroup = (RegexKeywordGroup)oldGroup;
            RegexKeywordGroup newRegexKeywordGroup = (RegexKeywordGroup)newGroup;
            return Objects.equals(oldRegexKeywordGroup.getSearchField().getName(), newRegexKeywordGroup.getSearchField().getName()) && Objects.equals(oldRegexKeywordGroup.getSearchExpression(), newRegexKeywordGroup.getSearchExpression()) && Objects.equals(oldRegexKeywordGroup.isCaseSensitive(), newRegexKeywordGroup.isCaseSensitive());
        }
        if (oldGroup.getClass() == SearchGroup.class) {
            SearchGroup oldSearchGroup = (SearchGroup)oldGroup;
            SearchGroup newSearchGroup = (SearchGroup)newGroup;
            return Objects.equals(oldSearchGroup.getSearchExpression(), newSearchGroup.getSearchExpression()) && Objects.equals(oldSearchGroup.getSearchFlags(), newSearchGroup.getSearchFlags());
        }
        if (oldGroup.getClass() == AutomaticKeywordGroup.class) {
            AutomaticKeywordGroup oldAutomaticKeywordGroup = (AutomaticKeywordGroup)oldGroup;
            AutomaticKeywordGroup newAutomaticKeywordGroup = (AutomaticKeywordGroup)oldGroup;
            return Objects.equals(oldAutomaticKeywordGroup.getKeywordDelimiter(), newAutomaticKeywordGroup.getKeywordDelimiter()) && Objects.equals(oldAutomaticKeywordGroup.getKeywordHierarchicalDelimiter(), newAutomaticKeywordGroup.getKeywordHierarchicalDelimiter()) && Objects.equals(oldAutomaticKeywordGroup.getField().getName(), newAutomaticKeywordGroup.getField().getName());
        }
        if (oldGroup.getClass() == AutomaticPersonsGroup.class) {
            AutomaticPersonsGroup oldAutomaticPersonsGroup = (AutomaticPersonsGroup)oldGroup;
            AutomaticPersonsGroup newAutomaticPersonsGroup = (AutomaticPersonsGroup)newGroup;
            return Objects.equals(oldAutomaticPersonsGroup.getField().getName(), newAutomaticPersonsGroup.getField().getName());
        }
        if (oldGroup.getClass() == TexGroup.class) {
            TexGroup oldTexGroup = (TexGroup)oldGroup;
            TexGroup newTexGroup = (TexGroup)newGroup;
            return Objects.equals(oldTexGroup.getFilePath().toString(), newTexGroup.getFilePath().toString());
        }
        return true;
    }

    public void editGroup(GroupNodeViewModel oldGroup) {
        this.currentDatabase.ifPresent(database -> {
            Optional<AbstractGroup> newGroup = this.dialogService.showCustomDialogAndWait(new GroupDialogView((BibDatabaseContext)database, oldGroup.getGroupNode().getParent().orElse(null), oldGroup.getGroupNode().getGroup(), GroupDialogHeader.SUBGROUP));
            newGroup.ifPresent(group -> {
                boolean onlyMinorModifications;
                AbstractGroup oldGroupDef = oldGroup.getGroupNode().getGroup();
                String oldGroupName = oldGroupDef.getName();
                boolean groupTypeEqual = this.isGroupTypeEqual(oldGroupDef, (AbstractGroup)group);
                boolean bl = onlyMinorModifications = groupTypeEqual && this.onlyMinorChanges(oldGroupDef, (AbstractGroup)group);
                if (groupTypeEqual && !group.getName().equals(oldGroupName) && onlyMinorModifications) {
                    int groupsWithSameName = 0;
                    Optional<GroupTreeNode> databaseRootGroup = this.currentDatabase.get().getMetaData().getGroups();
                    if (databaseRootGroup.isPresent()) {
                        groupsWithSameName = databaseRootGroup.get().findChildrenSatisfying(g -> g.getName().equals(oldGroupName)).size();
                    }
                    boolean removePreviousAssignments = true;
                    if (groupsWithSameName >= 2) {
                        removePreviousAssignments = false;
                    }
                    oldGroup.getGroupNode().setGroup((AbstractGroup)group, true, removePreviousAssignments, database.getEntries());
                    this.dialogService.notify(Localization.lang("Modified group \"%0\".", group.getName()));
                    this.writeGroupChangesToMetaData();
                    this.refresh();
                    return;
                }
                if (groupTypeEqual && this.onlyMinorChanges(oldGroup.getGroupNode().getGroup(), (AbstractGroup)group)) {
                    oldGroup.getGroupNode().setGroup((AbstractGroup)group, true, true, database.getEntries());
                    this.writeGroupChangesToMetaData();
                    this.refresh();
                    return;
                }
                Object content = Localization.lang("Assign the original group's entries to this group?", new Object[0]);
                ButtonType keepAssignments = new ButtonType(Localization.lang("Assign", new Object[0]), ButtonBar.ButtonData.YES);
                ButtonType removeAssignments = new ButtonType(Localization.lang("Do not assign", new Object[0]), ButtonBar.ButtonData.NO);
                ButtonType cancel = new ButtonType(Localization.lang("Cancel", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
                if (((AbstractGroup)newGroup.get()).getClass() == WordKeywordGroup.class) {
                    content = (String)content + "\n\n" + Localization.lang("(Note: If original entries lack keywords to qualify for the new group configuration, confirming here will add them)", new Object[0]);
                }
                Optional<ButtonType> previousAssignments = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.WARNING, Localization.lang("Change of Grouping Method", new Object[0]), (String)content, keepAssignments, removeAssignments, cancel);
                boolean removePreviousAssignments = oldGroup.getGroupNode().getGroup() instanceof ExplicitGroup && group instanceof ExplicitGroup;
                int groupsWithSameName = 0;
                Optional<GroupTreeNode> databaseRootGroup = this.currentDatabase.get().getMetaData().getGroups();
                if (databaseRootGroup.isPresent()) {
                    String name = oldGroup.getGroupNode().getGroup().getName();
                    groupsWithSameName = databaseRootGroup.get().findChildrenSatisfying(g -> g.getName().equals(name)).size();
                }
                if (groupsWithSameName >= 2) {
                    removePreviousAssignments = false;
                }
                if (previousAssignments.isPresent() && previousAssignments.get().getButtonData() == ButtonBar.ButtonData.YES) {
                    oldGroup.getGroupNode().setGroup((AbstractGroup)group, true, removePreviousAssignments, database.getEntries());
                } else if (previousAssignments.isPresent() && previousAssignments.get().getButtonData() == ButtonBar.ButtonData.NO) {
                    oldGroup.getGroupNode().setGroup((AbstractGroup)group, false, removePreviousAssignments, database.getEntries());
                } else if (previousAssignments.isPresent() && previousAssignments.get().getButtonData() == ButtonBar.ButtonData.CANCEL_CLOSE) {
                    return;
                }
                this.dialogService.notify(Localization.lang("Modified group \"%0\".", group.getName()));
                this.writeGroupChangesToMetaData();
                this.refresh();
            });
        });
    }

    public void removeSubgroups(GroupNodeViewModel group) {
        boolean confirmation = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove subgroups", new Object[0]), Localization.lang("Remove all subgroups of \"%0\"?", group.getDisplayName()));
        if (confirmation) {
            for (GroupNodeViewModel child : group.getChildren()) {
                this.removeGroupsAndSubGroupsFromEntries(child);
            }
            group.getGroupNode().removeAllChildren();
            this.dialogService.notify(Localization.lang("Removed all subgroups of group \"%0\".", group.getDisplayName()));
            this.writeGroupChangesToMetaData();
        }
    }

    public void removeGroupKeepSubgroups(GroupNodeViewModel group) {
        boolean confirmed = this.selectedGroups.size() <= 1 ? this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove group", new Object[0]), Localization.lang("Remove group \"%0\" and keep its subgroups?", group.getDisplayName()), Localization.lang("Remove", new Object[0])) : this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove groups", new Object[0]), Localization.lang("Remove all selected groups and keep their subgroups?", new Object[0]), Localization.lang("Remove all", new Object[0]));
        if (confirmed) {
            ArrayList<GroupNodeViewModel> selectedGroupNodes = new ArrayList<GroupNodeViewModel>((Collection<GroupNodeViewModel>)this.selectedGroups);
            selectedGroupNodes.forEach(eachNode -> {
                GroupTreeNode groupNode = eachNode.getGroupNode();
                groupNode.getParent().ifPresent(parent -> groupNode.moveAllChildrenTo(parent, parent.getIndexOfChild(groupNode).get()));
                groupNode.removeFromParent();
            });
            if (selectedGroupNodes.size() > 1) {
                this.dialogService.notify(Localization.lang("Removed all selected groups.", new Object[0]));
            } else {
                this.dialogService.notify(Localization.lang("Removed group \"%0\".", group.getDisplayName()));
            }
            this.writeGroupChangesToMetaData();
        }
    }

    public void removeGroupAndSubgroups(GroupNodeViewModel group) {
        boolean confirmed = this.selectedGroups.size() <= 1 ? this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove group and subgroups", new Object[0]), Localization.lang("Remove group \"%0\" and its subgroups?", group.getDisplayName()), Localization.lang("Remove", new Object[0])) : this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove groups and subgroups", new Object[0]), Localization.lang("Remove all selected groups and their subgroups?", new Object[0]), Localization.lang("Remove all", new Object[0]));
        if (confirmed) {
            ArrayList<GroupNodeViewModel> selectedGroupNodes = new ArrayList<GroupNodeViewModel>((Collection<GroupNodeViewModel>)this.selectedGroups);
            selectedGroupNodes.forEach(eachNode -> {
                this.removeGroupsAndSubGroupsFromEntries((GroupNodeViewModel)eachNode);
                eachNode.getGroupNode().removeFromParent();
            });
            if (selectedGroupNodes.size() > 1) {
                this.dialogService.notify(Localization.lang("Removed all selected groups and their subgroups.", new Object[0]));
            } else {
                this.dialogService.notify(Localization.lang("Removed group \"%0\" and its subgroups.", group.getDisplayName()));
            }
            this.writeGroupChangesToMetaData();
        }
    }

    public void removeGroupNoSubgroups(GroupNodeViewModel group) {
        boolean confirmed = this.selectedGroups.size() <= 1 ? this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove group", new Object[0]), Localization.lang("Remove group \"%0\"?", group.getDisplayName()), Localization.lang("Remove", new Object[0])) : this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove groups and subgroups", new Object[0]), Localization.lang("Remove all selected groups and their subgroups?", new Object[0]), Localization.lang("Remove all", new Object[0]));
        if (confirmed) {
            ArrayList<GroupNodeViewModel> selectedGroupNodes = new ArrayList<GroupNodeViewModel>((Collection<GroupNodeViewModel>)this.selectedGroups);
            selectedGroupNodes.forEach(eachNode -> {
                this.removeGroupsAndSubGroupsFromEntries((GroupNodeViewModel)eachNode);
                eachNode.getGroupNode().removeFromParent();
            });
            if (selectedGroupNodes.size() > 1) {
                this.dialogService.notify(Localization.lang("Removed all selected groups.", new Object[0]));
            } else {
                this.dialogService.notify(Localization.lang("Removed group \"%0\".", group.getDisplayName()));
            }
            this.writeGroupChangesToMetaData();
        }
    }

    void removeGroupsAndSubGroupsFromEntries(GroupNodeViewModel group) {
        for (GroupNodeViewModel child : group.getChildren()) {
            this.removeGroupsAndSubGroupsFromEntries(child);
        }
        if (group.getGroupNode().getGroup() instanceof ExplicitGroup) {
            int groupsWithSameName = 0;
            String name = group.getGroupNode().getGroup().getName();
            Optional<GroupTreeNode> rootGroup = this.currentDatabase.get().getMetaData().getGroups();
            if (rootGroup.isPresent()) {
                groupsWithSameName = rootGroup.get().findChildrenSatisfying(g -> g.getName().equals(name)).size();
            }
            if (groupsWithSameName < 2) {
                List<BibEntry> entriesInGroup = group.getGroupNode().getEntriesInGroup(this.currentDatabase.get().getEntries());
                group.getGroupNode().removeEntriesFromGroup(entriesInGroup);
            }
        }
    }

    public void addSelectedEntries(GroupNodeViewModel group) {
        group.getGroupNode().addEntriesToGroup((Collection<BibEntry>)this.stateManager.getSelectedEntries());
    }

    public void removeSelectedEntries(GroupNodeViewModel group) {
        group.getGroupNode().removeEntriesFromGroup((List<BibEntry>)this.stateManager.getSelectedEntries());
    }

    public void sortAlphabeticallyRecursive(GroupTreeNode group) {
        group.sortChildren(this.compAlphabetIgnoreCase, true);
    }

    public void sortReverseAlphabeticallyRecursive(GroupTreeNode group) {
        group.sortChildren(this.compAlphabetIgnoreCaseReverse, true);
    }

    public void sortEntriesRecursive(GroupTreeNode group) {
        group.sortChildren(this.compEntries, true);
    }

    public void sortReverseEntriesRecursive(GroupTreeNode group) {
        group.sortChildren(this.compEntriesReverse, true);
    }
}

