/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.DialogService;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileHistory;

public class FileHistoryMenu
extends Menu {
    protected final MenuItem clearRecentLibraries;
    private final FileHistory history;
    private final DialogService dialogService;
    private final OpenDatabaseAction openDatabaseAction;

    public FileHistoryMenu(FileHistory fileHistory, DialogService dialogService, OpenDatabaseAction openDatabaseAction) {
        this.setText(Localization.lang("Recent libraries", new Object[0]));
        this.clearRecentLibraries = new MenuItem();
        this.clearRecentLibraries.setText(Localization.lang("Clear recent libraries", new Object[0]));
        this.clearRecentLibraries.setOnAction(event -> this.clearLibrariesHistory());
        this.history = fileHistory;
        this.dialogService = dialogService;
        this.openDatabaseAction = openDatabaseAction;
        if (this.history.isEmpty()) {
            this.setDisable(true);
        } else {
            this.setItems();
        }
    }

    public boolean openFileByKey(KeyEvent keyEvent) {
        if (keyEvent.getCharacter() == null) {
            return false;
        }
        char key = keyEvent.getCharacter().charAt(0);
        int num = Character.getNumericValue(key);
        if (num <= 0 || num > this.history.size()) {
            return false;
        }
        this.openFile(this.history.get(Integer.parseInt(keyEvent.getCharacter()) - 1));
        return true;
    }

    public void newFile(Path file) {
        this.history.newFile(file);
        this.setItems();
        this.setDisable(false);
    }

    private void setItems() {
        this.getItems().clear();
        for (int index = 0; index < this.history.size(); ++index) {
            this.addItem(this.history.get(index), index + 1);
        }
        this.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), this.clearRecentLibraries});
    }

    private void addItem(Path file, int num) {
        String number = Integer.toString(num);
        MenuItem item = new MenuItem(number + ". " + String.valueOf(file));
        item.setMnemonicParsing(false);
        item.setOnAction(event -> this.openFile(file));
        this.getItems().add((Object)item);
    }

    public void openFile(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new Object[0]), Localization.lang("File not found", new Object[0]) + ": " + String.valueOf(file));
            this.history.removeItem(file);
            this.setItems();
            return;
        }
        this.openDatabaseAction.openFile(file);
    }

    public void clearLibrariesHistory() {
        this.history.clear();
        this.setDisable(true);
    }
}

