/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.linkedfile.DeleteFileAction;
import org.jabref.gui.linkedfile.DownloadLinkedFileAction;
import org.jabref.gui.linkedfile.LinkedFileEditDialogView;
import org.jabref.gui.mergeentries.MultiMergeEntriesView;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.externalfiles.LinkedFileHandler;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.PdfContentImporter;
import org.jabref.logic.importer.fileformat.PdfEmbeddedBibFileImporter;
import org.jabref.logic.importer.fileformat.PdfGrobidImporter;
import org.jabref.logic.importer.fileformat.PdfVerbatimBibTextImporter;
import org.jabref.logic.importer.fileformat.PdfXmpImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedFileViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedFileViewModel.class);
    private final LinkedFile linkedFile;
    private final BibDatabaseContext databaseContext;
    private final DoubleProperty downloadProgress = new SimpleDoubleProperty(-1.0);
    private final BooleanProperty downloadOngoing = new SimpleBooleanProperty(false);
    private final BooleanProperty isAutomaticallyFound = new SimpleBooleanProperty(false);
    private final BooleanProperty isOfflinePdf = new SimpleBooleanProperty(false);
    private final DialogService dialogService;
    private final BibEntry entry;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferencesService;
    private final LinkedFileHandler linkedFileHandler;
    private ObjectBinding<Node> linkedFileIconBinding;
    private final Validator fileExistsValidator;

    public LinkedFileViewModel(LinkedFile linkedFile, BibEntry entry, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, DialogService dialogService, PreferencesService preferencesService) {
        this.linkedFile = linkedFile;
        this.preferencesService = preferencesService;
        this.linkedFileHandler = new LinkedFileHandler(linkedFile, entry, databaseContext, preferencesService.getFilePreferences());
        this.databaseContext = databaseContext;
        this.entry = entry;
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.fileExistsValidator = new FunctionBasedValidator((ObservableValue)linkedFile.linkProperty(), link -> {
            if (linkedFile.isOnlineLink()) {
                return true;
            }
            Optional<Path> path = FileUtil.find(databaseContext, link, preferencesService.getFilePreferences());
            return path.isPresent() && Files.exists(path.get(), new LinkOption[0]);
        }, ValidationMessage.warning((String)Localization.lang("Could not find file '%0'.", linkedFile.getLink())));
        this.downloadOngoing.bind((ObservableValue)this.downloadProgress.greaterThanOrEqualTo(0).and((ObservableBooleanValue)this.downloadProgress.lessThan(1)));
        this.isOfflinePdf.setValue(Boolean.valueOf(!linkedFile.isOnlineLink() && "pdf".equalsIgnoreCase(linkedFile.getFileType())));
    }

    public BooleanProperty isOfflinePdfProperty() {
        return this.isOfflinePdf;
    }

    public boolean isAutomaticallyFound() {
        return this.isAutomaticallyFound.get();
    }

    public BooleanProperty isAutomaticallyFoundProperty() {
        return this.isAutomaticallyFound;
    }

    public BooleanProperty downloadOngoingProperty() {
        return this.downloadOngoing;
    }

    public DoubleProperty downloadProgressProperty() {
        return this.downloadProgress;
    }

    public StringProperty linkProperty() {
        return this.linkedFile.linkProperty();
    }

    public StringProperty descriptionProperty() {
        return this.linkedFile.descriptionProperty();
    }

    public String getDescription() {
        return this.linkedFile.getDescription();
    }

    public String getDescriptionAndLink() {
        if (StringUtil.isBlank(this.linkedFile.getDescription())) {
            return this.linkedFile.getLink();
        }
        return this.linkedFile.getDescription() + " (" + this.linkedFile.getLink() + ")";
    }

    public String getTruncatedDescriptionAndLink() {
        if (StringUtil.isBlank(this.linkedFile.getDescription())) {
            return ControlHelper.truncateString(this.linkedFile.getLink(), -1, "...", ControlHelper.EllipsisPosition.CENTER);
        }
        return ControlHelper.truncateString(this.linkedFile.getDescription(), -1, "...", ControlHelper.EllipsisPosition.CENTER) + " (" + ControlHelper.truncateString(this.linkedFile.getLink(), -1, "...", ControlHelper.EllipsisPosition.CENTER) + ")";
    }

    public Optional<Path> findIn(List<Path> directories) {
        return this.linkedFile.findIn(directories);
    }

    public JabRefIcon getTypeIcon() {
        return ExternalFileTypes.getExternalFileTypeByLinkedFile(this.linkedFile, false, this.preferencesService.getFilePreferences()).map(ExternalFileType::getIcon).orElse(IconTheme.JabRefIcons.FILE);
    }

    public ObjectBinding<Node> typeIconProperty() {
        if (this.linkedFileIconBinding == null) {
            this.linkedFileIconBinding = Bindings.createObjectBinding(() -> this.getTypeIcon().getGraphicNode(), (Observable[])new Observable[]{this.linkedFile.fileTypeProperty()});
        }
        return this.linkedFileIconBinding;
    }

    public void markAsAutomaticallyFound() {
        this.isAutomaticallyFound.setValue(Boolean.valueOf(true));
    }

    public void acceptAsLinked() {
        this.isAutomaticallyFound.setValue(Boolean.valueOf(false));
    }

    public Observable[] getObservables() {
        ArrayList<Observable> observables = new ArrayList<Observable>(Arrays.asList(this.linkedFile.getObservables()));
        observables.add((Observable)this.downloadOngoing);
        observables.add((Observable)this.downloadProgress);
        observables.add((Observable)this.isAutomaticallyFound);
        return observables.toArray(new Observable[0]);
    }

    public void open() {
        try {
            Optional<ExternalFileType> type = ExternalFileTypes.getExternalFileTypeByLinkedFile(this.linkedFile, true, this.preferencesService.getFilePreferences());
            boolean successful = JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.preferencesService.getFilePreferences(), this.linkedFile.getLink(), type);
            if (!successful) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new Object[0]), Localization.lang("Could not find file '%0'.", this.linkedFile.getLink()));
            }
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error opening file '%0'", this.linkedFile.getLink()), e);
        }
    }

    public void openFolder() {
        try {
            if (!this.linkedFile.isOnlineLink()) {
                Optional<Path> resolvedPath = FileUtil.find(this.databaseContext, this.linkedFile.getLink(), this.preferencesService.getFilePreferences());
                if (resolvedPath.isPresent()) {
                    JabRefDesktop.openFolderAndSelectFile(resolvedPath.get(), this.preferencesService.getExternalApplicationsPreferences(), this.dialogService);
                } else {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new Object[0]));
                }
            } else {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Cannot open folder as the file is an online link.", new Object[0]));
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Cannot open folder", (Throwable)ex);
        }
    }

    public void renameToSuggestion() {
        this.renameFileToName(this.linkedFileHandler.getSuggestedFileName());
    }

    public void askForNameAndRename() {
        String oldFile = this.linkedFile.getLink();
        Path oldFilePath = Path.of(oldFile, new String[0]);
        Optional<String> askedFileName = this.dialogService.showInputDialogWithDefaultAndWait(Localization.lang("Rename file", new Object[0]), Localization.lang("New Filename", new Object[0]), oldFilePath.getFileName().toString());
        askedFileName.ifPresent(this::renameFileToName);
    }

    public void renameFileToName(String targetFileName) {
        if (this.linkedFile.isOnlineLink()) {
            return;
        }
        Optional<Path> file = this.linkedFile.findIn(this.databaseContext, this.preferencesService.getFilePreferences());
        if (file.isPresent()) {
            this.performRenameWithConflictCheck(targetFileName);
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new Object[0]), Localization.lang("Could not find file '%0'.", this.linkedFile.getLink()));
        }
    }

    private void performRenameWithConflictCheck(String targetFileName) {
        Optional<Path> existingFile = this.linkedFileHandler.findExistingFile(this.linkedFile, this.entry, targetFileName);
        boolean overwriteFile = false;
        if (existingFile.isPresent() && !(overwriteFile = this.dialogService.showConfirmationDialogAndWait(Localization.lang("File exists", new Object[0]), Localization.lang("'%0' exists. Overwrite file?", targetFileName), Localization.lang("Overwrite", new Object[0])))) {
            return;
        }
        try {
            this.linkedFileHandler.renameToName(targetFileName, overwriteFile);
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Rename failed", new Object[0]), Localization.lang("JabRef cannot access the file because it is being used by another process.", new Object[0]));
        }
    }

    public void moveToDefaultDirectory() {
        if (this.linkedFile.isOnlineLink()) {
            return;
        }
        Optional<Path> fileDir = this.databaseContext.getFirstExistingFileDir(this.preferencesService.getFilePreferences());
        if (fileDir.isEmpty()) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Move file", new Object[0]), Localization.lang("File directory is not set or does not exist!", new Object[0]));
            return;
        }
        Optional<Path> file = this.linkedFile.findIn(this.databaseContext, this.preferencesService.getFilePreferences());
        if (file.isPresent()) {
            try {
                this.linkedFileHandler.moveToDefaultDirectory();
            }
            catch (IOException exception) {
                this.dialogService.showErrorDialogAndWait(Localization.lang("Move file", new Object[0]), Localization.lang("Could not move file '%0'.", file.get().toString()), exception);
            }
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("File not found", new Object[0]), Localization.lang("Could not find file '%0'.", this.linkedFile.getLink()));
        }
    }

    public boolean isGeneratedNameSameAsOriginal() {
        Path file = Path.of(this.linkedFile.getLink(), new String[0]);
        String currentFileName = file.getFileName().toString();
        String suggestedFileName = this.linkedFileHandler.getSuggestedFileName();
        return currentFileName.equals(suggestedFileName);
    }

    public boolean isGeneratedPathSameAsOriginal() {
        FilePreferences filePreferences = this.preferencesService.getFilePreferences();
        Optional<Path> baseDir = this.databaseContext.getFirstExistingFileDir(filePreferences);
        if (baseDir.isEmpty()) {
            return false;
        }
        String targetDirectoryName = FileUtil.createDirNameFromPattern(this.databaseContext.getDatabase(), this.entry, filePreferences.getFileDirectoryPattern());
        Optional<Path> targetDir = baseDir.map(dir -> dir.resolve(targetDirectoryName));
        Optional<Path> currentDir = this.linkedFile.findIn(this.databaseContext, this.preferencesService.getFilePreferences()).map(Path::getParent);
        if (currentDir.isEmpty()) {
            return false;
        }
        BiPredicate<Path, Path> equality = (fileA, fileB) -> {
            try {
                return Files.isSameFile(fileA, fileB);
            }
            catch (IOException e) {
                return false;
            }
        };
        return OptionalUtil.equals(targetDir, currentDir, equality);
    }

    public void moveToDefaultDirectoryAndRename() {
        this.moveToDefaultDirectory();
        this.renameToSuggestion();
    }

    public boolean delete() {
        DeleteFileAction deleteFileAction = new DeleteFileAction(this.dialogService, this.preferencesService.getFilePreferences(), this.databaseContext, null, List.of(this));
        deleteFileAction.execute();
        return deleteFileAction.isSuccess();
    }

    public void edit() {
        Optional<LinkedFile> editedFile = this.dialogService.showCustomDialogAndWait(new LinkedFileEditDialogView(this.linkedFile));
        editedFile.ifPresent(file -> {
            this.linkedFile.setLink(file.getLink());
            this.linkedFile.setDescription(file.getDescription());
            this.linkedFile.setFileType(file.getFileType());
            this.linkedFile.setSourceURL(file.getSourceUrl());
        });
    }

    public void redownload() {
        LOGGER.info("Redownloading file from {}", (Object)this.linkedFile.getSourceUrl());
        if (this.linkedFile.getSourceUrl().isEmpty() || !LinkedFile.isOnlineLink(this.linkedFile.getSourceUrl())) {
            throw new UnsupportedOperationException("In order to download the file, the source url has to be an online link");
        }
        String fileName = Path.of(this.linkedFile.getLink(), new String[0]).getFileName().toString();
        DownloadLinkedFileAction downloadLinkedFileAction = new DownloadLinkedFileAction(this.databaseContext, this.entry, this.linkedFile, this.linkedFile.getSourceUrl(), this.dialogService, this.preferencesService.getFilePreferences(), this.taskExecutor, fileName, true);
        this.downloadProgress.bind((ObservableValue)downloadLinkedFileAction.downloadProgress());
        downloadLinkedFileAction.execute();
    }

    public void download(boolean keepHtmlLink) {
        LOGGER.info("Downloading file from {}", (Object)this.linkedFile.getSourceUrl());
        if (!this.linkedFile.isOnlineLink()) {
            throw new UnsupportedOperationException("In order to download the file it has to be an online link");
        }
        DownloadLinkedFileAction downloadLinkedFileAction = new DownloadLinkedFileAction(this.databaseContext, this.entry, this.linkedFile, this.linkedFile.getLink(), this.dialogService, this.preferencesService.getFilePreferences(), this.taskExecutor, "", keepHtmlLink);
        this.downloadProgress.bind((ObservableValue)downloadLinkedFileAction.downloadProgress());
        downloadLinkedFileAction.execute();
    }

    public LinkedFile getFile() {
        return this.linkedFile;
    }

    public ValidationStatus fileExistsValidationStatus() {
        return this.fileExistsValidator.getValidationStatus();
    }

    public void parsePdfMetadataAndShowMergeDialog() {
        this.linkedFile.findIn(this.databaseContext, this.preferencesService.getFilePreferences()).ifPresent(filePath -> {
            MultiMergeEntriesView dialog = new MultiMergeEntriesView(this.preferencesService, this.taskExecutor);
            dialog.setTitle(Localization.lang("Merge PDF metadata", new Object[0]));
            dialog.addSource(Localization.lang("Entry", new Object[0]), this.entry);
            dialog.addSource(Localization.lang("Verbatim", new Object[0]), this.wrapImporterToSupplier(new PdfVerbatimBibTextImporter(this.preferencesService.getImportFormatPreferences()), (Path)filePath));
            dialog.addSource(Localization.lang("Embedded", new Object[0]), this.wrapImporterToSupplier(new PdfEmbeddedBibFileImporter(this.preferencesService.getImportFormatPreferences()), (Path)filePath));
            if (this.preferencesService.getGrobidPreferences().isGrobidEnabled()) {
                dialog.addSource("Grobid", this.wrapImporterToSupplier(new PdfGrobidImporter(this.preferencesService.getImportFormatPreferences()), (Path)filePath));
            }
            dialog.addSource(Localization.lang("XMP metadata", new Object[0]), this.wrapImporterToSupplier(new PdfXmpImporter(this.preferencesService.getXmpPreferences()), (Path)filePath));
            dialog.addSource(Localization.lang("Content", new Object[0]), this.wrapImporterToSupplier(new PdfContentImporter(), (Path)filePath));
            this.dialogService.showCustomDialogAndWait(dialog).ifPresent(newEntry -> {
                this.databaseContext.getDatabase().removeEntry(this.entry);
                this.databaseContext.getDatabase().insertEntry((BibEntry)newEntry);
            });
        });
    }

    private Supplier<BibEntry> wrapImporterToSupplier(Importer importer, Path filePath) {
        return () -> {
            try {
                ParserResult parserResult = importer.importDatabase(filePath);
                if (parserResult.isInvalid() || parserResult.isEmpty() || !parserResult.getDatabase().hasEntries()) {
                    return null;
                }
                return (BibEntry)parserResult.getDatabase().getEntries().getFirst();
            }
            catch (IOException e) {
                return null;
            }
        };
    }
}

