/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.util.StringConverter;
import javax.swing.undo.UndoManager;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryLinkList;
import org.jabref.model.entry.ParsedEntryLink;
import org.jabref.model.entry.field.Field;

public class LinkedEntriesEditorViewModel
extends AbstractEditorViewModel {
    private final BibDatabaseContext databaseContext;
    private final SuggestionProvider<?> suggestionProvider;
    private final ListProperty<ParsedEntryLink> linkedEntries;
    private final StateManager stateManager;

    public LinkedEntriesEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, BibDatabaseContext databaseContext, FieldCheckers fieldCheckers, UndoManager undoManager, StateManager stateManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.databaseContext = databaseContext;
        this.suggestionProvider = suggestionProvider;
        this.stateManager = stateManager;
        this.linkedEntries = new SimpleListProperty(FXCollections.observableArrayList());
        BindingsHelper.bindContentBidirectional(this.linkedEntries, this.text, EntryLinkList::serialize, newText -> EntryLinkList.parse(newText, databaseContext.getDatabase()));
    }

    public ListProperty<ParsedEntryLink> linkedEntriesProperty() {
        return this.linkedEntries;
    }

    public StringConverter<ParsedEntryLink> getStringConverter() {
        return new StringConverter<ParsedEntryLink>(){

            public String toString(ParsedEntryLink linkedEntry) {
                if (linkedEntry == null) {
                    return "";
                }
                return linkedEntry.getKey();
            }

            public ParsedEntryLink fromString(String key) {
                return new ParsedEntryLink(key, LinkedEntriesEditorViewModel.this.databaseContext.getDatabase());
            }
        };
    }

    public List<ParsedEntryLink> getSuggestions(String request) {
        ParsedEntryLink requestedLink;
        List<ParsedEntryLink> suggestions = this.suggestionProvider.getPossibleSuggestions().stream().map(suggestion -> {
            String string;
            if (suggestion instanceof BibEntry) {
                BibEntry bibEntry = (BibEntry)suggestion;
                string = bibEntry.getCitationKey().orElse("");
            } else {
                string = (String)suggestion;
            }
            return string;
        }).filter(suggestion -> suggestion.toLowerCase(Locale.ROOT).contains(request.toLowerCase(Locale.ROOT))).map(suggestion -> new ParsedEntryLink((String)suggestion, this.databaseContext.getDatabase())).distinct().collect(Collectors.toList());
        if (!suggestions.contains(requestedLink = new ParsedEntryLink(request, this.databaseContext.getDatabase()))) {
            suggestions.addFirst(requestedLink);
        }
        return suggestions;
    }

    public void jumpToEntry(ParsedEntryLink parsedEntryLink) {
        parsedEntryLink.getLinkedEntry().ifPresent(entry -> ((Optional)this.stateManager.activeTabProperty().get()).ifPresent(tab -> tab.clearAndSelect((BibEntry)entry)));
    }
}

